/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl.netty;

import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverTransport;
import com.ibm.ws.sip.channel.resolver.impl.netty.SipResolverTransportListener;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.exception.NettyException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

class SipResolverTcpTransport
implements SipResolverTransport {
    private static final LogMgr c_logger = Log.get(SipResolverTcpTransport.class);
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 1500;
    private static final int WRITE_TIMEOUT = 60000;
    private static final int MAX_READ_TIMEOUT_COUNT = 5;
    private static final int MAX_WRITE_QUEUE_SIZE = 5000;
    private static final int WRITE_STATE_DISCONNECTED = 0;
    private static final int WRITE_STATE_CONNECTING = 1;
    private static final int WRITE_STATE_IDLE = 2;
    private static final int WRITE_STATE_WRITE_ACTIVE = 3;
    private static final int WRITE_STATE_SHUTDOWN = 4;
    private static final int READ_STATE_READING_LENGTH = 0;
    private static final int READ_STATE_READING_BODY = 1;
    private static final int READ_STATE_DISCONNECTED = 2;
    private static final int READ_STATE_SHUTDOWN = 3;
    private static String CHAINNAME = "SipResolver-tcp-outbound";
    private static NettyFramework _framework;
    private static boolean _channelInitialized;
    private static BootstrapExtended bootstrap;
    private boolean _shutdown = false;
    private Vector<InetSocketAddress> _nameServers = null;
    private Iterator<InetSocketAddress> _nameServerIterator = null;
    private Queue<ByteBuf> _requestQueue = new LinkedList<ByteBuf>();
    private ByteBuf[] _bufferArray = new ByteBuf[2];
    private ByteBuf _lengthBuffer;
    private int _outstandingRequestCount = 0;
    private int _readTimeoutCount = 0;
    private Queue<ByteBuf> readBuffers = new LinkedList<ByteBuf>();
    private int bytesRead = 0;
    private int bytesNeeded = 0;
    private boolean reConnectAllowed = false;
    private int _connectionFailedCount = -1;
    private int _transportErrorCount = 0;
    private int _ConnectFailuresAllowed = 2;
    private int _TransportErrorsAllowed = 3;
    protected Channel m_channel;
    private SipResolverTransportListener _transportListener = null;
    private InetSocketAddress _currentSocketAddress = null;
    private int _writeState = 0;
    private int _readState = 2;

    protected static synchronized void initialize(NettyFramework framework) {
        block3: {
            if (!_channelInitialized) {
                _framework = framework;
                _channelInitialized = true;
                try {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("ExternalName", CHAINNAME);
                    bootstrap = _framework.createTCPBootstrapOutbound(options);
                    _channelInitialized = true;
                }
                catch (NettyException e2) {
                    if (!c_logger.isTraceEntryExitEnabled()) break block3;
                    c_logger.traceDebug("SipResolverTcpTransport: initialize failed due to: " + (Object)((Object)e2));
                }
            }
        }
    }

    protected SipResolverTcpTransport(Vector<InetSocketAddress> nameServers, SipResolverTransportListener transportListener, NettyFramework netty) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: constructor: entry: id=" + this.hashCode());
        }
        SipResolverTcpTransport.initialize(netty);
        this._lengthBuffer = ByteBufAllocator.DEFAULT.buffer(2);
        this._nameServers = nameServers;
        this._nameServerIterator = this._nameServers.iterator();
        this._transportListener = transportListener;
        this._ConnectFailuresAllowed = this._nameServers.size() * 2;
        this._TransportErrorsAllowed = this._nameServers.size() * 3;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: contructor: _ConnectFailuresAllowed: " + this._ConnectFailuresAllowed);
            c_logger.traceDebug("SipResolverTcpTransport: contructor: _TransportErrorsAllowed: " + this._TransportErrorsAllowed);
        }
        this.reConnectAllowed = true;
        this._writeState = 0;
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
        bootstrap.handler((ChannelHandler)new SipResolverTCPInitializer(bootstrap.getBaseInitializer()));
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: constructor: exit");
        }
    }

    protected synchronized void shutdown() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: shutdown: entry: id=" + this.hashCode());
        }
        this._shutdown = true;
        this._requestQueue.clear();
        this._writeState = 4;
        this._readState = 3;
        if (this.m_channel != null) {
            try {
                _framework.stop(this.m_channel).sync();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: shutdown: exit");
        }
    }

    private synchronized void connect() {
        block9: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "SipResolverTcpTransport: connect: entry: id=" + this.hashCode());
            }
            if (this._connectionFailedCount != 0) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport: connect: Find DNS Server in list");
                }
                this._connectionFailedCount = 0;
                if (!this._nameServerIterator.hasNext()) {
                    this._nameServerIterator = this._nameServers.iterator();
                    this._currentSocketAddress = this._nameServerIterator.next();
                } else {
                    this._currentSocketAddress = this._nameServerIterator.next();
                }
            }
            this._writeState = 1;
            this._readState = 2;
            this._outstandingRequestCount = 0;
            this._readTimeoutCount = 0;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport:connect: SIP Resolver is connecting to: " + this._currentSocketAddress.getHostName() + ":" + this._currentSocketAddress.getPort());
            }
            try {
                _framework.startOutbound(bootstrap, this._currentSocketAddress.getHostString(), this._currentSocketAddress.getPort(), f -> {
                    if (f.isCancelled() || !f.isSuccess()) {
                        if (c_logger.isWarnEnabled()) {
                            c_logger.warn("Resolver channel exception during connect: " + f.cause().getMessage());
                        }
                        this.destroy((Exception)f.cause());
                    } else {
                        this.m_channel = f.channel();
                        this.ready();
                    }
                });
            }
            catch (NettyException e2) {
                e2.printStackTrace();
                if (!c_logger.isWarnEnabled()) break block9;
                c_logger.warn("Resolver channel exception during connect: " + e2.getMessage());
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: connect: exit: id=" + this.hashCode());
        }
    }

    @Override
    public synchronized void writeRequest(ByteBuf requestBuffer) throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: writeRequest: entry: id=" + this.hashCode());
        }
        if (this._shutdown) {
            throw new IllegalStateException("SIP TCP Resolver transport is shutdown.");
        }
        switch (this._writeState) {
            case 4: {
                if (!c_logger.isTraceDebugEnabled()) break;
                c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_SHUTDOWN");
                break;
            }
            case 2: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_IDLE");
                }
                this._lengthBuffer.clear();
                this._lengthBuffer.writeShort((int)((short)requestBuffer.readableBytes()));
                this._bufferArray[0] = this._lengthBuffer;
                this._bufferArray[1] = requestBuffer;
                ByteBuf newBuf = Unpooled.copiedBuffer((ByteBuf[])this._bufferArray);
                ++this._outstandingRequestCount;
                ChannelFuture writeFuture = this.m_channel.writeAndFlush((Object)newBuf, this.m_channel.newPromise().addListener(f -> {
                    if (f.isSuccess()) {
                        this.writeComplete();
                    } else {
                        this.writeError((Exception)f.cause());
                    }
                }));
                if (writeFuture.isDone()) break;
                this._writeState = 3;
                break;
            }
            case 3: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_WRITE_ACTIVE");
                }
                if (this._requestQueue.size() > 5000) {
                    throw new IOException("Maximum write queue size is being exceeded");
                }
                this._requestQueue.add(requestBuffer);
                break;
            }
            case 1: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_CONNECTING");
                }
                this._requestQueue.add(requestBuffer);
                break;
            }
            case 0: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_DISCONNECTED");
                }
                this._requestQueue.add(requestBuffer);
                if (!this.reConnectAllowed) break;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: (re)connect to DNS server");
                }
                this.connect();
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: writeRequest: exit");
        }
    }

    public void ready() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: ready: entry: id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport:ready: socket is ready");
        }
        if (c_logger.isEventEnabled()) {
            c_logger.info("info.sip.resolver.established.connection", null, this._currentSocketAddress.toString());
        }
        this.reConnectAllowed = false;
        this._connectionFailedCount = 0;
        this._readState = 0;
        this.m_channel.read();
        this.drainRequestQueue();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: ready: exit");
        }
    }

    public void destroy(Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: destroy: entry: id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: Connection failed to establish: " + e2);
        }
        if (c_logger.isWarnEnabled()) {
            c_logger.warn("warn.sip.resolver.failed.connection", null, this._currentSocketAddress.toString());
        }
        ++this._connectionFailedCount;
        this._writeState = 0;
        if (this._connectionFailedCount <= this._ConnectFailuresAllowed) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: calling transportError - _connectionFailedCount: " + this._connectionFailedCount);
            }
            this._transportListener.transportError(e2, this);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: calling transportFailed - _connectionFailedCount: " + this._connectionFailedCount);
            }
            this._transportErrorCount = 0;
            this._connectionFailedCount = 0;
            this._transportListener.transportFailed(e2, this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: destroy: exit");
        }
    }

    public void readComplete(ChannelHandlerContext ctx, ByteBuf msg) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: complete: entry: id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: complete: _readState: " + this._readState);
        }
        this._readTimeoutCount = 0;
        this._connectionFailedCount = 0;
        this._transportErrorCount = 0;
        boolean exit = false;
        while (!exit) {
            switch (this._readState) {
                case 0: {
                    msg.resetReaderIndex();
                    short length = msg.readShort();
                    this._readState = 1;
                    this.readBuffers.clear();
                    this.bytesRead = 0;
                    this.bytesNeeded = length;
                    if (!c_logger.isTraceDebugEnabled()) break;
                    c_logger.traceDebug("SipResolverTcpTransport: complete: doing read length of: " + length);
                    break;
                }
                case 1: {
                    if (this.bytesNeeded > this.bytesRead) {
                        this.bytesRead += msg.readableBytes();
                        this.readBuffers.add(msg);
                    }
                    if (this.bytesNeeded != this.bytesRead) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolverTcpTransport: READ_STATE_READING_BODY need more bytes: needed:read = " + this.bytesNeeded + ":" + this.bytesRead);
                        }
                        exit = true;
                        break;
                    }
                    if (this._outstandingRequestCount != 0) {
                        --this._outstandingRequestCount;
                    } else if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: complete: error: outstandingRequestCount can't decrement past 0");
                    }
                    this._transportListener.responseReceived(Unpooled.wrappedBuffer((ByteBuf[])this.readBuffers.toArray(new ByteBuf[this.readBuffers.size()])));
                    this._readState = 0;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: complete: doing new read for length");
                    }
                    exit = true;
                    break;
                }
                case 2: 
                case 3: {
                    exit = true;
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: complete: exit: id=" + this.hashCode());
        }
    }

    public void readError(Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: error(vc, read context, exception) ");
        }
        if (!this._shutdown) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: read error: exception " + e2);
            }
            if (e2 instanceof SocketTimeoutException || e2 instanceof AsyncTimeoutException) {
                if (this._outstandingRequestCount > 0 || this._readTimeoutCount > 5 || this._readState == 1) {
                    if (c_logger.isWarnEnabled() && this._outstandingRequestCount > 0) {
                        c_logger.warn("warn.sip.resolver.server.not.responding", null, this._currentSocketAddress.toString());
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: error: consecutive read timeouts: " + this._readTimeoutCount);
                    }
                    ++this._transportErrorCount;
                    if (this._outstandingRequestCount > 0 || this._readState == 1) {
                        ++this._connectionFailedCount;
                    }
                    this._readState = 2;
                    this._writeState = 0;
                    if (this._transportErrorCount < this._TransportErrorsAllowed) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolverTcpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
                        }
                        this._transportListener.transportError(e2, this);
                    } else {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolverTcpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
                        }
                        this._transportErrorCount = 0;
                        this._connectionFailedCount = 0;
                        this._transportListener.transportFailed(e2, this);
                    }
                } else {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: error: incrementing readTimeoutCount: " + this._readTimeoutCount);
                    }
                    ++this._readTimeoutCount;
                    this.m_channel.read();
                }
            } else {
                this._readState = 2;
                this._writeState = 0;
                ++this._transportErrorCount;
                ++this._connectionFailedCount;
                if (this._transportErrorCount < this._TransportErrorsAllowed) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
                    }
                    this._transportListener.transportError(e2, this);
                } else {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
                    }
                    this._transportErrorCount = 0;
                    this._connectionFailedCount = 0;
                    this._transportListener.transportFailed(e2, this);
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: error(vc, read context, exception)");
        }
    }

    @Override
    public void prepareForReConnect() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: prepareForReConnect");
        }
        this._requestQueue.clear();
        this.reConnectAllowed = true;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: prepareForReConnect");
        }
    }

    public void writeComplete() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: complete: write complete id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: complete: write completed sucessfully: " + this.hashCode());
        }
        this._connectionFailedCount = 0;
        this._transportErrorCount = 0;
        this.drainRequestQueue();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: complete: write complete id=" + this.hashCode());
        }
    }

    public void writeError(Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: error: write error id=" + this.hashCode());
        }
        e2.printStackTrace();
        if (this._shutdown) {
            return;
        }
        ++this._transportErrorCount;
        ++this._connectionFailedCount;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: error: write failed: " + this.hashCode());
        }
        this._writeState = 0;
        if (this._transportErrorCount < this._TransportErrorsAllowed) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
            }
            this._transportListener.transportError(e2, this);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
            }
            this._transportErrorCount = 0;
            this._connectionFailedCount = 0;
            this._transportListener.transportFailed(e2, this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: error: write error id=" + this.hashCode());
        }
    }

    private synchronized void drainRequestQueue() {
        block5: {
            ByteBuf requestBuffer;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "SipResolverTcpTransport: drainRequestQueue: entry: id=" + this.hashCode());
            }
            while ((requestBuffer = this._requestQueue.poll()) != null) {
                this._lengthBuffer.clear();
                this._lengthBuffer.retain();
                this._lengthBuffer.writeShort((int)((short)requestBuffer.readableBytes()));
                this._bufferArray[0] = this._lengthBuffer;
                this._bufferArray[1] = requestBuffer;
                ByteBuf newBuf = Unpooled.copiedBuffer((ByteBuf[])this._bufferArray);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:drainRequestQueue: writing new message, length = " + requestBuffer.readableBytes());
                }
                ++this._outstandingRequestCount;
                this.m_channel.write((Object)this._bufferArray[0]);
                ChannelFuture writeFuture = this.m_channel.writeAndFlush((Object)this._bufferArray[1], this.m_channel.newPromise().addListener(f -> {
                    if (f.isSuccess()) {
                        this.writeComplete();
                    } else {
                        this.writeError((Exception)f.cause());
                    }
                }));
                if (writeFuture.isDone()) continue;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:drainRequestQueue: waiting for write to complete");
                }
                this._writeState = 3;
                break block5;
            }
            this._writeState = 2;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: drainRequestQueue: exit");
        }
    }

    static {
        _channelInitialized = false;
    }

    private class SipResolverTCPInitializer
    extends ChannelInitializerWrapper {
        ChannelInitializerWrapper parent;

        public SipResolverTCPInitializer(ChannelInitializerWrapper parent) {
            this.parent = parent;
        }

        protected void initChannel(Channel ch) throws Exception {
            if (this.parent != null) {
                this.parent.init(ch);
            }
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast("writeTimeoutHandler", (ChannelHandler)new WriteTimeoutHandler(60000L, TimeUnit.MILLISECONDS));
            pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(1500L, TimeUnit.MILLISECONDS));
            pipeline.addLast(CHAINNAME, (ChannelHandler)new SipResolverTcpTransportHandler());
        }
    }

    private class SipResolverTcpTransportHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private SipResolverTcpTransportHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "channelActive local: " + ctx.channel().localAddress() + " remote: " + ctx.channel().remoteAddress());
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "channelInactive remote disconnected: " + ctx.channel().remoteAddress());
            }
            SipResolverTcpTransport.this.m_channel = null;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable e2) throws Exception {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "exceptionCaught: " + e2.getMessage());
            }
            SipResolverTcpTransport.this.readError((Exception)e2);
            ctx.close();
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry((Object)this, "channelRead0 message length: " + msg.readableBytes());
            }
            ByteBuf b = msg;
            SipResolverTcpTransport.this.readComplete(ctx, b.retain());
        }
    }
}

