/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.ProductHeader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ProductHeaderImpl
extends HeaderImpl
implements ProductHeader {
    private static final long serialVersionUID = -8979717630459169774L;
    protected List m_products = new ArrayList(2);

    @Override
    public void setProducts(List products) throws IllegalArgumentException, SipParseException {
        if (products == null) {
            throw new IllegalArgumentException("Null Product List");
        }
        if (products.isEmpty()) {
            throw new IllegalArgumentException("Empty Product List");
        }
        Iterator iterator = products.iterator();
        String product = null;
        while (iterator.hasNext()) {
            try {
                product = (String)iterator.next();
            }
            catch (ClassCastException e2) {
                throw new SipParseException("Product is not a String", "");
            }
            if (product != null) continue;
            throw new SipParseException("Null Product", "");
        }
        this.m_products.clear();
        this.m_products.addAll(products);
    }

    @Override
    public Iterator getProducts() {
        return this.m_products.iterator();
    }

    public void encodeProducts(CharsBuffer ret) {
        for (int i = 0; i < this.m_products.size(); ++i) {
            ret.append(this.m_products.get(i));
            if (i >= this.m_products.size() - 1) continue;
            ret.append('/');
        }
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        this.m_products.clear();
        while (true) {
            this.m_products.add(parser.nextToken('/'));
            if (parser.LA(1) != '/') break;
            parser.match('/');
        }
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof ProductHeaderImpl)) {
            return false;
        }
        ProductHeaderImpl o = (ProductHeaderImpl)other;
        if (this.m_products == null) {
            return o.m_products == null;
        }
        if (o.m_products == null) {
            return false;
        }
        return this.m_products.equals(o.m_products);
    }

    @Override
    public Object clone() {
        ProductHeaderImpl ret = (ProductHeaderImpl)super.clone();
        if (this.m_products != null) {
            ret.m_products = (List)((ArrayList)this.m_products).clone();
        }
        return ret;
    }
}

