/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.token;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.saml2.Saml20Attribute;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.saml.sso20.rs.ByteArrayDecoder;
import com.ibm.ws.security.saml.sso20.token.Saml20AttributeImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.xml.NamespaceSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.joda.time.DateTime;
import org.opensaml.core.xml.Namespace;
import org.opensaml.core.xml.NamespaceManager;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.ProxyRestriction;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Saml20TokenImpl
implements Saml20Token,
Serializable {
    private static final long serialVersionUID = -862850937499495719L;
    private static final TraceComponent tc = Tr.register(Saml20TokenImpl.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private static final String samlElement = "samlElement";
    private static final String SINDEX = "sessionIndex";
    private static final String NAMEID = "NameID";
    private static final String dsUri = "http://www.w3.org/2000/09/xmldsig#";
    private String samlString = null;
    private String providerId;
    private transient Element assertionDOM;
    private transient String samlID;
    private transient QName assertionQName;
    private transient Date samlExpires;
    private transient Date samlCreated;
    private transient byte[] holderOfKeyBytes;
    private transient String SAMLIssuerName;
    private transient String issuerNameFormat = null;
    private transient String authenticationMethod;
    private transient Date authenticationInstant;
    private transient String sessionIndex = null;
    private transient String subjectDNS;
    private transient String subjectIPAddress;
    private transient boolean oneTimeUse = false;
    private transient boolean proxyRestriction = false;
    private transient long proxyRestrictionCount = 0L;
    private transient String nameId;
    private transient String nameIdFormat;
    private transient List<String> proxyRestrictionAudience = new ArrayList<String>();
    private transient List<java.security.cert.X509Certificate> signerCertificates = new ArrayList<java.security.cert.X509Certificate>();
    private transient List<String> signerCertificateDN = new ArrayList<String>();
    private transient List<String> confirmationMethod = new ArrayList<String>();
    private transient List<String> audienceRestriction = new ArrayList<String>();
    private transient List<Saml20Attribute> attributes = new ArrayList<Saml20Attribute>();
    private transient long lSessionNotOnOrAfter = 0L;
    private transient Map<String, Object> maps = new HashMap<String, Object>();
    private transient boolean wasDeserialized = false;

    public Saml20TokenImpl(Assertion assertion, String providerId) throws SamlException {
        this.providerId = providerId;
        this.init(assertion);
    }

    public Saml20TokenImpl(Assertion assertion) throws SamlException {
        this.init(assertion);
    }

    void init(Assertion assertion) throws SamlException {
        this.assertionDOM = this.getClonedAssertionDom(assertion);
        this.maps.put(samlElement, this.assertionDOM);
        this.samlString = SerializeSupport.nodeToString((Node)this.assertionDOM);
        this.handleSamlAssertion(assertion);
        List children = assertion.getOrderedChildren();
        for (XMLObject xmlObject : children) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("XMLObject : " + xmlObject), (Object[])new Object[0]);
            }
            if (xmlObject == null) continue;
            QName qName = xmlObject.getElementQName();
            String localPart = qName.getLocalPart();
            String nsUri = qName.getNamespaceURI();
            if (localPart.equals("Issuer")) {
                this.handleSamlIssuer((Issuer)xmlObject);
                continue;
            }
            if (localPart.equals("Signature")) {
                this.handleSamlSignature((Signature)xmlObject);
                continue;
            }
            if (localPart.equals("Subject")) {
                this.handleSamlSubject((Subject)xmlObject);
                continue;
            }
            if (localPart.equals("Conditions")) {
                this.handleSamlConditions((Conditions)xmlObject);
                continue;
            }
            if (localPart.equals("AuthnStatement")) {
                this.handleSamlAuthnStatement((AuthnStatement)xmlObject);
                continue;
            }
            if (localPart.equals("AttributeStatement")) {
                this.handleSamlAttributeStatement((AttributeStatement)xmlObject);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Unhandle XMLObject: " + localPart + "(" + nsUri + ")"), (Object[])new Object[0]);
        }
    }

    private void handleSamlAuthnStatement(AuthnStatement authnStatement) throws SamlException {
        DateTime sessionNotOnOrAfter;
        SubjectLocality locality;
        this.authenticationInstant = authnStatement.getAuthnInstant().toDate();
        this.sessionIndex = authnStatement.getSessionIndex();
        this.maps.put(SINDEX, this.sessionIndex);
        if (authnStatement.getAuthnContext() != null && authnStatement.getAuthnContext().getAuthnContextClassRef() != null) {
            this.authenticationMethod = authnStatement.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef();
        }
        if ((locality = authnStatement.getSubjectLocality()) != null) {
            this.subjectDNS = locality.getDNSName();
            this.subjectIPAddress = locality.getAddress();
        }
        if ((sessionNotOnOrAfter = authnStatement.getSessionNotOnOrAfter()) != null) {
            this.lSessionNotOnOrAfter = sessionNotOnOrAfter.getMillis();
        }
    }

    private void handleSamlConditions(Conditions conditions) throws SamlException {
        ProxyRestriction proxyRestriction;
        this.samlExpires = conditions.getNotOnOrAfter().toDate();
        OneTimeUse onetimeuse = conditions.getOneTimeUse();
        if (onetimeuse != null) {
            this.oneTimeUse = true;
        }
        if ((proxyRestriction = conditions.getProxyRestriction()) != null) {
            Integer count = proxyRestriction.getProxyCount();
            if (count != null) {
                this.proxyRestrictionCount = count.intValue();
            }
            List audiences = proxyRestriction.getAudiences();
            for (Audience audience : audiences) {
                this.proxyRestrictionAudience.add(audience.getAudienceURI());
            }
        }
        List audienceRestrictions = conditions.getAudienceRestrictions();
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            List audiences = audienceRestriction.getAudiences();
            for (Audience audience : audiences) {
                if (audience.getAudienceURI() == null) continue;
                this.audienceRestriction.add(audience.getAudienceURI());
            }
        }
    }

    private void handleSamlSubject(Subject subject) {
        NameID nameID = subject.getNameID();
        if (nameID == null) {
            return;
        }
        this.nameId = nameID.getValue();
        this.nameIdFormat = nameID.getFormat();
        List subjectConfirmations = subject.getSubjectConfirmations();
        for (SubjectConfirmation confirmation : subjectConfirmations) {
            this.confirmationMethod.add(confirmation.getMethod());
        }
        this.maps.put(NAMEID, nameID);
    }

    private void handleSamlAttributeStatement(AttributeStatement attributeState) {
        List attributes = attributeState.getAttributes();
        for (Attribute attribute : attributes) {
            Saml20AttributeImpl saml20Attribute = new Saml20AttributeImpl(attribute);
            this.attributes.add(saml20Attribute);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleSamlSignature(Signature signature) throws SamlException {
        KeyInfo keyInfo = signature.getKeyInfo();
        if (keyInfo == null) {
            return;
        }
        List x509Datas = keyInfo.getX509Datas();
        for (X509Data x509data : x509Datas) {
            List certs = x509data.getX509Certificates();
            for (X509Certificate cert : certs) {
                String certString = cert.getValue();
                try {
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                    byte[] certbytes = Base64Support.decode((String)certString);
                    ByteArrayInputStream bais = new ByteArrayInputStream(certbytes);
                    java.security.cert.X509Certificate x509Cert = (java.security.cert.X509Certificate)certFactory.generateCertificate(bais);
                    this.signerCertificates.add(x509Cert);
                    this.signerCertificateDN.add(x509Cert.getSubjectDN().getName());
                }
                catch (CertificateException certFactory) {
                    void e;
                    FFDCFilter.processException((Throwable)certFactory, (String)"com.ibm.ws.security.saml.sso20.token.Saml20TokenImpl", (String)"344", (Object)this, (Object[])new Object[]{signature});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ERROR: Get an Exception while generate the X509Cerficate", (Object[])new Object[]{e});
                    }
                    throw new SamlException((Exception)e);
                }
            }
        }
    }

    private void handleSamlIssuer(Issuer issuer) {
        this.SAMLIssuerName = issuer.getValue();
        this.issuerNameFormat = issuer.getFormat();
    }

    public String getSAMLIssuerNameFormat() {
        return this.issuerNameFormat;
    }

    private void handleSamlAssertion(Assertion xmlAssertion) throws SamlException {
        this.samlID = xmlAssertion.getID();
        this.assertionQName = xmlAssertion.getElementQName();
        this.samlCreated = xmlAssertion.getIssueInstant().toDate();
    }

    public String getSamlID() {
        return this.samlID;
    }

    public QName getAssertionQName() {
        return SamlUtil.cloneQName(this.assertionQName);
    }

    public Date getSamlExpires() {
        return (Date)this.samlExpires.clone();
    }

    public Date getIssueInstant() {
        return (Date)this.samlCreated.clone();
    }

    public List<String> getConfirmationMethod() {
        return Collections.unmodifiableList(this.confirmationMethod);
    }

    public byte[] getHolderOfKeyBytes() {
        return this.holderOfKeyBytes == null ? null : (byte[])this.holderOfKeyBytes.clone();
    }

    public String getSAMLNameID() {
        return this.nameId;
    }

    public String getSAMLNameIDFormat() {
        return this.nameIdFormat;
    }

    public String getSAMLIssuerName() {
        return this.SAMLIssuerName;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public Date getAuthenticationInstant() {
        return (Date)this.authenticationInstant.clone();
    }

    public String getSubjectDNS() {
        return this.subjectDNS;
    }

    public String getSubjectIPAddress() {
        return this.subjectIPAddress;
    }

    public List<String> getAudienceRestriction() {
        return Collections.unmodifiableList(this.audienceRestriction);
    }

    public boolean isOneTimeUse() {
        return this.oneTimeUse;
    }

    public boolean hasProxyRestriction() {
        return this.proxyRestriction;
    }

    public long getProxyRestrictionCount() {
        return this.proxyRestrictionCount;
    }

    public List<String> getProxyRestrictionAudience() {
        return Collections.unmodifiableList(this.proxyRestrictionAudience);
    }

    public List<java.security.cert.X509Certificate> getSignerCertificate() {
        return Collections.unmodifiableList(this.signerCertificates);
    }

    public String getSAMLAsString() {
        return this.formatSamlString(this.samlString);
    }

    private String formatSamlString(String saml) {
        String[] lines;
        String samlString = saml;
        if (saml != null && (lines = saml.split("\r\n|\r|\n")).length == 2 && lines[0].startsWith("<?") && lines[0].endsWith("?>")) {
            samlString = lines[0].concat(lines[1]);
        }
        return samlString;
    }

    public List<Saml20Attribute> getSAMLAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public String toString() {
        String holderOfKey = "";
        try {
            holderOfKey = new String(this.holderOfKeyBytes, StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String result = "Saml20Token\n samlID:" + this.samlID + "\n assertionQName:" + this.assertionQName + "\n samlExpires:" + this.samlExpires + "\n samlCreated:" + this.samlCreated + "\n confirmationMethod:" + this.confirmationMethod + "\n holderOfKeyBytes:" + holderOfKey + "\n SAMLIssuerName:" + this.SAMLIssuerName + "\n authenticationMethod:" + this.authenticationMethod + "\n authenticationInstant:" + this.authenticationInstant + "\n subjectDNS:" + this.subjectDNS + "\n subjectIPAddress:" + this.subjectIPAddress + "\n audienceRestriction:" + this.audienceRestriction + "\n oneTimeUse:" + this.oneTimeUse + "\n proxyRestriction:" + this.proxyRestriction + "\n proxyRestrictionCount:" + this.proxyRestrictionCount + "\n proxyRestrictionAudience:" + this.proxyRestrictionAudience + "\n signerCertificate:" + this.signerCertificateDN + "\n wasDeserialized:" + this.wasDeserialized;
        return result;
    }

    public String getServiceProviderID() {
        return this.providerId;
    }

    public long getSessionNotOnOrAfter() {
        return this.lSessionNotOnOrAfter;
    }

    public Map<String, Object> getProperties() {
        return this.maps;
    }

    Element getClonedAssertionDom(Assertion assertion) {
        Element node = assertion.getDOM();
        Element dom = (Element)node.cloneNode(true);
        NamespaceManager nsManager = assertion.getNamespaceManager();
        Set namespaces = nsManager.getAllNamespacesInSubtreeScope();
        for (Namespace namespace : namespaces) {
            if (dsUri.equals(namespace.getNamespaceURI())) continue;
            NamespaceSupport.appendNamespaceDeclaration((Element)dom, (String)namespace.getNamespaceURI(), (String)namespace.getNamespacePrefix());
        }
        return dom;
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        input.defaultReadObject();
        this.proxyRestrictionAudience = new ArrayList<String>();
        this.signerCertificates = new ArrayList<java.security.cert.X509Certificate>();
        this.signerCertificateDN = new ArrayList<String>();
        this.confirmationMethod = new ArrayList<String>();
        this.audienceRestriction = new ArrayList<String>();
        this.attributes = new ArrayList<Saml20Attribute>();
        this.maps = new HashMap<String, Object>();
        this.wasDeserialized = true;
        ByteArrayDecoder bad = new ByteArrayDecoder();
        try {
            Assertion assertion = (Assertion)bad.unmarshallMessage(new ByteArrayInputStream(this.samlString.getBytes()));
            this.init(assertion);
        }
        catch (MessageDecodingException assertion) {
            void e;
            FFDCFilter.processException((Throwable)assertion, (String)"com.ibm.ws.security.saml.sso20.token.Saml20TokenImpl", (String)"719", (Object)this, (Object[])new Object[]{input});
            throw new IOException("Error unmarshalling SAML during deserialization. " + e.getMessage(), (Throwable)e);
        }
        catch (SamlException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.token.Saml20TokenImpl", (String)"721", (Object)this, (Object[])new Object[]{input});
            throw new IOException("Error initializing " + Saml20TokenImpl.class.getSimpleName() + " during deserialization. " + e.getMessage(), e);
        }
    }
}

