/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.rs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContextBuilder;
import com.ibm.ws.security.saml.sso20.rs.ByteArrayDecoder;
import com.ibm.ws.security.saml.sso20.rs.RsAssertionValidator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RsSamlConsumer<InboundMessageType extends SAMLObject, OutboundMessageType extends SAMLObject, NameIdentifierType extends SAMLObject> {
    private static TraceComponent tc = Tr.register(RsSamlConsumer.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static RsSamlConsumer<?, ?, ?> instance = new RsSamlConsumer();
    static final long serialVersionUID = -2481433957549757901L;

    public static RsSamlConsumer<?, ?, ?> getInstance() {
        return instance;
    }

    static void setInstance(RsSamlConsumer<?, ?, ?> instance) {
        RsSamlConsumer.instance = instance;
    }

    @FFDCIgnore(value={SamlException.class})
    public BasicMessageContext<InboundMessageType, OutboundMessageType> handleSAMLResponse(HttpServletRequest req, HttpServletResponse res, SsoSamlService ssoService, SsoRequest samlRequest, String headerContent) throws SamlException {
        BasicMessageContext<?, ?> messageContext = null;
        try {
            BasicMessageContextBuilder<?, ?, ?> ctxBuilder = BasicMessageContextBuilder.getInstance();
            messageContext = ctxBuilder.buildRsSaml(req, res, ssoService, null, samlRequest);
            headerContent = headerContent.trim();
            byte[] bytes = null;
            if (headerContent.startsWith("<") && headerContent.endsWith(">")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"SAML assertion in header", (Object[])new Object[0]);
                }
                bytes = headerContent.getBytes(StandardCharsets.UTF_8);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Encoded SAML assertion in header", (Object[])new Object[0]);
                }
                bytes = this.decodeSaml(headerContent);
            }
            if (bytes == null) {
                throw new SamlException("SAML_BAD_INBOUND_SAML_TOKEN", null, new Object[]{headerContent});
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ByteArrayDecoder byteArrayDecoder = new ByteArrayDecoder();
            byteArrayDecoder.doDecode(messageContext, byteArrayInputStream);
            List<Assertion> assertions = this.decryptEncryptedAssertion(messageContext);
            MessageContext<SAMLObject> mc = messageContext.getMessageContext();
            ((SAMLPeerEntityContext)mc.getSubcontext(SAMLPeerEntityContext.class, true)).setRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            ((SAMLProtocolContext)mc.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            Assertion validatedAssertion = null;
            SamlException lastSamlException = null;
            Exception lastException = null;
            for (Assertion assertion : assertions) {
                if (assertion.getAuthnStatements().size() > 0 && assertion.getSubject() != null) {
                    try {
                        String issuer = assertion.getIssuer().getValue();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Issuer from ToBeValidate-assertion:" + issuer), (Object[])new Object[0]);
                        }
                        messageContext.setInboundSamlMessageIssuer(issuer);
                        RsAssertionValidator rsAssertionValidator = new RsAssertionValidator(messageContext, assertion);
                        rsAssertionValidator.validateAssertion();
                        validatedAssertion = assertion;
                        if (!tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)("Found valid Asserion " + assertion.getID()), (Object[])new Object[0]);
                        break;
                    }
                    catch (SamlException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Invalid Asserion " + assertion.getID()), (Object[])new Object[0]);
                        }
                        lastSamlException = e;
                        continue;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"141", (Object)this, (Object[])new Object[]{req, res, ssoService, samlRequest, headerContent});
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Invalid Asserion " + assertion.getID()), (Object[])new Object[0]);
                        }
                        lastException = e;
                        continue;
                    }
                }
                if (assertion.getSubject() != null) continue;
                lastException = new SamlException("SAML20_ELEMENT_ERR", null, new Object[]{"Subject"});
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Assertion " + assertion.getID() + " does not contain Subject"), (Object[])new Object[0]);
            }
            if (validatedAssertion != null) {
                messageContext.setValidatedAssertion(validatedAssertion);
            } else {
                if (lastException != null) {
                    throw lastException;
                }
                if (lastSamlException != null) {
                    throw lastSamlException;
                }
            }
        }
        catch (SamlException e) {
            throw e;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"172", (Object)this, (Object[])new Object[]{req, res, ssoService, samlRequest, headerContent});
            throw new SamlException(e);
        }
        return messageContext;
    }

    /*
     * WARNING - void declaration
     */
    List<Assertion> decryptEncryptedAssertion(BasicMessageContext<?, ?> context) throws SamlException {
        ArrayList<Assertion> assertionList = new ArrayList<Assertion>();
        Object objectMessage = context.getMessageContext().getMessage();
        if (objectMessage instanceof Response) {
            SsoSamlService ssoSamlService = context.getSsoService();
            String headerName = ssoSamlService.getConfig().getHeaderName();
            throw new SamlException("RS_SAML_RESPONSE_NOT_SUPPORTED", null, new Object[]{headerName});
        }
        if (objectMessage instanceof EncryptedAssertion) {
            try {
                EncryptedAssertion eA = (EncryptedAssertion)objectMessage;
                Decrypter decrypter = context.getDecrypter();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("encryptedAssertion:" + eA + " decrypter:" + decrypter), (Object[])new Object[0]);
                }
                Assertion decryptedAssertion = decrypter.decrypt(eA);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("decryptedAssertion:" + decryptedAssertion), (Object[])new Object[0]);
                }
                assertionList.add(decryptedAssertion);
            }
            catch (Exception eA) {
                void e;
                FFDCFilter.processException((Throwable)eA, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"204", (Object)this, (Object[])new Object[]{context});
                throw new SamlException((Exception)e);
            }
            return assertionList;
        }
        if (objectMessage instanceof Assertion) {
            assertionList.add((Assertion)objectMessage);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("InboundMessage is:" + objectMessage.getClass().getName() + "\n" + objectMessage), (Object[])new Object[0]);
        }
        return assertionList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Sensitive
    public byte[] decodeSaml(@Sensitive String s) {
        byte[] bytes;
        block30: {
            int head;
            s = s.replace('_', '/');
            switch (s.length() % 4) {
                case 0: {
                    break;
                }
                case 2: {
                    s = s + "==";
                    break;
                }
                case 3: {
                    s = s + "=";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal Base64URL string!");
                }
            }
            String headerContent = new String(s);
            bytes = Base64.decodeBase64((String)headerContent);
            if (bytes != null && bytes.length >= 4 && 35615 == (head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"compressed SAML assertion in header", (Object[])new Object[0]);
                }
                ByteArrayInputStream bais = null;
                GZIPInputStream gzis = null;
                ByteArrayOutputStream baos = null;
                byte[] buffer = new byte[2048];
                int length = 0;
                baos = new ByteArrayOutputStream();
                bais = new ByteArrayInputStream(bytes);
                gzis = new GZIPInputStream(bais);
                while ((length = gzis.read(buffer)) >= 0) {
                    baos.write(buffer, 0, length);
                }
                bytes = baos.toByteArray();
                try {
                    baos.close();
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = "<sensitive java.lang.String>";
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"268", (Object)this, (Object[])objectArray);
                }
                try {
                    gzis.close();
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = "<sensitive java.lang.String>";
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"272", (Object)this, (Object[])objectArray);
                }
                try {
                    bais.close();
                }
                catch (Exception exception) {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = "<sensitive java.lang.String>";
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"276", (Object)this, (Object[])objectArray);
                }
                break block30;
                catch (IOException iOException) {
                    try {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = "<sensitive java.lang.String>";
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"262", (Object)this, (Object[])objectArray);
                    }
                    catch (Throwable throwable) {
                        try {
                            baos.close();
                        }
                        catch (Exception exception) {
                            Object[] objectArray = new Object[1];
                            objectArray[0] = "<sensitive java.lang.String>";
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"268", (Object)this, (Object[])objectArray);
                        }
                        try {
                            gzis.close();
                        }
                        catch (Exception exception) {
                            Object[] objectArray = new Object[1];
                            objectArray[0] = "<sensitive java.lang.String>";
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"272", (Object)this, (Object[])objectArray);
                        }
                        try {
                            bais.close();
                        }
                        catch (Exception exception) {
                            Object[] objectArray = new Object[1];
                            objectArray[0] = "<sensitive java.lang.String>";
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"276", (Object)this, (Object[])objectArray);
                        }
                        throw throwable;
                    }
                    try {
                        baos.close();
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = "<sensitive java.lang.String>";
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"268", (Object)this, (Object[])objectArray);
                    }
                    try {
                        gzis.close();
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = "<sensitive java.lang.String>";
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"272", (Object)this, (Object[])objectArray);
                    }
                    try {
                        bais.close();
                    }
                    catch (Exception exception) {
                        Object[] objectArray = new Object[1];
                        objectArray[0] = "<sensitive java.lang.String>";
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.rs.RsSamlConsumer", (String)"276", (Object)this, (Object[])objectArray);
                    }
                }
            }
        }
        return bytes;
    }
}

