/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.privilizer;

import java.lang.reflect.Modifier;
import java.util.EnumSet;
import java.util.Locale;
import org.apache.commons.weaver.privilizer._lang3.StringUtils;
import org.apache.commons.weaver.privilizer._lang3.Validate;

public enum AccessLevel {
    PUBLIC(1),
    PROTECTED(4),
    PACKAGE(0),
    PRIVATE(2);

    private final int flag;

    private AccessLevel(int flag) {
        this.flag = flag;
    }

    public static AccessLevel of(int mod) {
        EnumSet<AccessLevel> matched = EnumSet.noneOf(AccessLevel.class);
        if (Modifier.isPublic(mod)) {
            matched.add(PUBLIC);
        }
        if (Modifier.isProtected(mod)) {
            matched.add(PROTECTED);
        }
        if (Modifier.isPrivate(mod)) {
            matched.add(PRIVATE);
        }
        if (matched.isEmpty()) {
            return PACKAGE;
        }
        Validate.isTrue(matched.size() == 1, "%s seems to declare multiple access modifiers: %s", mod, matched);
        return (AccessLevel)((Object)matched.iterator().next());
    }

    public int merge(int mod) {
        int remove = 0;
        for (AccessLevel accessLevel : EnumSet.complementOf(EnumSet.of(this))) {
            remove |= accessLevel.flag;
        }
        return mod & ~remove | this.flag;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.US);
    }

    public static AccessLevel defaultValue() {
        return PRIVATE;
    }

    public static AccessLevel parse(String str) {
        if (StringUtils.isBlank(str)) {
            return AccessLevel.defaultValue();
        }
        return AccessLevel.valueOf(str.trim().toUpperCase(Locale.US));
    }
}

