/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.json;

import io.smallrye.graphql.json.GraphQLNamingStrategy;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.InputType;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.config.PropertyNamingStrategy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JsonBCreator {
    private static final Jsonb JSONB = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(true)));
    private static final Map<String, Jsonb> jsonMap = new HashMap<String, Jsonb>();

    private JsonBCreator() {
    }

    protected static void register(InputType inputType) {
        if (inputType.hasFields()) {
            HashMap<String, String> namemapping = new HashMap<String, String>();
            Collection<Field> fields = inputType.getFields().values();
            for (Field field : fields) {
                if (field.getName().equals(field.getPropertyName())) continue;
                namemapping.put(field.getPropertyName(), field.getName());
            }
            if (!namemapping.isEmpty()) {
                Jsonb jsonB = JsonBCreator.createJsonB(namemapping);
                jsonMap.put(inputType.getClassName(), jsonB);
            }
        }
    }

    public static Jsonb getJsonB(String className) {
        if (jsonMap.containsKey(className)) {
            return jsonMap.get(className);
        }
        return JsonBCreator.getJsonB();
    }

    public static Jsonb getJsonB() {
        return JSONB;
    }

    private static Jsonb createJsonB(Map<String, String> customFieldNameMapping) {
        JsonbConfig config = JsonBCreator.createDefaultConfig().withPropertyNamingStrategy((PropertyNamingStrategy)new GraphQLNamingStrategy(customFieldNameMapping));
        return JsonbBuilder.create((JsonbConfig)config);
    }

    private static JsonbConfig createDefaultConfig() {
        return new JsonbConfig().withNullValues(Boolean.TRUE).withFormatting(Boolean.TRUE);
    }
}

