/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health31.services.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.microprofile.health.services.impl.AppModuleContextService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health31.services.HealthCheck31CDIBeanInvoker;
import io.openliberty.microprofile.health31.services.HealthCheck31Executor;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(service={HealthCheck31Executor.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HealthCheck31ExecutorImpl
implements HealthCheck31Executor {
    private AppModuleContextService appModuleContextService;
    private volatile int eeVersion;
    private ServiceReference<JavaEEVersion> eeVersionRef;
    private HealthCheck31CDIBeanInvoker healthCheckCDIBeanInvoker;
    private J2EENameFactory j2eeNameFactory;
    private static final Logger logger = Logger.getLogger(HealthCheck31ExecutorImpl.class.getName(), "io.openliberty.microprofile.health.resources.Health");
    private static final String HC_MANAGEDTASK_IDENTITY_NAME = "mp.healthcheck.proxy";
    private static final String HC_TASK_OWNER = "mp.healthcheck.runtime";
    private static final String ONLY_WAR_EJB_NOT_SUPPORTED = null;
    static final long serialVersionUID = 1821286462904974792L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HealthCheck31ExecutorImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setAppModuleContextService(AppModuleContextService appModuleContextService) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "setAppModuleContextService", new Object[]{appModuleContextService});
        }
        this.appModuleContextService = appModuleContextService;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "setAppModuleContextService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setHealthCheckApplicationBeanInvoker(HealthCheck31CDIBeanInvoker healthCheckCDIBeanInvoker) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "setHealthCheckApplicationBeanInvoker", new Object[]{healthCheckCDIBeanInvoker});
        }
        this.healthCheckCDIBeanInvoker = healthCheckCDIBeanInvoker;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "setHealthCheckApplicationBeanInvoker");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setJ2EENameFactory(J2EENameFactory j2eeNameFactory) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "setJ2EENameFactory", new Object[]{j2eeNameFactory});
        }
        this.j2eeNameFactory = j2eeNameFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "setJ2EENameFactory");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<HealthCheckResponse> runHealthChecks(String appName, String moduleName, String healthCheckProcedure) throws HealthCheckBeanCallException {
        Set<HealthCheckResponse> retval;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "runHealthChecks", new Object[]{appName, moduleName, healthCheckProcedure});
        }
        J2EEName j2eeName = this.j2eeNameFactory.create(appName, moduleName, ONLY_WAR_EJB_NOT_SUPPORTED);
        HashMap<String, String> execProps = new HashMap<String, String>();
        String MANAGEDTASK_IDENTITY_NAME = this.eeVersion < 9 ? "javax.enterprise.concurrent.IDENTITY_NAME" : "jakarta.enterprise.concurrent.IDENTITY_NAME";
        execProps.put(MANAGEDTASK_IDENTITY_NAME, HC_MANAGEDTASK_IDENTITY_NAME);
        execProps.put("com.ibm.ws.concurrent.TASK_OWNER", HC_TASK_OWNER);
        HealthCheck31CDIBeanInvoker proxy = this.appModuleContextService.createContextualProxy(execProps, j2eeName, this.healthCheckCDIBeanInvoker, HealthCheck31CDIBeanInvoker.class);
        try {
            retval = proxy.checkAllBeans(appName, moduleName, healthCheckProcedure);
        }
        catch (HealthCheckBeanCallException healthCheckBeanCallException) {
            void e;
            FFDCFilter.processException((Throwable)healthCheckBeanCallException, (String)"io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", (String)"105", (Object)this, (Object[])new Object[]{appName, moduleName, healthCheckProcedure});
            logger.log(Level.SEVERE, "healthcheck.bean.call.exception.CWMMH0050E", new Object[]{e.getBeanName(), appName, moduleName, e.getCause().toString(), e.getMessage()});
            throw e;
        }
        for (HealthCheckResponse hcr : retval) {
            if (HealthCheckResponse.Status.DOWN != hcr.getStatus()) continue;
            logger.log(Level.WARNING, "healthcheck.application.down.CWMMH0052W", new Object[]{hcr.getClass().toString(), appName, moduleName, hcr.getStatus().toString(), hcr.getName(), hcr.getData() != null ? hcr.getData().toString() : "{NO DATA}"});
        }
        Set<HealthCheckResponse> set = retval;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "runHealthChecks", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void removeModuleReferences(String appName, String moduleName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "removeModuleReferences", new Object[]{appName, moduleName});
        }
        this.healthCheckCDIBeanInvoker.removeModuleReferences(appName, moduleName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "removeModuleReferences");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(service=JavaEEVersion.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setEEVersion(ServiceReference<JavaEEVersion> ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "setEEVersion", new Object[]{ref});
        }
        String version = (String)ref.getProperty("version");
        if (version == null) {
            this.eeVersion = 0;
        } else {
            int dot = version.indexOf(46);
            String major = dot > 0 ? version.substring(0, dot) : version;
            this.eeVersion = Integer.parseInt(major);
        }
        this.eeVersionRef = ref;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "setEEVersion");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetEEVersion(ServiceReference<JavaEEVersion> ref) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "unsetEEVersion", new Object[]{ref});
        }
        if (this.eeVersionRef == ref) {
            this.eeVersionRef = null;
            this.eeVersion = 0;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.microprofile.health31.services.impl.HealthCheck31ExecutorImpl", "unsetEEVersion");
        }
    }
}

