/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class AttributeDetails {
    protected String attributeName;
    protected String referenceClassName;
    protected Type referenceClassType;
    protected boolean weaveValueHolders = false;
    protected boolean weaveTransientFieldValueHolders;
    protected DatabaseMapping mapping;
    protected String getterMethodName;
    protected String setterMethodName;
    protected boolean attributeOnSuperClass = false;
    protected boolean hasField = false;
    protected Type declaringType;
    protected String setMethodSignature;
    protected boolean isVirtualProperty = false;

    public AttributeDetails(String attributeName, DatabaseMapping mapping) {
        this.attributeName = attributeName;
        this.mapping = mapping;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    public String getGetterMethodName() {
        return this.getterMethodName;
    }

    public String getSetterMethodSignature() {
        if (this.setMethodSignature == null) {
            this.setMethodSignature = this.isVirtualProperty ? "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;" : "(" + this.getReferenceClassType().getDescriptor() + ")V";
        }
        return this.setMethodSignature;
    }

    public String getSetterMethodName() {
        return this.setterMethodName;
    }

    public String getReferenceClassName() {
        return this.referenceClassName;
    }

    public void setReferenceClassName(String className) {
        this.referenceClassName = className;
    }

    public Type getDeclaringType() {
        return this.declaringType;
    }

    public void setDeclaringType(Type declaringType) {
        this.declaringType = declaringType;
    }

    public Type getReferenceClassType() {
        return this.referenceClassType;
    }

    public void setReferenceClassType(Type classType) {
        this.referenceClassType = classType;
    }

    public void setAttributeOnSuperClass(boolean onSuperClass) {
        this.attributeOnSuperClass = onSuperClass;
    }

    public boolean isVirtualProperty() {
        return this.isVirtualProperty;
    }

    public void setVirtualProperty(boolean isVirtualProperty) {
        this.isVirtualProperty = isVirtualProperty;
    }

    public boolean isAttributeOnSuperClass() {
        return this.attributeOnSuperClass;
    }

    public void setWeaveTransientFieldValueHolders() {
        this.weaveTransientFieldValueHolders = true;
    }

    public boolean weaveTransientFieldValueHolders() {
        return this.weaveTransientFieldValueHolders;
    }

    public boolean weaveValueHolders() {
        return this.weaveValueHolders;
    }

    public void weaveVH(boolean weaveValueHolders, DatabaseMapping mapping) {
        this.weaveValueHolders = weaveValueHolders;
    }

    public void setGetterMethodName(String getMethodName) {
        this.getterMethodName = getMethodName;
    }

    public void setSetterMethodName(String setMethodName) {
        this.setterMethodName = setMethodName;
    }

    public void setHasField(boolean hasField) {
        this.hasField = hasField;
    }

    public boolean hasField() {
        return this.hasField;
    }

    public boolean isCollectionMapping() {
        return this.mapping.isCollectionMapping();
    }

    public boolean isMappedWithAttributeAccess() {
        return this.getterMethodName == null;
    }

    public boolean isOneToOneMapping() {
        return this.mapping.isOneToOneMapping();
    }

    public boolean isLazy() {
        return this.mapping.isLazy();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.attributeName);
        if (this.referenceClassName != null) {
            sb.append("[");
            sb.append(this.referenceClassName);
            sb.append("]");
        }
        sb.append(" weaveVH: ");
        if (this.weaveValueHolders()) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        sb.append(" CM: ");
        if (this.isCollectionMapping()) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        return sb.toString();
    }
}

