/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws23.client.security;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.metadata.ConfigProperties;
import com.ibm.ws.jaxws.metadata.PortComponentRefInfo;
import com.ibm.ws.jaxws.metadata.WebServiceRefInfo;
import com.ibm.ws.jaxws.security.JaxWsSecurityConfigurationService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.namespace.QName;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxWsClientSecurityOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxWsClientSecurityOutInterceptor.class, null, null);
    private static final QName CXF_TRANSPORT_URI_RESOLVER_QNAME = new QName("http://cxf.apache.org", "TransportURIResolver");
    private static final AtomicReference<AtomicServiceReference<JaxWsSecurityConfigurationService>> securityConfigSR = new AtomicReference();
    private final JaxWsSecurityConfigurationService securityConfigService;
    private static final String HTTPS_SCHEMA = "https";
    private final Set<ConfigProperties> configPropertiesSet;
    private final EndpointInfo endpointInfo;
    protected final WebServiceRefInfo wsrInfo;
    private final boolean isSecured = false;
    private String address;
    static final long serialVersionUID = -2139872234441211956L;

    public LibertyJaxWsClientSecurityOutInterceptor(WebServiceRefInfo wsrInfo, JaxWsSecurityConfigurationService securityConfigService, Set<ConfigProperties> configPropertiesSet, EndpointInfo endpointInfo) {
        super("prepare-send");
        this.wsrInfo = wsrInfo;
        this.configPropertiesSet = configPropertiesSet;
        this.securityConfigService = securityConfigService;
        this.endpointInfo = endpointInfo;
    }

    public void handleMessage(Message message) throws Fault {
        AtomicServiceReference<JaxWsSecurityConfigurationService> secConfigSR;
        Conduit conduit = message.getExchange().getConduit(message);
        if (conduit != null) {
            HTTPClientPolicy clientPolicy = ((HTTPConduit)conduit).getClient();
            clientPolicy.setAutoRedirect(CXF_TRANSPORT_URI_RESOLVER_QNAME.equals(this.endpointInfo.getName()));
        }
        JaxWsSecurityConfigurationService securityConfigService = (secConfigSR = securityConfigSR.get()) == null ? null : (JaxWsSecurityConfigurationService)secConfigSR.getService();
        this.customizeClientSecurity(message, securityConfigService);
    }

    protected void customizeClientSecurity(Message message, JaxWsSecurityConfigurationService securityConfigService) {
        QName portName = this.getPortQName(message);
        if (null == securityConfigService) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The JaxWsSecurityConfigurationService is unavailable", (Object[])new Object[0]);
            }
            return;
        }
        boolean isSecured = false;
        String address = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        boolean bl = isSecured = address == null ? false : address.startsWith(HTTPS_SCHEMA);
        if (null == this.wsrInfo) {
            if (isSecured) {
                securityConfigService.configClientSSL(message.getExchange().getConduit(message), null, null);
            }
            return;
        }
        PortComponentRefInfo portRefInfo = this.wsrInfo.getPortComponentRefInfo(portName);
        if (null == portRefInfo) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Could not find the port component: " + portName + " for WebServiceRef: " + this.wsrInfo.getJndiName()), (Object[])new Object[0]);
            }
            if (isSecured) {
                securityConfigService.configClientSSL(message.getExchange().getConduit(message), null, null);
            }
        } else {
            String userName = portRefInfo.getUserName();
            ProtectedString password = portRefInfo.getPassword();
            securityConfigService.configBasicAuth(message.getExchange().getConduit(message), userName, password);
            if (isSecured) {
                securityConfigService.configClientSSL(message.getExchange().getConduit(message), portRefInfo.getSSLRef(), portRefInfo.getKeyAlias());
            }
        }
    }

    public static QName buildQName(String namespace, String localName) {
        String namespaceURI = namespace;
        if (!LibertyJaxWsClientSecurityOutInterceptor.isEmpty(namespace) && !namespace.trim().endsWith("/")) {
            namespaceURI = namespaceURI + "/";
        }
        return new QName(namespaceURI, localName);
    }

    private QName getPortQName(Message message) {
        Object wsdlPort = message.getExchange().get((Object)"javax.xml.ws.wsdl.port");
        String namespace = "";
        String localName = "";
        if (null != wsdlPort && wsdlPort instanceof QName) {
            namespace = ((QName)wsdlPort).getNamespaceURI();
            localName = ((QName)wsdlPort).getLocalPart();
            return LibertyJaxWsClientSecurityOutInterceptor.buildQName(namespace, localName);
        }
        return null;
    }

    public static boolean isEmpty(String str) {
        if (str == null || str.isEmpty()) {
            return true;
        }
        int len = str.length();
        for (int x = 0; x < len; ++x) {
            if (str.charAt(x) <= ' ') continue;
            return false;
        }
        return true;
    }

    public static void setSecurityConfigService(AtomicServiceReference<JaxWsSecurityConfigurationService> serviceRefer) {
        securityConfigSR.set(serviceRefer);
    }
}

