/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal.discrim;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.InboundVirtualConnection;
import com.ibm.ws.channelfw.internal.InboundVirtualConnectionImpl;
import com.ibm.ws.channelfw.internal.discrim.DiscriminationAlgorithm;
import com.ibm.ws.channelfw.internal.discrim.DiscriminationGroup;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.exception.DiscriminationProcessException;
import java.util.List;

public class MultiDiscriminatorAlgorithm
implements DiscriminationAlgorithm {
    private static final TraceComponent tc = Tr.register(MultiDiscriminatorAlgorithm.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private DiscriminationGroup discriminationGroup = null;
    private List<Discriminator> discriminators = null;
    private int numDiscriminators = 0;

    MultiDiscriminatorAlgorithm(DiscriminationGroup discGroup) {
        this.discriminationGroup = discGroup;
        this.discriminators = this.discriminationGroup.getDiscriminators();
        this.numDiscriminators = this.discriminators.size();
    }

    @Override
    public int discriminate(InboundVirtualConnection vc, Object discrimData, ConnectionLink prevChannelLink) throws DiscriminationProcessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("discriminate: " + vc), (Object[])new Object[0]);
        }
        int state = 2;
        boolean newStatus = false;
        int maybeCount = 0;
        int maybeIndex = 0;
        int[] status = vc.getDiscriminatorStatus();
        boolean groupChanged = false;
        if (status == null || (groupChanged = 0 != this.discriminationGroup.compareTo(vc.getDiscriminationGroup()))) {
            if (groupChanged) {
                ((InboundVirtualConnectionImpl)vc).cleanUpAllDiscriminatorState();
            }
            status = new int[this.numDiscriminators];
            newStatus = true;
        }
        Discriminator d = null;
        block5: for (int i = 0; i < this.numDiscriminators && state == 2; ++i) {
            if (!newStatus && status[i] == 0) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Skipping a discriminator that has a \"NO\" status", (Object[])new Object[0]);
                continue;
            }
            d = this.discriminators.get(i);
            if (maybeCount == 0 && i == this.numDiscriminators - 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Discrimination has all no's and one last guy", (Object[])new Object[0]);
                }
                state = 1;
                break;
            }
            switch (d.discriminate(vc, discrimData)) {
                case 1: {
                    state = 1;
                    status[i] = 1;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue block5;
                    Tr.debug((TraceComponent)tc, (String)("discriminator " + d + " reports success"), (Object[])new Object[0]);
                    continue block5;
                }
                case 0: {
                    status[i] = 0;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue block5;
                    Tr.debug((TraceComponent)tc, (String)("discriminator " + d + " reports no"), (Object[])new Object[0]);
                    continue block5;
                }
                case -1: {
                    ++maybeCount;
                    maybeIndex = i;
                    status[i] = -1;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue block5;
                    Tr.debug((TraceComponent)tc, (String)("discriminator " + d + " reports maybe"), (Object[])new Object[0]);
                    continue block5;
                }
                default: {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue block5;
                    Tr.debug((TraceComponent)tc, (String)("Discriminator " + d + " returned an incorrect status code"), (Object[])new Object[0]);
                }
            }
        }
        if (state == 2 && maybeCount == 1) {
            d = this.discriminators.get(maybeIndex);
            state = 1;
            --maybeCount;
            status[maybeIndex] = 1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Discriminator enhancement: single maybe case", (Object[])new Object[0]);
            }
        }
        if (state == 1) {
            if (d == null) {
                DiscriminationProcessException e = new DiscriminationProcessException("Should not happen!");
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".discriminate"), (String)"150", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found null discriminator", (Object[])new Object[0]);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"discriminate");
                }
                throw e;
            }
            Channel nextChannel = d.getChannel();
            ConnectionLink nextChannelLink = nextChannel.getConnectionLink(vc);
            prevChannelLink.setApplicationCallback(nextChannelLink);
            nextChannelLink.setDeviceLink(prevChannelLink);
            if (maybeCount >= 1) {
                ((InboundVirtualConnectionImpl)vc).cleanUpMaybeDiscriminatorState();
            }
            vc.setDiscriminatorStatus(null);
            status = null;
        } else if (state == 2) {
            vc.setDiscriminatorStatus(status);
            vc.setDiscriminationGroup(this.discriminationGroup);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("discriminate: " + state));
        }
        return state;
    }
}

