/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.beanvalidation.extprocessor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="log", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JSFBeanValidationExtensionFactory
implements ExtensionFactory {
    protected static final Logger log = Logger.getLogger("com.ibm.ws.jsf.beanvalidation.extprocessor");
    protected static final String CLASS_NAME = "com.ibm.ws.jsf.beanvalidation.extprocessor.JSFBeanValidationExtensionFactory";
    private final AtomicServiceReference<BeanValidation> beanValidationSRRef;
    static final long serialVersionUID = -2426703168659033473L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSFBeanValidationExtensionFactory() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        this.beanValidationSRRef = new AtomicServiceReference("beanValidation");
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void activate(ComponentContext compcontext, Map<String, Object> properties) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "activate", new Object[]{compcontext, properties});
        }
        this.beanValidationSRRef.activate(compcontext);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void deactivate(ComponentContext compcontext) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "deactivate", new Object[]{compcontext});
        }
        this.beanValidationSRRef.deactivate(compcontext);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setBeanValidation(ServiceReference<BeanValidation> ref) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "setBeanValidation", new Object[]{ref});
        }
        this.beanValidationSRRef.setReference(ref);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "setBeanValidation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void unsetBeanValidation(ServiceReference<BeanValidation> ref) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "unsetBeanValidation", new Object[]{ref});
        }
        this.beanValidationSRRef.unsetReference(ref);
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "unsetBeanValidation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BeanValidation getBeanValidation() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "getBeanValidation", new Object[0]);
        }
        BeanValidation beanValidation = (BeanValidation)this.beanValidationSRRef.getService();
        if (log != null && log.isLoggable(Level.FINER)) {
            beanValidation = beanValidation;
            log.exiting(CLASS_NAME, "getBeanValidation", beanValidation);
        }
        return beanValidation;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setValidatorFactoryAttribute(IServletContext ctxt) {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "setValidatorFactoryAttribute", new Object[]{ctxt});
        }
        BeanValidation bv = this.getBeanValidation();
        ComponentMetaData cmd = null;
        ValidatorFactory vf = null;
        if (bv != null) {
            cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (cmd != null) {
                try {
                    vf = bv.getValidatorFactory(cmd);
                    ctxt.setAttribute("javax.faces.validator.beanValidator.ValidatorFactory", (Object)vf);
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "setValidatorFactoryAttribute", "VALIDATOR_FACTORY_KEY set to: " + vf);
                    }
                }
                catch (ValidationException validationException) {
                    FFDCFilter.processException((Throwable)validationException, (String)CLASS_NAME, (String)"81", (Object)this, (Object[])new Object[]{ctxt});
                    if (log.isLoggable(Level.FINE)) {
                        void bve;
                        log.logp(Level.FINE, CLASS_NAME, "setValidatorFactoryAttribute", "exception thrown while attempting to set the validator factory", (Throwable)bve);
                    }
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "setValidatorFactoryAttribute", "bean validation service was null");
        }
        if (log != null && log.isLoggable(Level.FINER)) {
            log.exiting(CLASS_NAME, "setValidatorFactoryAttribute");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExtensionProcessor createExtensionProcessor(IServletContext webapp) throws Exception {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "createExtensionProcessor", new Object[]{webapp});
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Setting up the extension processor for bean validation");
        }
        this.setValidatorFactoryAttribute(webapp);
        ExtensionProcessor extensionProcessor = null;
        if (log != null && log.isLoggable(Level.FINER)) {
            extensionProcessor = extensionProcessor;
            log.exiting(CLASS_NAME, "createExtensionProcessor", extensionProcessor);
        }
        return extensionProcessor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List getPatternList() {
        if (log != null && log.isLoggable(Level.FINER)) {
            log.entering(CLASS_NAME, "getPatternList", new Object[0]);
        }
        List list = Collections.EMPTY_LIST;
        if (log != null && log.isLoggable(Level.FINER)) {
            list = list;
            log.exiting(CLASS_NAME, "getPatternList", list);
        }
        return list;
    }
}

