/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CommonToken;
import org.eclipse.persistence.internal.libraries.antlr.runtime.IntStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.PositionTrackingStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.Tree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeNodeStream;

public class RecognitionException
extends Exception {
    public transient IntStream input;
    public int index;
    public Token token;
    public Object node;
    public int c;
    public int line;
    public int charPositionInLine;
    public boolean approximateLineInfo;

    public RecognitionException() {
    }

    public RecognitionException(IntStream intStream) {
        this.input = intStream;
        this.index = intStream.index();
        if (intStream instanceof TokenStream) {
            this.token = ((TokenStream)intStream).LT(1);
            this.line = this.token.getLine();
            this.charPositionInLine = this.token.getCharPositionInLine();
        }
        if (intStream instanceof TreeNodeStream) {
            this.extractInformationFromTreeNodeStream(intStream);
        } else if (intStream instanceof CharStream) {
            this.c = intStream.LA(1);
            this.line = ((CharStream)intStream).getLine();
            this.charPositionInLine = ((CharStream)intStream).getCharPositionInLine();
        } else {
            this.c = intStream.LA(1);
        }
    }

    protected void extractInformationFromTreeNodeStream(IntStream intStream) {
        TreeAdaptor treeAdaptor;
        Token token;
        TreeNodeStream treeNodeStream = (TreeNodeStream)intStream;
        this.node = treeNodeStream.LT(1);
        Object object = null;
        if (treeNodeStream instanceof PositionTrackingStream && (object = (Object)((PositionTrackingStream)((Object)treeNodeStream)).getKnownPositionElement(false)) == null) {
            object = ((PositionTrackingStream)((Object)treeNodeStream)).getKnownPositionElement(true);
            this.approximateLineInfo = object != null;
        }
        if ((token = (treeAdaptor = treeNodeStream.getTreeAdaptor()).getToken(object != null ? object : this.node)) != null) {
            this.token = token;
            if (token.getLine() <= 0) {
                int n = -1;
                Object object2 = treeNodeStream.LT(n);
                while (object2 != null) {
                    Token token2 = treeAdaptor.getToken(object2);
                    if (token2 != null && token2.getLine() > 0) {
                        this.line = token2.getLine();
                        this.charPositionInLine = token2.getCharPositionInLine();
                        this.approximateLineInfo = true;
                        break;
                    }
                    --n;
                    try {
                        object2 = treeNodeStream.LT(n);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        object2 = null;
                    }
                }
            } else {
                this.line = token.getLine();
                this.charPositionInLine = token.getCharPositionInLine();
            }
        } else if (this.node instanceof Tree) {
            this.line = ((Tree)this.node).getLine();
            this.charPositionInLine = ((Tree)this.node).getCharPositionInLine();
            if (this.node instanceof CommonTree) {
                this.token = ((CommonTree)this.node).token;
            }
        } else {
            int n = treeAdaptor.getType(this.node);
            String string = treeAdaptor.getText(this.node);
            this.token = new CommonToken(n, string);
        }
    }

    public int getUnexpectedType() {
        if (this.input instanceof TokenStream) {
            return this.token.getType();
        }
        if (this.input instanceof TreeNodeStream) {
            TreeNodeStream treeNodeStream = (TreeNodeStream)this.input;
            TreeAdaptor treeAdaptor = treeNodeStream.getTreeAdaptor();
            return treeAdaptor.getType(this.node);
        }
        return this.c;
    }
}

