/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.InParameterForCallableStatement;
import org.eclipse.persistence.internal.databaseaccess.OutputParameterForCallableStatement;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.DatasourceCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;

public abstract class DatasourceCall
implements Call {
    protected transient DatabaseQuery query;
    protected List<Object> parameters;
    protected List<ParameterType> parameterTypes;
    protected List<Boolean> parameterBindings;
    protected Boolean usesBinding = null;
    protected boolean isPrepared = false;
    protected boolean isNativeConnectionRequired;
    protected boolean shouldProcessTokenInQuotes = true;
    protected List<DatabaseField> outputCursors;
    protected int returnType;
    protected static final int NO_RETURN = 1;
    protected static final int RETURN_ONE_ROW = 2;
    protected static final int RETURN_MANY_ROWS = 3;
    protected static final int RETURN_CURSOR = 4;
    protected static final int EXECUTE_UPDATE = 5;

    public List getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Object>();
        }
        return this.parameters;
    }

    public List<ParameterType> getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = new ArrayList<ParameterType>();
        }
        return this.parameterTypes;
    }

    public List<Boolean> getParameterBindings() {
        if (this.parameterBindings == null) {
            this.parameterBindings = new ArrayList<Boolean>();
        }
        return this.parameterBindings;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public void setParameterTypes(List<ParameterType> parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setParameterBindings(List<Boolean> parameterBindings) {
        this.parameterBindings = parameterBindings;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.getParameters().isEmpty();
    }

    public List<DatabaseField> getOutputCursors() {
        if (this.outputCursors == null) {
            this.outputCursors = new ArrayList<DatabaseField>();
        }
        return this.outputCursors;
    }

    public boolean hasOutputCursors() {
        return this.outputCursors != null && !this.outputCursors.isEmpty();
    }

    public boolean areManyRowsReturned() {
        return this.returnType == 3;
    }

    public static boolean isOutputParameterType(ParameterType parameterType) {
        return parameterType == ParameterType.OUT || parameterType == ParameterType.INOUT || parameterType == ParameterType.OUT_CURSOR;
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public void setIsPrepared(boolean isPrepared) {
        this.isPrepared = isPrepared;
    }

    public void setUsesBinding(boolean usesBinding) {
        this.usesBinding = usesBinding;
    }

    public boolean usesBinding(AbstractSession session) {
        return this.usesBinding(session.getPlatform());
    }

    public boolean usesBinding(DatabasePlatform databasePlatform) {
        if (this.usesBinding == null) {
            return databasePlatform.shouldBindAllParameters();
        }
        return this.usesBinding;
    }

    public Boolean usesBinding() {
        return this.usesBinding;
    }

    public boolean isUsesBindingSet() {
        return this.usesBinding != null;
    }

    @Override
    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new DatasourceCallQueryMechanism(query, this);
    }

    @Override
    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        if (mechanism.isCallQueryMechanism() && mechanism instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism callMechanism = (DatasourceCallQueryMechanism)mechanism;
            if (!callMechanism.hasMultipleCalls()) {
                callMechanism.addCall(callMechanism.getCall());
                callMechanism.setCall(null);
            }
            callMechanism.addCall(this);
            return mechanism;
        }
        return this.buildNewQueryMechanism(query);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public abstract String getLogString(Accessor var1);

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public boolean isCursorReturned() {
        return this.returnType == 4;
    }

    public boolean isExecuteUpdate() {
        return this.returnType == 5;
    }

    @Override
    public boolean isFinished() {
        return !this.isCursorReturned() && !this.isExecuteUpdate();
    }

    @Override
    public boolean isNothingReturned() {
        return this.returnType == 1;
    }

    @Override
    public boolean isOneRowReturned() {
        return this.returnType == 2;
    }

    public boolean isSQLCall() {
        return false;
    }

    public boolean isStoredPLSQLFunctionCall() {
        return false;
    }

    public boolean isStoredPLSQLProcedureCall() {
        return false;
    }

    public boolean isStoredFunctionCall() {
        return false;
    }

    public boolean isStoredProcedureCall() {
        return false;
    }

    public boolean isJPQLCall() {
        return false;
    }

    public boolean isEISInteraction() {
        return false;
    }

    public boolean isQueryStringCall() {
        return false;
    }

    public void prepare(AbstractSession session) {
        this.setIsPrepared(true);
    }

    public void returnCursor() {
        this.setReturnType(4);
    }

    public void setExecuteUpdate() {
        this.setReturnType(5);
    }

    public boolean isReturnSet() {
        return this.returnType != 0;
    }

    public void returnManyRows() {
        this.setReturnType(3);
    }

    public void returnNothing() {
        this.setReturnType(1);
    }

    public void returnOneRow() {
        this.setReturnType(2);
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void setReturnType(int returnType) {
        this.returnType = returnType;
    }

    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
    }

    public String getQueryString() {
        return "";
    }

    public void setQueryString(String queryString) {
    }

    public void translateCustomQuery() {
        if (this.shouldProcessTokenInQuotes) {
            if (this.getQueryString().indexOf(this.query.getParameterDelimiter()) == -1) {
                if (this.getQuery().shouldBindAllParameters() && this.getQueryString().indexOf("?") == -1) {
                    return;
                }
                this.translatePureSQLCustomQuery();
                return;
            }
        } else if (!(this.hasArgumentMark(this.getQueryString(), this.query.getParameterDelimiterChar(), '\'') && this.hasArgumentMark(this.getQueryString(), this.query.getParameterDelimiterChar(), '\"') && this.hasArgumentMark(this.getQueryString(), this.query.getParameterDelimiterChar(), '`'))) {
            if (this.getQuery().shouldBindAllParameters() && !this.hasArgumentMark(this.getQueryString(), '?', '\'')) {
                return;
            }
            this.translatePureSQLCustomQuery();
            return;
        }
        int lastIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            while (lastIndex != -1) {
                DatabaseField field;
                String fieldName;
                String token;
                int poundIndex = queryString.indexOf(this.query.getParameterDelimiterChar(), lastIndex);
                if (poundIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    token = queryString.substring(lastIndex, poundIndex);
                } else {
                    boolean hasPairedQuoteBeforePound = true;
                    int quotePairIndex = poundIndex;
                    while ((quotePairIndex = queryString.lastIndexOf(39, quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                        hasPairedQuoteBeforePound = !hasPairedQuoteBeforePound;
                    }
                    int endQuoteIndex = -1;
                    if (!hasPairedQuoteBeforePound) {
                        endQuoteIndex = queryString.indexOf(39, poundIndex + 1);
                    }
                    if (endQuoteIndex != -1) {
                        token = queryString.substring(lastIndex, endQuoteIndex + 1);
                        poundIndex = -1;
                        lastIndex = endQuoteIndex + 1;
                    } else {
                        token = queryString.substring(lastIndex, poundIndex);
                        lastIndex = poundIndex + 1;
                    }
                }
                writer.write(token);
                if (poundIndex == -1) continue;
                int wordEndIndex = poundIndex + 1;
                while (wordEndIndex < queryString.length() && this.whitespace().indexOf(queryString.charAt(wordEndIndex)) == -1) {
                    ++wordEndIndex;
                }
                if (queryString.charAt(poundIndex + 1) == this.query.getParameterDelimiterChar()) {
                    if (queryString.charAt(poundIndex + 2) == this.query.getParameterDelimiterChar()) {
                        if (queryString.charAt(poundIndex + 3) == this.query.getParameterDelimiterChar()) {
                            fieldName = queryString.substring(poundIndex + 4, wordEndIndex);
                            field = this.createField(fieldName);
                            this.appendInOut(writer, field);
                        } else {
                            fieldName = queryString.substring(poundIndex + 3, wordEndIndex);
                            field = this.createField(fieldName);
                            this.appendOut(writer, field);
                        }
                    } else {
                        fieldName = queryString.substring(poundIndex + 2, wordEndIndex);
                        field = this.createField(fieldName);
                        this.appendModify(writer, field);
                    }
                } else {
                    fieldName = queryString.substring(poundIndex + 1, wordEndIndex);
                    field = this.createField(fieldName);
                    this.appendIn(writer, field);
                }
                lastIndex = wordEndIndex;
            }
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void translatePureSQLCustomQuery() {
        int lastIndex = 0;
        String queryString = this.getQueryString();
        int parameterIndex = 1;
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            while (lastIndex != -1) {
                String token;
                int markIndex = queryString.indexOf(63, lastIndex);
                if (markIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    token = queryString.substring(lastIndex, markIndex);
                    lastIndex = markIndex + 1;
                } else {
                    boolean hasPairedQuoteBeforeMark = true;
                    int quotePairIndex = markIndex;
                    while ((quotePairIndex = queryString.lastIndexOf(39, quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                        hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
                    }
                    int endQuoteIndex = -1;
                    if (!hasPairedQuoteBeforeMark) {
                        endQuoteIndex = queryString.indexOf(39, markIndex + 1);
                    }
                    if (endQuoteIndex != -1) {
                        token = queryString.substring(lastIndex, endQuoteIndex + 1);
                        markIndex = -1;
                        lastIndex = endQuoteIndex + 1;
                    } else {
                        token = queryString.substring(lastIndex, markIndex);
                        lastIndex = markIndex + 1;
                    }
                }
                writer.write(token);
                if (markIndex == -1) continue;
                int wordEndIndex = markIndex + 1;
                while (wordEndIndex < queryString.length() && this.whitespace().indexOf(queryString.charAt(wordEndIndex)) == -1) {
                    ++wordEndIndex;
                }
                if (wordEndIndex > markIndex + 1) {
                    String fieldName = queryString.substring(markIndex + 1, wordEndIndex);
                    DatabaseField field = this.createField(fieldName);
                    this.appendIn(writer, field);
                    lastIndex = wordEndIndex;
                    continue;
                }
                DatabaseField field = this.createField(String.valueOf(parameterIndex));
                ++parameterIndex;
                this.appendIn(writer, field);
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.setQueryString(((Object)writer).toString());
    }

    protected DatabaseField createField(String fieldName) {
        return new DatabaseField(fieldName);
    }

    public void appendLiteral(Writer writer, Object literal) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.appendLiteral(literal);
    }

    public void appendTranslation(Writer writer, DatabaseField modifyField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.appendTranslation(modifyField);
    }

    public void appendModify(Writer writer, DatabaseField modifyField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.appendModify(modifyField);
    }

    public void appendIn(Writer writer, DatabaseField field) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.appendIn(field);
    }

    public void appendInOut(Writer writer, DatabaseField inoutField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.appendInOut(inoutField);
    }

    public void appendOut(Writer writer, DatabaseField outField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.appendOut(outField);
    }

    public void appendLiteral(Object literal) {
        this.getParameters().add(literal);
        this.getParameterTypes().add(ParameterType.LITERAL);
        this.getParameterBindings().add(true);
    }

    public void appendLiteral(Object literal, Boolean shouldBind) {
        this.getParameters().add(literal);
        this.getParameterTypes().add(ParameterType.LITERAL);
        this.getParameterBindings().add(shouldBind);
    }

    public void appendTranslation(DatabaseField modifyField) {
        this.getParameters().add(modifyField);
        this.getParameterTypes().add(ParameterType.TRANSLATION);
        this.getParameterBindings().add(true);
    }

    public void appendTranslation(DatabaseField modifyField, Boolean shouldBind) {
        this.getParameters().add(modifyField);
        this.getParameterTypes().add(ParameterType.TRANSLATION);
        this.getParameterBindings().add(shouldBind);
    }

    public void appendModify(DatabaseField modifyField) {
        this.getParameters().add(modifyField);
        this.getParameterTypes().add(ParameterType.MODIFY);
        this.getParameterBindings().add(true);
    }

    public void appendModify(DatabaseField modifyField, Boolean shouldBind) {
        this.getParameters().add(modifyField);
        this.getParameterTypes().add(ParameterType.MODIFY);
        this.getParameterBindings().add(shouldBind);
    }

    public void appendIn(Object inObject) {
        this.getParameters().add(inObject);
        this.getParameterTypes().add(ParameterType.IN);
        this.getParameterBindings().add(true);
    }

    public void appendIn(Object inObject, Boolean shouldBind) {
        this.getParameters().add(inObject);
        this.getParameterTypes().add(ParameterType.IN);
        this.getParameterBindings().add(shouldBind);
    }

    public void appendInOut(DatabaseField inoutField) {
        Object[] inOut = new Object[]{inoutField, inoutField};
        this.getParameters().add(inOut);
        this.getParameterTypes().add(ParameterType.INOUT);
        this.getParameterBindings().add(true);
    }

    public void appendInOut(DatabaseField inoutField, Boolean shouldBind) {
        Object[] inOut = new Object[]{inoutField, inoutField};
        this.getParameters().add(inOut);
        this.getParameterTypes().add(ParameterType.INOUT);
        this.getParameterBindings().add(shouldBind);
    }

    public void appendInOut(Object inValueOrField, DatabaseField outField) {
        Object[] inOut = new Object[]{inValueOrField, outField};
        this.getParameters().add(inOut);
        this.getParameterTypes().add(ParameterType.INOUT);
        this.getParameterBindings().add(true);
    }

    public void appendInOut(Object inValueOrField, DatabaseField outField, Boolean shouldBind) {
        Object[] inOut = new Object[]{inValueOrField, outField};
        this.getParameters().add(inOut);
        this.getParameterTypes().add(ParameterType.INOUT);
        this.getParameterBindings().add(shouldBind);
    }

    public void appendOut(DatabaseField outField) {
        this.getParameters().add(outField);
        this.getParameterTypes().add(ParameterType.OUT);
        this.getParameterBindings().add(true);
    }

    public void appendOut(DatabaseField outField, Boolean shouldBind) {
        this.getParameters().add(outField);
        this.getParameterTypes().add(ParameterType.OUT);
        this.getParameterBindings().add(shouldBind);
    }

    public void appendOutCursor(DatabaseField outField) {
        this.getParameters().add(outField);
        this.getParameterTypes().add(ParameterType.OUT_CURSOR);
        this.getParameterBindings().add(true);
        this.getOutputCursors().add(outField);
    }

    public void appendOutCursor(DatabaseField outField, Boolean shouldBind) {
        this.getParameters().add(outField);
        this.getParameterTypes().add(ParameterType.OUT_CURSOR);
        this.getParameterBindings().add(shouldBind);
        this.getOutputCursors().add(outField);
    }

    public void appendParameter(Writer writer, Object parameter, boolean shouldBind, AbstractSession session) {
        session.getDatasourcePlatform().appendParameter(this, writer, parameter);
    }

    protected char argumentMarker() {
        return '?';
    }

    protected String whitespace() {
        return ",); \n\t:";
    }

    public void translateQueryString(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (this.parameters == null || this.getParameters().isEmpty()) {
            return;
        }
        if (this.getQueryString().indexOf(this.argumentMarker()) == -1) {
            return;
        }
        int lastIndex = 0;
        int parameterIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            List parameterFields = this.getParameters();
            List<ParameterType> parameterTypes = this.getParameterTypes();
            this.setParameters(new ArrayList<Object>(parameterFields.size()));
            while (lastIndex != -1) {
                Object value;
                String token;
                int tokenIndex = queryString.indexOf(this.argumentMarker(), lastIndex);
                if (tokenIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    token = queryString.substring(lastIndex, tokenIndex);
                } else {
                    boolean hasPairedQuoteBeforeMark = true;
                    int quotePairIndex = tokenIndex;
                    while ((quotePairIndex = queryString.lastIndexOf(39, quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                        hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
                    }
                    int endQuoteIndex = -1;
                    if (!hasPairedQuoteBeforeMark) {
                        endQuoteIndex = queryString.indexOf(39, tokenIndex + 1);
                    }
                    if (endQuoteIndex != -1) {
                        token = queryString.substring(lastIndex, endQuoteIndex + 1);
                        tokenIndex = -1;
                        lastIndex = endQuoteIndex + 1;
                    } else {
                        token = queryString.substring(lastIndex, tokenIndex);
                        lastIndex = tokenIndex + 1;
                    }
                }
                writer.write(token);
                if (tokenIndex == -1) continue;
                ParameterType parameterType = parameterTypes.get(parameterIndex);
                Object parameter = parameterFields.get(parameterIndex);
                if (parameterType == ParameterType.MODIFY) {
                    DatabaseField field = (DatabaseField)parameter;
                    value = modifyRow.get(field);
                    this.appendParameter(writer, value, false, session);
                } else if (parameterType == ParameterType.CUSTOM_MODIFY) {
                    DatabaseField field = (DatabaseField)parameter;
                    value = modifyRow.get(field);
                    if (value != null && (value = session.getDatasourcePlatform().getCustomModifyValueForCall(this, value, field, false)) instanceof BindCallCustomParameter && ((BindCallCustomParameter)value).shouldUseUnwrappedConnection()) {
                        this.isNativeConnectionRequired = true;
                    }
                    this.appendParameter(writer, value, false, session);
                } else if (parameterType == ParameterType.TRANSLATION) {
                    Object value2 = null;
                    if (parameter instanceof ParameterExpression) {
                        value2 = ((ParameterExpression)parameter).getValue(translationRow, this.getQuery(), session);
                    } else {
                        DatabaseField field = (DatabaseField)parameter;
                        value2 = translationRow.get(field);
                        if (value2 == null && modifyRow != null) {
                            value2 = modifyRow.get(field);
                        }
                    }
                    this.appendParameter(writer, value2, false, session);
                } else if (parameterType == ParameterType.LITERAL) {
                    if (parameter instanceof DatabaseField) {
                        parameter = null;
                    }
                    this.appendParameter(writer, parameter, false, session);
                } else if (parameterType == ParameterType.IN) {
                    Object value3 = this.getValueForInParameter(parameter, translationRow, modifyRow, session, false);
                    this.appendParameter(writer, value3, false, session);
                } else if (parameterType == ParameterType.INOUT) {
                    Object value4 = this.getValueForInOutParameter(parameter, translationRow, modifyRow, session);
                    this.appendParameter(writer, value4, false, session);
                } else if (parameterType == ParameterType.INLINE) {
                    writer.write((String)parameter);
                } else if (parameterType == ParameterType.OUT || parameterType == ParameterType.OUT_CURSOR) {
                    if (parameter instanceof DatabaseField) {
                        parameter = null;
                    }
                    this.appendParameter(writer, parameter, false, session);
                }
                lastIndex = tokenIndex + 1;
                ++parameterIndex;
            }
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void translateQueryStringAndBindParameters(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        List parameters = this.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        String marker = "" + this.argumentMarker();
        StringBuilder queryString = new StringBuilder(this.getQueryString());
        if (queryString.indexOf(marker) == -1) {
            return;
        }
        int lastIndex = 0;
        int tokenIndex = -1;
        boolean hasParameterizedIN = false;
        int size = parameters.size();
        ArrayList<Object> translatedParametersValues = new ArrayList<Object>(size);
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            List parameterFields = this.getParameters();
            List<ParameterType> parameterTypes = this.getParameterTypes();
            List<Boolean> canBindParameters = this.getParameterBindings();
            this.setParameters(new ArrayList<Object>(parameterFields.size()));
            int parameterIndex = 0;
            while (parameterIndex < size) {
                tokenIndex = queryString.indexOf(marker, tokenIndex + 1);
                if (!this.shouldProcessTokenInQuotes) {
                    while (true) {
                        boolean hasPairedQuoteBeforeMark = true;
                        int quotePairIndex = tokenIndex;
                        while ((quotePairIndex = queryString.lastIndexOf(String.valueOf('\''), quotePairIndex - 1)) != -1 && quotePairIndex > lastIndex) {
                            hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
                        }
                        int endQuoteIndex = -1;
                        if (!hasPairedQuoteBeforeMark) {
                            endQuoteIndex = queryString.indexOf(String.valueOf('\''), tokenIndex + 1);
                        }
                        if (endQuoteIndex == -1) break;
                        tokenIndex = queryString.indexOf(marker, tokenIndex + 1);
                    }
                }
                DatabaseField field = null;
                Object translatedValue = null;
                Object parameterValue = parameterFields.get(parameterIndex);
                ParameterType parameterType = parameterTypes.get(parameterIndex);
                Boolean canBind = canBindParameters.get(parameterIndex);
                switch (parameterType) {
                    case MODIFY: {
                        String token;
                        field = (DatabaseField)parameterValue;
                        translatedValue = modifyRow.get(field);
                        if (translatedValue == null && (translatedValue = modifyRow.getField(field)) == null) {
                            translatedValue = field;
                        }
                        if (Boolean.FALSE.equals(canBind)) {
                            token = queryString.substring(lastIndex, tokenIndex);
                            writer.write(token);
                            lastIndex = tokenIndex + 1;
                            this.appendParameter(writer, translatedValue, false, session);
                            break;
                        }
                        translatedParametersValues.add(translatedValue);
                        break;
                    }
                    case CUSTOM_MODIFY: {
                        String token;
                        field = (DatabaseField)parameterValue;
                        translatedValue = modifyRow.get(field);
                        translatedValue = session.getPlatform().getCustomModifyValueForCall(this, translatedValue, field, true);
                        if (translatedValue != null && translatedValue instanceof BindCallCustomParameter && ((BindCallCustomParameter)translatedValue).shouldUseUnwrappedConnection()) {
                            this.isNativeConnectionRequired = true;
                        }
                        if (translatedValue == null && (translatedValue = modifyRow.getField(field)) == null) {
                            translatedValue = field;
                        }
                        if (Boolean.FALSE.equals(canBind)) {
                            token = queryString.substring(lastIndex, tokenIndex);
                            writer.write(token);
                            lastIndex = tokenIndex + 1;
                            this.appendParameter(writer, translatedValue, false, session);
                            break;
                        }
                        translatedParametersValues.add(translatedValue);
                        break;
                    }
                    case TRANSLATION: {
                        String token;
                        if (parameterValue instanceof ParameterExpression) {
                            field = ((ParameterExpression)parameterValue).getField();
                            translatedValue = ((ParameterExpression)parameterValue).getValue(translationRow, this.query, session);
                        } else {
                            field = (DatabaseField)parameterValue;
                            translatedValue = translationRow.get(field);
                            if (translatedValue == null) {
                                translatedValue = modifyRow.get(field);
                            }
                        }
                        if (translatedValue instanceof Collection && !Boolean.FALSE.equals(canBind)) {
                            hasParameterizedIN = true;
                        }
                        if (translatedValue == null && field != null) {
                            if (this.query.hasNullableArguments() && this.query.getNullableArguments().contains(field)) break;
                            translatedValue = translationRow.getField(field);
                            if (translatedValue == null) {
                                translatedValue = field;
                            }
                            if (Boolean.FALSE.equals(canBind)) {
                                token = queryString.substring(lastIndex, tokenIndex);
                                writer.write(token);
                                lastIndex = tokenIndex + 1;
                                this.appendParameter(writer, translatedValue, false, session);
                                break;
                            }
                            translatedParametersValues.add(translatedValue);
                            break;
                        }
                        if (Boolean.FALSE.equals(canBind)) {
                            token = queryString.substring(lastIndex, tokenIndex);
                            writer.write(token);
                            lastIndex = tokenIndex + 1;
                            this.appendParameter(writer, translatedValue, false, session);
                            break;
                        }
                        translatedParametersValues.add(translatedValue);
                        break;
                    }
                    case LITERAL: {
                        String token;
                        translatedValue = parameterValue;
                        if (Boolean.FALSE.equals(canBind)) {
                            token = queryString.substring(lastIndex, tokenIndex);
                            writer.write(token);
                            lastIndex = tokenIndex + 1;
                            if (parameterValue instanceof DatabaseField) {
                                translatedValue = null;
                            }
                            this.appendParameter(writer, translatedValue, false, session);
                            break;
                        }
                        translatedParametersValues.add(translatedValue);
                        break;
                    }
                    case IN: {
                        String token;
                        translatedValue = this.getValueForInParameter(parameterValue, translationRow, modifyRow, session, true);
                        if (translatedValue == this) break;
                        if (Boolean.FALSE.equals(canBind)) {
                            token = queryString.substring(lastIndex, tokenIndex);
                            writer.write(token);
                            lastIndex = tokenIndex + 1;
                            this.appendParameter(writer, translatedValue, false, session);
                            break;
                        }
                        translatedParametersValues.add(translatedValue);
                        break;
                    }
                    case INOUT: {
                        String token;
                        translatedValue = this.getValueForInOutParameter(parameterValue, translationRow, modifyRow, session);
                        if (Boolean.FALSE.equals(canBind)) {
                            token = queryString.substring(lastIndex, tokenIndex);
                            writer.write(token);
                            lastIndex = tokenIndex + 1;
                            this.appendParameter(writer, translatedValue, false, session);
                            break;
                        }
                        translatedParametersValues.add(translatedValue);
                        break;
                    }
                    case OUT: 
                    case OUT_CURSOR: {
                        String token;
                        if (parameterValue != null && parameterValue instanceof OutputParameterForCallableStatement) {
                            ((OutputParameterForCallableStatement)parameterValue).getOutputField().setIndex(parameterIndex);
                        }
                        if (Boolean.FALSE.equals(canBind)) {
                            token = queryString.substring(lastIndex, tokenIndex);
                            writer.write(token);
                            lastIndex = tokenIndex + 1;
                            this.appendParameter(writer, translatedValue, false, session);
                            break;
                        }
                        translatedParametersValues.add(translatedValue);
                    }
                }
                ++parameterIndex;
            }
            if (((Object)writer).toString().length() > 0) {
                String token = queryString.substring(lastIndex);
                writer.write(token);
                this.setQueryString(((Object)writer).toString());
            }
            if (translatedParametersValues.size() > 0) {
                this.setParameters(translatedParametersValues);
            }
            if (hasParameterizedIN) {
                this.translateQueryStringForParameterizedIN(translationRow, modifyRow, session);
            }
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    public void translateQueryStringForParameterizedIN(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        int lastIndex = 0;
        int parameterIndex = 0;
        String queryString = this.getQueryString();
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            List parameters = this.getParameters();
            ArrayList<Object> parametersValues = new ArrayList<Object>(parameters.size());
            while (lastIndex != -1) {
                String token;
                int tokenIndex = queryString.indexOf(this.argumentMarker(), lastIndex);
                if (tokenIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else {
                    token = queryString.substring(lastIndex, tokenIndex);
                }
                writer.write(token);
                if (tokenIndex == -1) continue;
                Object parameter = parameters.get(parameterIndex);
                if (parameter instanceof Collection) {
                    int index;
                    int size;
                    Collection values = (Collection)parameter;
                    writer.write("(");
                    if (values.size() > 0 && values.iterator().next() instanceof List) {
                        size = values.size();
                        Iterator valuesIterator = values.iterator();
                        index = 0;
                        while (index < size) {
                            List nestedValues = (List)valuesIterator.next();
                            parametersValues.addAll(nestedValues);
                            int nestedSize = nestedValues.size();
                            writer.write("(");
                            int nestedIndex = 0;
                            while (nestedIndex < nestedSize) {
                                writer.write("?");
                                if (nestedIndex + 1 < nestedSize) {
                                    writer.write(",");
                                }
                                ++nestedIndex;
                            }
                            writer.write(")");
                            if (index + 1 < size) {
                                writer.write(",");
                            }
                            ++index;
                        }
                    } else {
                        parametersValues.addAll(values);
                        size = values.size();
                        int limit = ((DatasourcePlatform)session.getDatasourcePlatform()).getINClauseLimit();
                        if (limit > 0) {
                            boolean not = token.endsWith(" NOT IN ");
                            String subToken = token.substring(0, token.length() - (not ? " NOT IN " : " IN ").length());
                            int spaceIndex = subToken.lastIndexOf(32);
                            int braceIndex = subToken.lastIndexOf(40);
                            String fieldName = subToken.substring((spaceIndex > braceIndex ? spaceIndex : braceIndex) + 1);
                            String inToken = not ? ") AND " + fieldName + " NOT IN (" : ") OR " + fieldName + " IN (";
                            int index2 = 0;
                            while (index2 < size) {
                                writer.write("?");
                                if (index2 + 1 < size) {
                                    if (index2 > 0 && (index2 + 1) % limit == 0) {
                                        writer.write(inToken);
                                    } else {
                                        writer.write(",");
                                    }
                                }
                                ++index2;
                            }
                        } else {
                            index = 0;
                            while (index < size) {
                                writer.write("?");
                                if (index + 1 < size) {
                                    writer.write(",");
                                }
                                ++index;
                            }
                        }
                    }
                    writer.write(")");
                } else {
                    parametersValues.add(parameter);
                    writer.write("?");
                }
                lastIndex = tokenIndex + 1;
                ++parameterIndex;
            }
            this.setParameters(parametersValues);
            this.setQueryString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    protected Object getValueForInParameter(Object parameter, AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session, boolean shouldBind) {
        Object value = parameter;
        DatabaseField field = null;
        boolean isNull = false;
        if (parameter instanceof ParameterExpression) {
            value = ((ParameterExpression)parameter).getValue(translationRow, this.getQuery(), session);
            field = ((ParameterExpression)parameter).getField();
        } else if (parameter instanceof DatabaseField) {
            DatabaseField modifyField;
            field = (DatabaseField)parameter;
            value = translationRow.get(field);
            if (modifyRow != null) {
                if (value == null) {
                    value = modifyRow.get(field);
                }
                if (value != null && (modifyField = modifyRow.getField(field)) != null && session.getDatasourcePlatform().shouldUseCustomModifyForCall(modifyField)) {
                    value = session.getDatasourcePlatform().getCustomModifyValueForCall(this, value, modifyField, shouldBind);
                }
            }
            if (value == null && shouldBind) {
                isNull = true;
                if (field.getType() != null || field.getSqlType() != Integer.MIN_VALUE) {
                    value = field;
                } else if (modifyRow != null && (modifyField = modifyRow.getField(field)) != null && modifyField.getType() != null) {
                    value = modifyField;
                }
                if (value == null) {
                    DatabaseField translationField = translationRow.getField(field);
                    if (translationField == null) {
                        session.log(6, "sql", "named_argument_not_found_in_query_parameters", new Object[]{field});
                    }
                    if (translationField != null && translationField.getType() != null) {
                        value = translationField;
                    }
                }
            } else if (parameter instanceof ObjectRelationalDatabaseField) {
                value = new InParameterForCallableStatement(value, (DatabaseField)parameter);
            }
        }
        if ((value == null || isNull) && this.query.hasNullableArguments() && this.query.getNullableArguments().contains(field)) {
            return this;
        }
        return value;
    }

    protected Object getValueForInOutParameter(Object parameter, AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        Object inParameter = ((Object[])parameter)[0];
        Object inValue = this.getValueForInParameter(inParameter, translationRow, modifyRow, session, true);
        Object outParameter = ((Object[])parameter)[1];
        return this.createInOutParameter(inValue, outParameter, session);
    }

    protected Object createInOutParameter(Object inValue, Object outParameter, AbstractSession session) {
        Object[] inOut = new Object[]{inValue, outParameter};
        return inOut;
    }

    private boolean hasArgumentMark(String string, char mark, char quote) {
        int markIndex;
        int quoteIndex = -1;
        int lastEndQuoteIndex = -1;
        do {
            if ((markIndex = string.indexOf(mark, lastEndQuoteIndex + 1)) == -1) {
                return false;
            }
            quoteIndex = string.lastIndexOf(quote, markIndex);
            if (quoteIndex == -1) {
                return true;
            }
            boolean hasPairedQuoteBeforeMark = false;
            while (quoteIndex != -1 && quoteIndex >= lastEndQuoteIndex) {
                if ((quoteIndex = string.lastIndexOf(quote, quoteIndex - 1)) == -1) continue;
                boolean bl = hasPairedQuoteBeforeMark = !hasPairedQuoteBeforeMark;
            }
            if (!hasPairedQuoteBeforeMark) continue;
            return true;
        } while ((lastEndQuoteIndex = string.indexOf(quote, markIndex + 1)) != -1);
        return true;
    }

    public void setIsNativeConnectionRequired(boolean isNativeConnectionRequired) {
        this.isNativeConnectionRequired = isNativeConnectionRequired;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.parameterTypes != null) {
            ArrayList<ParameterType> newParameterTypes = new ArrayList<ParameterType>(this.parameterTypes.size());
            for (ParameterType type : this.parameterTypes) {
                if (ParameterType.LITERAL.equals((Object)type)) {
                    newParameterTypes.add(ParameterType.LITERAL);
                    continue;
                }
                if (ParameterType.MODIFY.equals((Object)type)) {
                    newParameterTypes.add(ParameterType.MODIFY);
                    continue;
                }
                if (ParameterType.TRANSLATION.equals((Object)type)) {
                    newParameterTypes.add(ParameterType.TRANSLATION);
                    continue;
                }
                if (ParameterType.CUSTOM_MODIFY.equals((Object)type)) {
                    newParameterTypes.add(ParameterType.CUSTOM_MODIFY);
                    continue;
                }
                if (ParameterType.OUT.equals((Object)type)) {
                    newParameterTypes.add(ParameterType.OUT);
                    continue;
                }
                if (ParameterType.INOUT.equals((Object)type)) {
                    newParameterTypes.add(ParameterType.INOUT);
                    continue;
                }
                if (ParameterType.IN.equals((Object)type)) {
                    newParameterTypes.add(ParameterType.IN);
                    continue;
                }
                if (!ParameterType.OUT_CURSOR.equals((Object)type)) continue;
                newParameterTypes.add(ParameterType.OUT_CURSOR);
            }
            this.parameterTypes = newParameterTypes;
        }
    }

    public static enum ParameterType {
        LITERAL(1),
        MODIFY(2),
        TRANSLATION(3),
        CUSTOM_MODIFY(4),
        OUT(5),
        INOUT(6),
        IN(7),
        OUT_CURSOR(8),
        INLINE(9);

        public int val;

        private ParameterType(int val) {
            this.val = val;
        }

        public static ParameterType valueOf(String string) {
            return Enum.valueOf(ParameterType.class, string);
        }
    }
}

