/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.jaas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.jaas.modules.WSLoginModuleImpl;
import com.ibm.ws.security.jaas.common.JAASConfiguration;
import com.ibm.ws.security.jaas.common.JAASLoginContextEntry;
import com.ibm.ws.security.jaas.common.JAASLoginModuleConfig;
import com.ibm.ws.security.kerberos.auth.Krb5LoginModuleWrapper;
import com.ibm.ws.security.krb5.Krb5Common;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={JAASConfiguration.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JAASConfigurationImpl
implements JAASConfiguration {
    static final TraceComponent tc = Tr.register(JAASConfigurationImpl.class, (String)"Authentication", (String)"com.ibm.ws.security.authentication.internal.resources.AuthenticationMessages");
    static final List<String> defaultEntryIds = Collections.unmodifiableList(Arrays.asList("system.UNAUTHENTICATED", "system.WEB_INBOUND", "system.DEFAULT", "system.DESERIALIZE_CONTEXT", "system.RMI_INBOUND", "WSLogin"));
    public static final Class<WSLoginModuleImpl> WSLOGIN_MODULE_IMPL_CLASS = WSLoginModuleImpl.class;
    private ConcurrentServiceReferenceMap<String, JAASLoginContextEntry> jaasLoginContextEntries;
    static final long serialVersionUID = 2228981568441186307L;

    public void setJaasLoginContextEntries(ConcurrentServiceReferenceMap<String, JAASLoginContextEntry> jaasLoginContextEntries) {
        this.jaasLoginContextEntries = jaasLoginContextEntries;
    }

    public Map<String, List<AppConfigurationEntry>> getEntries() {
        HashMap<String, List<AppConfigurationEntry>> jaasConfigurationEntries = new HashMap<String, List<AppConfigurationEntry>>();
        HashMap<String, String> jaasConfigIDs = new HashMap<String, String>();
        if (this.jaasLoginContextEntries != null) {
            this.createJAASClientLoginContextEntry(jaasConfigurationEntries);
            Iterator lcEntries = this.jaasLoginContextEntries.getServices();
            while (lcEntries.hasNext()) {
                List<AppConfigurationEntry> appConfEntry;
                JAASLoginContextEntry loginContextEntry = (JAASLoginContextEntry)lcEntries.next();
                String entryName = loginContextEntry.getEntryName();
                List loginModules = loginContextEntry.getLoginModules();
                if ("system.DEFAULT".equalsIgnoreCase(entryName)) {
                    this.ensureProxyIsNotSpecifyInSystemDefaultEntry(entryName, loginModules);
                }
                if ((appConfEntry = this.getLoginModules(loginModules)) == null || appConfEntry.isEmpty()) continue;
                if (jaasConfigIDs.containsKey(entryName)) {
                    String id = (String)jaasConfigIDs.get(entryName);
                    Tr.warning((TraceComponent)tc, (String)"JAAS_LOGIN_CONTEXT_ENTRY_HAS_DUPLICATE_NAME", (Object[])new Object[]{entryName, id, loginContextEntry.getId()});
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("configure jaasContextLoginEntry id: " + loginContextEntry.getId()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("configure jaasContextLoginEntry: " + entryName + " has " + appConfEntry.size() + " loginModule(s)"), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("appConfEntry: " + appConfEntry), (Object[])new Object[0]);
                }
                jaasConfigurationEntries.put(entryName, appConfEntry);
                jaasConfigIDs.put(entryName, loginContextEntry.getId());
            }
        }
        return jaasConfigurationEntries;
    }

    private void ensureProxyIsNotSpecifyInSystemDefaultEntry(String entryName, List<JAASLoginModuleConfig> loginModules) {
        Iterator<JAASLoginModuleConfig> i = loginModules.iterator();
        while (i.hasNext()) {
            JAASLoginModuleConfig loginModule = i.next();
            if (!loginModule.getId().equalsIgnoreCase("proxy")) continue;
            Tr.warning((TraceComponent)tc, (String)"JAAS_PROXY_IS_NOT_SUPPORT_IN_SYSTEM_DEFAULT", (Object[])new Object[0]);
            i.remove();
        }
    }

    List<AppConfigurationEntry> getLoginModules(List<JAASLoginModuleConfig> loginModules) {
        ArrayList<AppConfigurationEntry> loginModuleEntries = new ArrayList<AppConfigurationEntry>();
        for (JAASLoginModuleConfig loginModule : loginModules) {
            if (loginModule != null) {
                AppConfigurationEntry loginModuleEntry = this.createAppConfigurationEntry(loginModule);
                loginModuleEntries.add(loginModuleEntry);
                continue;
            }
            throw new IllegalStateException("Missing login module: found: " + loginModules);
        }
        return loginModuleEntries;
    }

    AppConfigurationEntry createAppConfigurationEntry(JAASLoginModuleConfig loginModule) throws IllegalArgumentException {
        String loginModuleClassName = loginModule.getClassName();
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = loginModule.getControlFlag();
        Map options = loginModule.getOptions();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("loginModuleClassName: " + loginModuleClassName + " options: " + options.toString() + " controlFlag: " + controlFlag.toString()), (Object[])new Object[0]);
        }
        AppConfigurationEntry loginModuleEntry = new AppConfigurationEntry(loginModuleClassName, controlFlag, options);
        return loginModuleEntry;
    }

    private void createJAASClientLoginContextEntry(Map<String, List<AppConfigurationEntry>> jaasConfigurationEntries) throws IllegalArgumentException {
        if (Krb5Common.IBM_KRB5_LOGIN_MODULE_AVAILABLE) {
            List<AppConfigurationEntry> loginModuleEntries = this.createIBMKrb5loginModuleAppConfigurationEntry();
            jaasConfigurationEntries.put("JAASClient", loginModuleEntries);
            jaasConfigurationEntries.put("com.ibm.security.auth.module.Krb5LoginModule", loginModuleEntries);
        } else if (Krb5Common.OTHER_KRB5_LOGIN_MODULE_AVAILABLE) {
            List<AppConfigurationEntry> loginModuleEntries = this.createOtherKrb5loginModuleAppConfigurationEntry(false, "true");
            jaasConfigurationEntries.put("JAASClient", loginModuleEntries);
            jaasConfigurationEntries.put("com.sun.security.auth.module.Krb5LoginModule", loginModuleEntries);
            jaasConfigurationEntries.put("com.sun.security.jgss.krb5.initiate", loginModuleEntries);
            loginModuleEntries = this.createOtherKrb5loginModuleAppConfigurationEntry(true, "true");
            jaasConfigurationEntries.put("com.sun.security.jgss.krb5.accept", loginModuleEntries);
        }
    }

    private List<AppConfigurationEntry> createIBMKrb5loginModuleAppConfigurationEntry() {
        AppConfigurationEntry loginModuleEntry;
        ArrayList<AppConfigurationEntry> loginModuleEntries = new ArrayList<AppConfigurationEntry>();
        String loginModuleClassName = "com.ibm.security.auth.module.Krb5LoginModule";
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("credsType", "both");
        options.put("forwardable", "true");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            options.put("debug", "true");
            Tr.debug((TraceComponent)tc, (String)("loginModuleClassName: " + loginModuleClassName + " options: " + ((Object)options).toString() + " controlFlag: " + controlFlag.toString()), (Object[])new Object[0]);
        }
        if ((loginModuleEntry = new AppConfigurationEntry(loginModuleClassName, controlFlag, options)) != null) {
            loginModuleEntries.add(loginModuleEntry);
        }
        return loginModuleEntries;
    }

    private List<AppConfigurationEntry> createOtherKrb5loginModuleAppConfigurationEntry(boolean proxy, String initiatorValue) {
        AppConfigurationEntry loginModuleEntry;
        ArrayList<AppConfigurationEntry> loginModuleEntries = new ArrayList<AppConfigurationEntry>();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String loginModuleClassName = Krb5LoginModuleWrapper.class.getCanonicalName();
        if (proxy) {
            loginModuleClassName = "com.ibm.ws.kernel.boot.security.LoginModuleProxy";
            options.put("kernelDelegate", Krb5LoginModuleWrapper.class);
        }
        AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        options.put("useKeyTab", "true");
        options.put("refreshKrb5Config", "true");
        options.put("doNotPrompt", "true");
        options.put("storeKey", "true");
        options.put("isInitiator", initiatorValue);
        options.put("keyTab", Krb5Common.getSystemProperty((String)"KRB5_KTNAME"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            options.put("debug", "true");
            Tr.debug((TraceComponent)tc, (String)("loginModuleClassName: " + loginModuleClassName + " options: " + ((Object)options).toString() + " controlFlag: " + controlFlag.toString()), (Object[])new Object[0]);
        }
        if ((loginModuleEntry = new AppConfigurationEntry(loginModuleClassName, controlFlag, options)) != null) {
            loginModuleEntries.add(loginModuleEntry);
        }
        return loginModuleEntries;
    }
}

