/*
 * Decompiled with CFR 0.152.
 */
package org.crac;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.lang.constant.Constable;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.Deque;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.crac.CheckpointException;
import org.crac.Context;
import org.crac.Resource;
import org.crac.RestoreException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class LibertyCheckpoint
implements CheckpointHook {
    private static final TraceComponent tc = Tr.register(LibertyCheckpoint.class, (String)"checkpoint", (String)"io.openliberty.crac.resources.CRaCMessages");
    private static final Deque<CheckpointHook> hooks = new ConcurrentLinkedDeque<CheckpointHook>();
    private static final AtomicBoolean registerHookService = new AtomicBoolean(false);
    static final long serialVersionUID = -5977325297750859944L;

    LibertyCheckpoint() {
    }

    public void prepare() {
        this.callHooks(hooks.descendingIterator(), CheckpointHook::prepare, () -> new CheckpointException(Tr.formatMessage((TraceComponent)tc, (String)"CRAC_RESOURCE_CHECKPOINT_FAIL_CWWKC0551", (Object[])new Object[0])));
    }

    public void checkpointFailed() {
        this.restore();
    }

    public void restore() {
        this.callHooks(hooks.iterator(), CheckpointHook::restore, () -> new RestoreException(Tr.formatMessage((TraceComponent)tc, (String)"CRAC_RESOURCE_RESTORE_FAIL_CWWKC0552", (Object[])new Object[0])));
        hooks.clear();
    }

    @FFDCIgnore(value={Exception.class})
    private void callHooks(Iterator<CheckpointHook> toCall, Consumer<CheckpointHook> method, Supplier<Exception> toThrow) {
        Throwable createdToThrow = null;
        while (toCall.hasNext()) {
            try {
                method.accept(toCall.next());
            }
            catch (Exception e) {
                if (createdToThrow == null) {
                    createdToThrow = toThrow.get();
                }
                createdToThrow.addSuppressed(e);
            }
        }
        if (createdToThrow != null) {
            createdToThrow.fillInStackTrace();
            LibertyCheckpoint.sneakyThrow(createdToThrow);
        }
    }

    static void register(Resource r, final Context<? extends Resource> c) {
        LibertyCheckpoint.debug(tc, () -> "Registering resource " + r + " from context " + c);
        CheckpointPhase phase = CheckpointPhase.getPhase();
        if (phase == CheckpointPhase.INACTIVE) {
            return;
        }
        LibertyCheckpoint.registerHookService();
        final WeakReference<Resource> ref = new WeakReference<Resource>(r);
        CheckpointHook hook = new CheckpointHook(){
            static final long serialVersionUID = -6603746518595533626L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @FFDCIgnore(value={Exception.class})
            public void prepare() {
                try {
                    Resource current = (Resource)ref.get();
                    if (current != null) {
                        LibertyCheckpoint.debug(tc, () -> "Calling beforeCheckpoint on " + current);
                        current.beforeCheckpoint(c);
                    }
                }
                catch (Exception e) {
                    LibertyCheckpoint.sneakyThrow(e);
                }
            }

            @FFDCIgnore(value={Exception.class})
            public void restore() {
                try {
                    Resource current = (Resource)ref.get();
                    if (current != null) {
                        LibertyCheckpoint.debug(tc, () -> "Calling afterRestore on " + current);
                        current.afterRestore(c);
                    }
                }
                catch (Exception e) {
                    LibertyCheckpoint.sneakyThrow(e);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.crac.LibertyCheckpoint$1", 1.class, (String)"checkpoint", (String)"io.openliberty.crac.resources.CRaCMessages");
            }
        };
        hooks.addLast(hook);
    }

    static void checkpointRestore() throws RestoreException, CheckpointException {
        LibertyCheckpoint.debug(tc, () -> "Requesting an application initiated checkpoint.");
        String errorMessage = Tr.formatMessage((TraceComponent)tc, (String)"CRAC_RESOURCE_REQUEST_CHECKPOINT_CWWKC0553", (Object[])new Object[0]);
        final Exception fail = CheckpointPhase.INACTIVE == CheckpointPhase.getPhase() ? new UnsupportedOperationException(errorMessage) : new CheckpointException(errorMessage);
        fail.fillInStackTrace();
        CheckpointPhase.getPhase().addMultiThreadedHook(new CheckpointHook(){
            static final long serialVersionUID = 3265955500721303662L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void prepare() {
                LibertyCheckpoint.sneakyThrow(fail);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.crac.LibertyCheckpoint$2", 2.class, (String)"checkpoint", (String)"io.openliberty.crac.resources.CRaCMessages");
            }
        });
        LibertyCheckpoint.sneakyThrow(fail);
    }

    private static void registerHookService() {
        if (registerHookService.compareAndSet(false, true)) {
            Bundle b = FrameworkUtil.getBundle(LibertyCheckpoint.class);
            if (b == null) {
                throw new IllegalStateException("No bundle for LibertyCheckpoint class.");
            }
            BundleContext bc = AccessController.doPrivileged(() -> b.getBundleContext());
            if (bc == null) {
                throw new IllegalStateException("No bundle context for LibertyCheckpoint class.");
            }
            Hashtable<String, Constable> serviceProps = new Hashtable<String, Constable>();
            serviceProps.put("service.ranking", Integer.valueOf(Integer.MAX_VALUE));
            serviceProps.put("io.openliberty.checkpoint.hook.multi.threaded", Boolean.TRUE);
            serviceProps.put("io.openliberty.crac.hooks", Boolean.TRUE);
            bc.registerService(CheckpointHook.class, (Object)new LibertyCheckpoint(), serviceProps);
        }
    }

    @Trivial
    static void debug(TraceComponent trace, Supplier<String> message) {
        if (TraceComponent.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            Tr.debug((TraceComponent)trace, (String)message.get(), (Object[])new Object[0]);
        }
    }

    @Trivial
    static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

