/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server.wls;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.platform.server.ServerPlatformDetector;

public class WebLogicPlatformDetector
implements ServerPlatformDetector {
    @Override
    public String checkPlatform() {
        String platform = null;
        String serverNameAndVersion = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return WebLogicPlatformDetector.this.getServerNameAndVersionInternal();
            }
        }) : this.getServerNameAndVersionInternal();
        if (serverNameAndVersion != null) {
            int idx = serverNameAndVersion.indexOf(46);
            try {
                int version = Integer.parseInt(serverNameAndVersion.substring(0, idx));
                if (version >= 12) {
                    platform = "WebLogic_12";
                } else {
                    platform = switch (version) {
                        case 10, 11 -> "WebLogic_10";
                        case 9 -> "WebLogic_9";
                        default -> "WebLogic";
                    };
                }
            }
            catch (NumberFormatException nfe) {
                platform = "WebLogic";
            }
        }
        return platform;
    }

    private String getServerNameAndVersionInternal() {
        try {
            Class<?> versionCls = Class.forName("weblogic.version");
            Method method = versionCls.getMethod("getReleaseBuildVersion", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

