/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.ws.sip.parser.DatagramMessageParser;
import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.udp.SIPListenningConnectionImpl;
import com.ibm.ws.sip.stack.transport.sip.netty.BaseConnection;
import com.ibm.ws.sip.stack.transport.sip.netty.UdpSender;
import io.netty.channel.Channel;
import java.io.IOException;

public class SipUdpConnection
extends BaseConnection {
    private UdpSender m_connLink;
    private Channel m_channel;

    public SipUdpConnection(SIPListenningConnection lc, UdpSender connLink, Channel channel) {
        this(null, 0, lc, connLink, channel);
    }

    public SipUdpConnection(String peerHost, int peerPort, SIPListenningConnection lc, UdpSender connLink, Channel channel) {
        super(peerHost, peerPort, lc);
        this.m_connLink = connLink;
        this.m_channel = channel;
    }

    @Override
    public void write(MessageContext messageSendingContext, boolean considerMtu, UseCompactHeaders useCompactHeaders) throws IOException {
        this.prepareBuffer(messageSendingContext, considerMtu, useCompactHeaders);
        this.m_connLink.send(messageSendingContext, useCompactHeaders);
    }

    public Channel getChannel() {
        return this.m_channel;
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public String getTransport() {
        return "UDP";
    }

    @Override
    public boolean isReliable() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public int getPathMTU() {
        return SIPListenningConnectionImpl.getPathMTU();
    }

    @Override
    public MessageParser getMessageParser() {
        return DatagramMessageParser.getGlobalInstance();
    }
}

