/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.logout;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import io.openliberty.security.oidcclientcore.authentication.JakartaOidcAuthorizationRequest;
import io.openliberty.security.oidcclientcore.client.LogoutConfig;
import io.openliberty.security.oidcclientcore.client.OidcClientConfig;
import io.openliberty.security.oidcclientcore.config.MetadataUtils;
import io.openliberty.security.oidcclientcore.exceptions.OidcClientConfigurationException;
import io.openliberty.security.oidcclientcore.exceptions.OidcDiscoveryException;
import io.openliberty.security.oidcclientcore.logout.CustomLogoutStrategy;
import io.openliberty.security.oidcclientcore.logout.LocalLogoutStrategy;
import io.openliberty.security.oidcclientcore.logout.RPInitiatedLogoutStrategy;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LogoutHandler {
    public static final TraceComponent tc = Tr.register(LogoutHandler.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    HttpServletRequest req;
    HttpServletResponse resp;
    OidcClientConfig oidcClientConfig;
    LogoutConfig logoutConfig;
    private String idTokenString = null;
    ProviderAuthenticationResult authResult = new ProviderAuthenticationResult(AuthResult.SUCCESS, 200);
    static final long serialVersionUID = 2662603525567876476L;

    public LogoutHandler(HttpServletRequest req, HttpServletResponse resp, OidcClientConfig oidcClientConfig, LogoutConfig logoutConfig, String idTokenString) {
        this.req = req;
        this.resp = resp;
        this.oidcClientConfig = oidcClientConfig;
        this.logoutConfig = logoutConfig;
        this.idTokenString = idTokenString;
    }

    public ProviderAuthenticationResult logout() throws ServletException {
        LocalLogoutStrategy localLogout = new LocalLogoutStrategy(this.req);
        localLogout.logout();
        return this.logoutWithoutLocalLogout();
    }

    @FFDCIgnore(value={OidcClientConfigurationException.class})
    public ProviderAuthenticationResult logoutWithoutLocalLogout() throws ServletException {
        String endSessionEndPoint;
        block5: {
            endSessionEndPoint = null;
            try {
                endSessionEndPoint = MetadataUtils.getEndSessionEndpoint(this.oidcClientConfig);
            }
            catch (OidcClientConfigurationException | OidcDiscoveryException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"The {0} OpenID Connect client failed to find a configured end session endpoint. {1}", (Object[])new Object[]{this.oidcClientConfig.getClientId(), e.toString()});
            }
        }
        String redirectUrl = this.logoutConfig.getRedirectURI();
        if (this.logoutConfig.isNotifyProvider() && endSessionEndPoint != null) {
            RPInitiatedLogoutStrategy rpInitiatedLogoutStrategy = new RPInitiatedLogoutStrategy(this.oidcClientConfig, endSessionEndPoint, this.idTokenString);
            return rpInitiatedLogoutStrategy.logout();
        }
        if (!this.logoutConfig.isNotifyProvider() && redirectUrl != null && !redirectUrl.isEmpty()) {
            CustomLogoutStrategy customLogoutStrategy = new CustomLogoutStrategy(redirectUrl);
            return customLogoutStrategy.logout();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Redirect to the OpenID Connect Provider Authentication endpoint for re-authentication", (Object[])new Object[0]);
        }
        JakartaOidcAuthorizationRequest oidcAuthorizationRequest = new JakartaOidcAuthorizationRequest(this.req, this.resp, this.oidcClientConfig);
        return oidcAuthorizationRequest.sendRequest();
    }
}

