/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.source.utils.AuditUtils;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.WebRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JACCWebAuthorizationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(JACCWebAuthorizationEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = 3758026828908267994L;

    public JACCWebAuthorizationEvent() {
        this.set("eventName", "SECURITY_AUTHZ");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public JACCWebAuthorizationEvent(WebRequest webreq, AuthenticationResult authResult, String uriName, String containerType, Integer statusCode) {
        block15: {
            this();
            try {
                String agent;
                HttpServletRequest req = webreq.getHttpServletRequest();
                if (req != null && req.getRemoteAddr() != null) {
                    this.set("initiator.host.address", req.getRemoteAddr());
                }
                if ((agent = req.getHeader("User-Agent")) != null) {
                    this.set("initiator.host.agent", agent);
                }
                this.set("target.name", URLDecoder.decode(req.getRequestURI(), "UTF-8"));
                this.set("target.appname", AuditUtils.getJ2EEComponentName());
                if (req.getQueryString() != null) {
                    String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                    str = AuditUtils.hidePassword(str);
                    this.set("target.params", str);
                }
                this.set("target.host.address", req.getLocalAddr() + ":" + req.getLocalPort());
                this.set("target.credential.type", authResult.getAuditCredType());
                if (authResult.getAuditCredValue() != null) {
                    this.set("target.credential.token", authResult.getAuditCredValue());
                } else if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                    this.set("target.credential.token", req.getUserPrincipal().getName());
                }
                this.set("target.method", AuditUtils.getRequestMethod(req));
                String sessionID = AuditUtils.getSessionID(req);
                if (sessionID != null) {
                    this.set("target.session", sessionID);
                }
                this.set("target.realm", AuditUtils.getRealmName());
                if (req.getMethod() != null) {
                    this.set("target.jacc.permissions", req.getMethod());
                }
                this.set("target.jacc.container", "web");
                if (webreq.getRequiredRoles() != null) {
                    ArrayList<String> rolesList = new ArrayList<String>();
                    for (String role : webreq.getRequiredRoles()) {
                        rolesList.add(role);
                    }
                    if (!rolesList.isEmpty()) {
                        this.set("target.role.names", rolesList.toString());
                    }
                }
                if (statusCode == 200) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", statusCode);
                    this.set("reason.reasonType", AuditUtils.getRequestScheme(req));
                }
            }
            catch (Exception req) {
                void e;
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.security.audit.event.JACCWebAuthorizationEvent", (String)"106", (Object)((Object)this), (Object[])new Object[]{webreq, authResult, uriName, containerType, statusCode});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating JACCWebAuthorizationEvent", (Object[])new Object[]{e});
            }
        }
    }
}

