/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.twitter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Calendar;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Utils {
    private static TraceComponent tc = Tr.register(Utils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final int NONCE_LENGTH = 40;
    static final long serialVersionUID = -4372870566858848081L;

    public static String generateNonce() {
        return Utils.generateNonce(40);
    }

    public static String generateNonce(int length) {
        if (length < 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Negative length provided. Will default to nonce of length 40", (Object[])new Object[0]);
            }
            length = 40;
        }
        StringBuilder randomString = new StringBuilder();
        SecureRandom r = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            int index = r.nextInt(chars.length);
            randomString.append(chars[index]);
        }
        return randomString.toString();
    }

    public static String getCurrentTimestamp() {
        long timeMs = Calendar.getInstance().getTimeInMillis();
        String timestamp = Long.valueOf(timeMs / 1000L).toString();
        return timestamp;
    }

    public static String percentEncode(String value) {
        if (value == null) {
            return "";
        }
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.social.twitter.Utils", (String)"88", null, (Object[])new Object[]{value});
        }
        StringBuilder buf = new StringBuilder(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            if (c == '+') {
                buf.append("%20");
                continue;
            }
            if (c == '*') {
                buf.append("%2A");
                continue;
            }
            if (c == '%' && i + 2 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @Sensitive
    public static String percentEncodeSensitive(@Sensitive String value) {
        if (value == null) {
            return "";
        }
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.social.twitter.Utils", (String)"125", null, (Object[])objectArray);
        }
        StringBuilder buf = new StringBuilder(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char c = encoded.charAt(i);
            if (c == '+') {
                buf.append("%20");
                continue;
            }
            if (c == '*') {
                buf.append("%2A");
                continue;
            }
            if (c == '%' && i + 2 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

