/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.CharsetRange;
import com.ibm.ws.security.oauth20.util.DateUtil;
import com.ibm.ws.security.oauth20.util.MediaRange;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.util.StringUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractOidcEndpointServices {
    protected static final String FORWARD_SLASH = "/";
    protected static final String BACKWARDS_SLASH = "\\";
    protected static final String COLON = ":";
    protected static final String COLON_SLASH_SLASH = "://";
    protected static final String UTF_8 = "UTF-8";
    private static final char AMPERSAND = '&';
    private static final char EQUALS = '=';
    private static final String EMPTY_STRING = "";
    private static final String URL_ENCODED_SPACE = "%20";
    public static final String CT = "Content-Type";
    public static final String CT_APPLICATION_JSON = "application/json";
    public static final String CT_APPLICATION_JSON_AND_UTF8 = "application/json;charset=UTF-8";
    protected static final String CT_WILDCARD = "*/*";
    private static final String HDR_IF_MATCH = "If-Match";
    private static final String HDR_IF_NONE_MATCH = "If-None-Match";
    private static final String HDR_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HDR_IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String HDR_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HDR_ACCEPT = "Accept";
    private static final String HDR_ACCEPT_CHARSET = "Accept-Charset";
    protected static final String HDR_ETAG = "ETag";
    protected static final String HDR_VALUE_PUBLIC = "public";
    protected static final String HDR_VALUE_PRIVATE = "private";
    private static final String HDR_VALUE_MAX_AGE = "max-age";
    protected static final int HTTP_DEFAULT_PORT = 80;
    protected static final int HTTP_DEFAULT_SECURE_PORT = 443;
    protected static final String HTTP_METHOD_GET = "GET";
    protected static final String HTTP_METHOD_HEAD = "HEAD";
    protected static final String HTTP_METHOD_POST = "POST";
    protected static final String HTTP_METHOD_PUT = "PUT";
    protected static final String HTTP_METHOD_DELETE = "DELETE";
    protected static final String ALG_MD5 = "MD5";
    protected static final String ALG_SHA256 = "SHA-256";
    private static TraceComponent tc = Tr.register(AbstractOidcEndpointServices.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    static final long serialVersionUID = 6109261006288689022L;

    protected static Map<String, String[]> parseQueryParameters(String query) {
        return AbstractOidcEndpointServices.parseQueryParameters(query, false);
    }

    protected static Map<String, String[]> parseQueryParameters(String query, boolean decode) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Query String is " + query), (Object[])new Object[0]);
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        if (query == null || query.length() == 0) {
            return new HashMap<String, String[]>();
        }
        if (query.charAt(0) != '&') {
            query = '&' + query;
        }
        int mainNdx = 0;
        while (mainNdx < query.length()) {
            int startNdx;
            int endNdx;
            String parm = EMPTY_STRING;
            if ((endNdx = query.indexOf(38, startNdx = ++mainNdx)) == -1) {
                parm = query.substring(startNdx);
                mainNdx = query.length();
            } else {
                parm = query.substring(startNdx, endNdx);
                mainNdx = endNdx;
            }
            AbstractOidcEndpointServices.loadParmInMap(parm, map, decode);
        }
        HashMap<String, String[]> newMap = new HashMap<String, String[]>(map.size());
        for (String key : map.keySet()) {
            ArrayList list = (ArrayList)map.get(key);
            String[] strings = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                strings[i] = (String)list.get(i);
            }
            newMap.put(key, strings);
        }
        return newMap;
    }

    private static void loadParmInMap(String parm, HashMap<String, ArrayList<String>> map, boolean decode) {
        ArrayList<String> mapValue;
        int equals = parm.indexOf(61);
        String key = null;
        String value = EMPTY_STRING;
        if (equals == -1) {
            key = parm;
        } else if (equals == parm.length() - 1) {
            key = parm.substring(0, equals);
        } else {
            key = parm.substring(0, equals);
            value = parm.substring(equals + 1);
        }
        if (decode) {
            key = AbstractOidcEndpointServices.decode(key);
            value = AbstractOidcEndpointServices.decode(value);
        }
        if ((mapValue = map.get(key)) == null) {
            mapValue = new ArrayList();
            map.put(key, mapValue);
        }
        mapValue.add(value);
    }

    /*
     * WARNING - void declaration
     */
    protected static String decode(String str) {
        if (str == null) {
            throw new IllegalArgumentException("str must not be null");
        }
        str = str.replace(URL_ENCODED_SPACE, "+");
        try {
            return URLDecoder.decode(str, UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.web.AbstractOidcEndpointServices", (String)"252", null, (Object[])new Object[]{str});
            String msg = String.format("An encoding error occurred during the %s encoding of string \"%s\". The exception message is \"%s\".", UTF_8, str, e.getMessage());
            throw new RuntimeException(msg, (Throwable)e);
        }
    }

    protected static String constructCacheControlHeaderWithMaxAge(boolean isPublic, String maxAge) {
        String type = isPublic ? HDR_VALUE_PUBLIC : HDR_VALUE_PRIVATE;
        String headerValue = String.format("%s, %s=%s", type, HDR_VALUE_MAX_AGE, maxAge);
        return headerValue;
    }

    protected static String generateUUID() {
        return UUID.randomUUID().toString().replace("-", EMPTY_STRING);
    }

    public static JsonArray getSlashTerminated(JsonArray values) {
        JsonArray slashValues = new JsonArray();
        if (values != null && values.size() > 0) {
            for (JsonElement uriEle : values) {
                String uriString = uriEle.getAsString();
                slashValues.add((JsonElement)new JsonPrimitive(AbstractOidcEndpointServices.addTrailingSlash(uriString)));
            }
        }
        return slashValues;
    }

    public static String addTrailingSlash(String uri) {
        if ((uri = AbstractOidcEndpointServices.trimTrailingSlash(uri)) == null) {
            return uri;
        }
        return uri + FORWARD_SLASH;
    }

    protected static String addLeadingSlash(String uri) {
        if ((uri = AbstractOidcEndpointServices.trimLeadingSlash(uri)) == null) {
            return uri;
        }
        return FORWARD_SLASH + uri;
    }

    protected static String trimSlashes(String uri) {
        return AbstractOidcEndpointServices.trimTrailingSlash(AbstractOidcEndpointServices.trimLeadingSlash(uri));
    }

    protected static String trimLeadingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if ((uri = uri.trim()).startsWith(FORWARD_SLASH) || uri.startsWith(BACKWARDS_SLASH)) {
            if (uri.length() > 1) {
                return uri.substring(1);
            }
            uri = EMPTY_STRING;
        }
        return uri;
    }

    protected static String trimTrailingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if ((uri = uri.trim()).endsWith(FORWARD_SLASH) || uri.endsWith(BACKWARDS_SLASH)) {
            int len = uri.length();
            if (len > 1) {
                return uri.substring(0, len - 1);
            }
            uri = EMPTY_STRING;
        }
        return uri;
    }

    protected static void validateContentType(HttpServletRequest request, String contentType) throws OidcServerException {
        if (!AbstractOidcEndpointServices.isValidContentType(request, contentType)) {
            String description = String.format("The request must contain content-type of \"%s\"", contentType);
            throw new OidcServerException(description, "invalid_request", 415);
        }
    }

    private static boolean isValidContentType(HttpServletRequest request, String contentType) {
        return request.getContentType() != null && request.getContentType().startsWith(contentType);
    }

    protected static void validateJsonAcceptable(HttpServletRequest request) throws OidcServerException {
        if (!AbstractOidcEndpointServices.isMimeTypeAcceptable(request, CT_APPLICATION_JSON, null)) {
            String description = String.format("The request does not allow for a response of media type \"%s\"", CT_APPLICATION_JSON);
            throw new OidcServerException(description, "invalid_request", 406);
        }
        if (!AbstractOidcEndpointServices.isCharsetAcceptable(request, UTF_8)) {
            String description = String.format("The request does not allow for a response that not charset \"%s\"", UTF_8);
            throw new OidcServerException(description, "invalid_request", 406);
        }
    }

    private static boolean isMimeTypeAcceptable(HttpServletRequest request, String mimeType, Collection<String> parameters) {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (mimeType == null || mimeType.length() == 0) {
            throw new IllegalArgumentException("mimeType must not be null or empty");
        }
        String requestType = mimeType.trim().toLowerCase();
        String[] requestPair = StringUtil.splitAcceptPairAllowingSingleAsterisk(requestType);
        String rType = requestPair[0];
        for (MediaRange entry : AbstractOidcEndpointServices.parseAcceptContentHeaders(request)) {
            String entryType = entry.getType();
            String[] typePair = StringUtil.splitAcceptPairAllowingSingleAsterisk(entryType);
            String mType = typePair[0];
            String mSubType = typePair[1];
            if (!entryType.equals(requestType) && (!mType.equals(rType) || !mSubType.equals("*")) && !entryType.equals(CT_WILDCARD) || entry.getQValue().floatValue() == 0.0f) continue;
            if (parameters != null) {
                boolean acceptable = AbstractOidcEndpointServices.parmsInMap(parameters, entry.getParameters());
                return acceptable;
            }
            return true;
        }
        return false;
    }

    private static boolean isCharsetAcceptable(HttpServletRequest request, String charset) {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset must not be null or empty");
        }
        String requestType = charset.trim().toLowerCase();
        for (CharsetRange entry : AbstractOidcEndpointServices.parseAcceptCharsetHeaders(request)) {
            String entryType = entry.getType();
            if (!entryType.equals(requestType) && !entryType.equals("*") || entry.getQValue().floatValue() == 0.0f) continue;
            return true;
        }
        return false;
    }

    private static MediaRange[] parseAcceptContentHeaders(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        String headerVal = AbstractOidcEndpointServices.getHeaderValue(HDR_ACCEPT, request);
        return MediaRange.parse(headerVal);
    }

    private static CharsetRange[] parseAcceptCharsetHeaders(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        String headerVal = AbstractOidcEndpointServices.getHeaderValue(HDR_ACCEPT_CHARSET, request);
        return CharsetRange.parse(headerVal);
    }

    private static String getHeaderValue(String headerName, HttpServletRequest request) {
        if (headerName == null || headerName.length() == 0) {
            throw new IllegalArgumentException("headerName must not be null or empty");
        }
        if (request == null) {
            throw new IllegalArgumentException("request must not be null");
        }
        StringBuilder sb = new StringBuilder();
        Enumeration headersList = request.getHeaders(headerName);
        if (!headersList.hasMoreElements()) {
            return sb.toString();
        }
        HashSet<String> headerSet = new HashSet<String>();
        while (headersList.hasMoreElements()) {
            headerSet.add((String)headersList.nextElement());
        }
        if (headerSet.size() > 0) {
            int counter = 0;
            for (String value : headerSet) {
                sb.append(value);
                if (counter < headerSet.size() - 1) {
                    sb.append(",");
                }
                ++counter;
            }
        }
        return sb.toString();
    }

    private static boolean parmsInMap(Collection<String> parms, Map<String, String[]> parmMap) {
        if (parms == null) {
            throw new IllegalArgumentException("parms cannot be null");
        }
        if (parmMap == null) {
            throw new IllegalArgumentException("parmMap cannot be null");
        }
        for (String parm : parms) {
            String[] splitParm = StringUtil.splitPair(parm, '=');
            String parmName = splitParm[0].toLowerCase();
            String parmValue = splitParm[1].toLowerCase();
            if (!parmMap.containsKey(parmName)) {
                return false;
            }
            boolean valueFound = false;
            for (String value : parmMap.get(parmName)) {
                if (!parmValue.equals(value)) continue;
                valueFound = true;
                break;
            }
            if (valueFound) continue;
            return false;
        }
        return true;
    }

    protected static List<String> getList(JsonArray values) {
        if (OidcOAuth20Util.isNullEmpty(values)) {
            return new ArrayList<String>();
        }
        Gson converter = new Gson();
        Type type = new TypeToken<List<String>>(){
            static final long serialVersionUID = 8614990559892212720L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.web.AbstractOidcEndpointServices$1", 1.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
            }
        }.getType();
        return (List)converter.fromJson((JsonElement)values, type);
    }

    protected static OidcServerException checkConditionalExecution(HttpServletRequest request, boolean isGetOrHead, boolean exists, String eTag, Date lastModified) throws OidcServerException {
        boolean hasModifiedCondition;
        boolean hasETagCondition = !OidcOAuth20Util.isNullEmpty(request.getHeaders(HDR_IF_MATCH)) || !OidcOAuth20Util.isNullEmpty(request.getHeaders(HDR_IF_NONE_MATCH));
        boolean bl = hasModifiedCondition = !OidcOAuth20Util.isNullEmpty(request.getHeaders(HDR_IF_MODIFIED_SINCE)) || !OidcOAuth20Util.isNullEmpty(request.getHeaders(HDR_IF_UNMODIFIED_SINCE));
        if (!hasETagCondition && !hasModifiedCondition) {
            return null;
        }
        OidcServerException etagException = null;
        if (hasETagCondition && eTag != null && eTag.length() != 0) {
            etagException = AbstractOidcEndpointServices.checkETagConditions(request, isGetOrHead, exists, eTag);
            if (!hasModifiedCondition) {
                return etagException;
            }
        }
        OidcServerException lastModifiedException = null;
        if (hasModifiedCondition && lastModified != null) {
            lastModifiedException = AbstractOidcEndpointServices.checkModifiedConditions(request, lastModified);
            if (!hasETagCondition) {
                return lastModifiedException;
            }
        }
        if (etagException != null && etagException.getHttpStatus() == 304) {
            return lastModifiedException;
        }
        if (lastModifiedException != null && lastModifiedException.getHttpStatus() == 304) {
            return etagException;
        }
        if (etagException != null) {
            return etagException;
        }
        if (lastModifiedException != null) {
            return lastModifiedException;
        }
        return null;
    }

    private static OidcServerException checkETagConditions(HttpServletRequest request, boolean isGetOrHead, boolean exists, String eTag) throws OidcServerException {
        String description;
        String[] matchTokens;
        String headerName;
        boolean ifMatch = false;
        String matchValue = AbstractOidcEndpointServices.getHeaderValue(HDR_IF_MATCH, request);
        if (matchValue != null && matchValue.length() != 0) {
            ifMatch = true;
            headerName = HDR_IF_MATCH;
        } else {
            matchValue = AbstractOidcEndpointServices.getHeaderValue(HDR_IF_NONE_MATCH, request);
            headerName = HDR_IF_NONE_MATCH;
        }
        if (matchValue == null || matchValue.length() == 0) {
            return null;
        }
        boolean atLeastOneMatch = false;
        for (String token : matchTokens = matchValue.split(",")) {
            String testETag = token.trim();
            if (testETag.equals("*")) {
                if (matchTokens.length != 1) {
                    String errorMsg = "The value \"%s\" for \"%s\" header \"*\" is not valid because it must be the only token in the value.";
                    String description2 = String.format(errorMsg, matchValue, headerName);
                    throw new OidcServerException(description2, "invalid_request", 400);
                }
                if (ifMatch) {
                    String description3 = "If-Match header specified in request and it did not match.";
                    return exists ? null : new OidcServerException(description3, "invalid_request", 412);
                }
                if (exists) {
                    String description4 = "No If-Match header specified in request.";
                    return isGetOrHead ? new OidcServerException((String)null, null, 304) : new OidcServerException(description4, "invalid_request", 412);
                }
                return null;
            }
            if (testETag.charAt(0) != '\"' || testETag.charAt(testETag.length() - 1) != '\"') {
                String errorMsg = "The entity tag \"%s\" in \"%s\" header is not valid because it must be a quoted string.";
                String description5 = String.format(errorMsg, testETag, headerName);
                throw new OidcServerException(description5, "invalid_request", 400);
            }
            testETag = testETag.substring(1, testETag.length() - 1);
            if (eTag == null || !eTag.equals(testETag)) continue;
            atLeastOneMatch = true;
        }
        if (ifMatch && !atLeastOneMatch) {
            description = "If-Match header specified in request and it did not match.";
            return new OidcServerException(description, "invalid_request", 412);
        }
        if (!ifMatch && atLeastOneMatch) {
            description = "No If-Match header specified in request.";
            return isGetOrHead ? new OidcServerException((String)null, null, 304) : new OidcServerException(description, "invalid_request", 412);
        }
        return null;
    }

    private static OidcServerException checkModifiedConditions(HttpServletRequest request, Date lastModified) throws OidcServerException {
        boolean ifModified = false;
        String matchValue = AbstractOidcEndpointServices.getHeaderValue(HDR_IF_MODIFIED_SINCE, request);
        if (matchValue != null && matchValue.length() != 0) {
            ifModified = true;
        } else {
            matchValue = AbstractOidcEndpointServices.getHeaderValue(HDR_IF_UNMODIFIED_SINCE, request);
        }
        if (matchValue == null || matchValue.length() == 0) {
            return null;
        }
        Timestamp matchTime = DateUtil.parseTimeRFC2616(matchValue);
        if (matchTime == null) {
            return null;
        }
        if (ifModified && !lastModified.after(matchTime)) {
            return new OidcServerException((String)null, null, 304);
        }
        if (!ifModified && lastModified.after(matchTime)) {
            String description = "Resource modified.";
            return new OidcServerException(description, "invalid_request", 412);
        }
        return null;
    }
}

