/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import jakarta.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.Prototype;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Prototype
public abstract class AbstractMessageHandler<MessageType>
extends AbstractInitializableComponent
implements MessageHandler<MessageType> {
    private Logger log = LoggerFactory.getLogger(AbstractMessageHandler.class);
    @Nonnull
    private Predicate<MessageContext> activationCondition = Predicates.alwaysTrue();

    @Nonnull
    public Predicate<MessageContext> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nonnull Predicate<MessageContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null");
    }

    @Override
    public void invoke(@Nonnull MessageContext<MessageType> messageContext) throws MessageHandlerException {
        Constraint.isNotNull(messageContext, (String)"Message context cannot be null");
        if (this.doPreInvoke(messageContext)) {
            try {
                this.doInvoke(messageContext);
            }
            catch (MessageHandlerException e) {
                try {
                    this.doPostInvoke(messageContext, e);
                }
                catch (Throwable t) {
                    this.log.warn("{} Unchecked exception/error thrown by doPostInvoke, superseding a MessageHandlerException ", (Object)this.getLogPrefix(), (Object)e);
                    t.addSuppressed(e);
                    throw t;
                }
                throw e;
            }
            catch (Throwable t) {
                try {
                    this.doPostInvoke(messageContext);
                }
                catch (Throwable t2) {
                    this.log.warn("{} Unchecked exception/error thrown by doPostInvoke, superseding an unchecked exception/error ", (Object)this.getLogPrefix(), (Object)t);
                    t2.addSuppressed(t);
                    throw t2;
                }
                throw t;
            }
            this.doPostInvoke(messageContext);
        }
    }

    protected boolean doPreInvoke(@Nonnull MessageContext<MessageType> messageContext) throws MessageHandlerException {
        if (this.activationCondition.apply(messageContext)) {
            this.log.debug("{} Activation condition for handler returned true", (Object)this.getLogPrefix());
            return true;
        }
        this.log.debug("{} Activation condition for handler returned false", (Object)this.getLogPrefix());
        return false;
    }

    protected abstract void doInvoke(@Nonnull MessageContext<MessageType> var1) throws MessageHandlerException;

    protected void doPostInvoke(@Nonnull MessageContext<MessageType> messageContext) {
    }

    protected void doPostInvoke(@Nonnull MessageContext<MessageType> messageContext, @Nonnull Exception e) {
        this.doPostInvoke(messageContext);
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        return "Message Handler: ";
    }
}

