/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator;
import com.ibm.ws.wssecurity.cxf.validator.Utils;
import com.ibm.ws.wssecurity.cxf.validator.WssSamlAssertionValidator;
import com.ibm.ws.wssecurity.signature.SignatureAlgorithms;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import io.openliberty.wssecurity.WSSecurityFeatureHelper;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.security.cache.CXFEHCacheReplayCache;
import org.apache.cxf.ws.security.tokenstore.EHCacheTokenStore;
import org.apache.cxf.ws.security.tokenstore.MemoryTokenStoreFactory;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreFactory;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.apache.wss4j.common.cache.MemoryReplayCache;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.cache.WSS4JCacheUtil;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSSecurityLibertyPluginInterceptor
extends AbstractSoapInterceptor {
    private static final Map<String, Object> providerConfigMap = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Object> clientConfigMap = Collections.synchronizedMap(new HashMap());
    private static final TraceComponent tc = Tr.register(WSSecurityLibertyPluginInterceptor.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    private static final String SIGNATURE_METHOD = "signatureAlgorithm";
    private static Map<String, Object> samlTokenConfigMap = null;
    private static boolean signatureConfigChanged = false;
    private static boolean clientSignatureConfigChanged = false;
    static final long serialVersionUID = -5524650242869391722L;

    public WSSecurityLibertyPluginInterceptor() {
        super("pre-protocol");
        this.addBefore(PolicyBasedWSS4JInInterceptor.class.getName());
        this.addBefore(PolicyBasedWSS4JOutInterceptor.class.getName());
    }

    public static void setBindingsConfiguration(Map<String, Object> map) {
        signatureConfigChanged = true;
        if (map != null) {
            if (!providerConfigMap.isEmpty()) {
                providerConfigMap.clear();
            }
            providerConfigMap.putAll(map);
        } else {
            providerConfigMap.clear();
        }
    }

    public static void setClientBindingsConfiguration(Map<String, Object> map) {
        clientSignatureConfigChanged = true;
        if (map != null) {
            if (!clientConfigMap.isEmpty()) {
                clientConfigMap.clear();
            }
            clientConfigMap.putAll(map);
        } else {
            clientConfigMap.clear();
        }
    }

    public static void setSamlTokenConfiguration(Map<String, Object> tmpSamlTokenConfigMap) {
        samlTokenConfigMap = tmpSamlTokenConfigMap;
    }

    public void handleMessage(@Sensitive SoapMessage message) throws Fault {
        if (message == null) {
            return;
        }
        boolean isReq = MessageUtils.isRequestor((Message)message);
        if (isReq) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"client side message = ", (Object[])new Object[]{message});
            }
            Set<String> client_config_keys = clientConfigMap.keySet();
            Iterator<String> keyIt = client_config_keys.iterator();
            boolean user_id_exists = false;
            if (message.getContextualProperty("ws-security.username") != null || message.getContextualProperty("security.username") != null) {
                user_id_exists = true;
            }
            while (keyIt.hasNext()) {
                String samlCallbackHandler;
                String key = keyIt.next();
                if (message.getContextualProperty(key) == null) {
                    Map tempMap;
                    if (("ws-security.signature.properties".equals(key) || "security.signature.properties".equals(key)) && message.getContextualProperty("security.signature.properties") == null) {
                        tempMap = (Map)clientConfigMap.get("security.signature.properties");
                        if (tempMap == null) {
                            tempMap = (Map)clientConfigMap.get("ws-security.signature.properties");
                        }
                        if (tempMap != null) {
                            HashMap<String, Object> sigPropsMap = new HashMap<String, Object>(tempMap);
                            Utils.modifyConfigMap(sigPropsMap);
                            Properties sigProps = new Properties();
                            sigProps.putAll((Map<?, ?>)sigPropsMap);
                            message.setContextualProperty(key, (Object)sigProps);
                            if (clientSignatureConfigChanged) {
                                message.setContextualProperty("security.signature.crypto", null);
                                clientSignatureConfigChanged = false;
                            }
                            message.setContextualProperty("security.signature.crypto", null);
                            SignatureAlgorithms.setAlgorithm(message, (String)tempMap.get(SIGNATURE_METHOD));
                        }
                    } else if (("ws-security.encryption.properties".equals(key) || "security.encryption.properties".equals(key)) && message.getContextualProperty("security.encryption.properties") == null) {
                        tempMap = (Map)clientConfigMap.get("security.encryption.properties");
                        if (tempMap == null) {
                            tempMap = (Map)clientConfigMap.get("ws-security.encryption.properties");
                        }
                        if (tempMap != null) {
                            HashMap<String, Object> encPropsMap = new HashMap<String, Object>(tempMap);
                            Utils.modifyConfigMap(encPropsMap);
                            Properties encProps = new Properties();
                            encProps.putAll((Map<?, ?>)encPropsMap);
                            message.setContextualProperty(key, (Object)encProps);
                        }
                    } else if ("ws-security.password".equals(key) || "security.password".equals(key)) {
                        if (!user_id_exists) {
                            String pwd = null;
                            if (clientConfigMap.get("security.password") != null) {
                                pwd = Utils.changePasswordType((SerializableProtectedString)clientConfigMap.get("security.password"));
                            } else if (clientConfigMap.get("ws-security.password") != null) {
                                pwd = Utils.changePasswordType((SerializableProtectedString)clientConfigMap.get("ws-security.password"));
                            }
                            message.setContextualProperty(key, (Object)pwd);
                        }
                    } else {
                        message.setContextualProperty(key, clientConfigMap.get(key));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Client Config attribute is set on message = ", (Object[])new Object[]{key, ", value = ", clientConfigMap.get(key)});
                    }
                }
                if ((samlCallbackHandler = (String)message.getContextualProperty("ws-security.saml-callback-handler")) != null && !samlCallbackHandler.isEmpty()) continue;
                message.setContextualProperty("ws-security.saml-callback-handler", (Object)"com.ibm.ws.wssecurity.callback.Saml20PropagationCallbackHandler");
            }
        } else {
            Object validator;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"provider side message = ", (Object[])new Object[]{message});
            }
            if ((validator = message.getContextualProperty("ws-security.ut.validator")) == null) {
                message.put((Object)"ws-security.ut.validator", (Object)new UsernameTokenValidator());
            }
            if ((validator = message.getContextualProperty("ws-security.saml2.validator")) == null) {
                String[] restrictions;
                message.put((Object)"ws-security.saml2.validator", (Object)new WssSamlAssertionValidator(samlTokenConfigMap));
                if (samlTokenConfigMap != null && ((restrictions = (String[])samlTokenConfigMap.get("audienceRestrictions")) == null || restrictions.length < 1)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"set audience restriction validation to false", (Object[])new Object[0]);
                    }
                    message.put((Object)"security.validate.audience-restriction", (Object)false);
                }
            }
            Set<String> provider_config_keys = providerConfigMap.keySet();
            for (String key : provider_config_keys) {
                Map tempMap;
                if (("ws-security.signature.properties".equals(key) || "security.signature.properties".equals(key)) && message.getContextualProperty("security.signature.properties") == null) {
                    tempMap = (Map)providerConfigMap.get("security.signature.properties");
                    if (tempMap == null) {
                        tempMap = (Map)providerConfigMap.get("ws-security.signature.properties");
                    }
                    if (tempMap != null) {
                        HashMap<String, Object> sigPropsMap = new HashMap<String, Object>(tempMap);
                        Utils.modifyConfigMap(sigPropsMap);
                        Properties sigProps = new Properties();
                        sigProps.putAll((Map<?, ?>)sigPropsMap);
                        message.setContextualProperty(key, (Object)sigProps);
                        if (signatureConfigChanged) {
                            message.setContextualProperty("security.signature.crypto", null);
                            signatureConfigChanged = false;
                        }
                        message.setContextualProperty("security.signature.crypto", null);
                        SignatureAlgorithms.setAlgorithm(message, (String)tempMap.get(SIGNATURE_METHOD));
                    }
                } else if (("ws-security.encryption.properties".equals(key) || "security.encryption.properties".equals(key)) && message.getContextualProperty("security.encryption.properties") == null) {
                    tempMap = (Map)providerConfigMap.get("security.encryption.properties");
                    if (tempMap == null) {
                        tempMap = (Map)providerConfigMap.get("ws-security.encryption.properties");
                    }
                    if (tempMap != null) {
                        HashMap<String, Object> encPropsMap = new HashMap<String, Object>(tempMap);
                        Utils.modifyConfigMap(encPropsMap);
                        Properties encProps = new Properties();
                        encProps.putAll((Map<?, ?>)encPropsMap);
                        message.setContextualProperty(key, (Object)encProps);
                    }
                } else if ("ws-security.cache.config.file".equals(key)) {
                    this.handleehcacheconfigfile(providerConfigMap, message);
                } else {
                    message.setContextualProperty(key, providerConfigMap.get(key));
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Provider Config attribute is set on message = ", (Object[])new Object[]{key, ", value = ", providerConfigMap.get(key)});
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    private void handleehcacheconfigfile(Map<String, Object> providerconfigmap2, @Sensitive SoapMessage message) {
        boolean ncache = false;
        boolean tcache = false;
        boolean scache = false;
        URL configfile = null;
        WSSecurityFeatureHelper helper = new WSSecurityFeatureHelper();
        if (!helper.isWSSecurityFeatureHelperServiceActive()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Ignoring cache file configuration property, this is not supported : ", (Object[])new Object[]{"ws-security.cache.config.file"});
            }
            return;
        }
        try {
            ncache = this.isWSS4JCacheEnabled("ws-security.enable.nonce.cache", message);
            tcache = this.isWSS4JCacheEnabled("ws-security.enable.timestamp.cache", message);
            scache = this.isWSS4JCacheEnabled("ws-security.enable.saml.cache", message);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"are caches enabled? (nonce, timestamp, saml one time use) : ", (Object[])new Object[]{ncache, tcache, scache});
                Tr.debug((TraceComponent)tc, (String)"setting up cache config file property on the message : ", (Object[])new Object[]{"ws-security.cache.config.file"});
                Tr.debug((TraceComponent)tc, (String)"cache config file : ", (Object[])new Object[]{providerconfigmap2.get("ws-security.cache.config.file")});
            }
            message.setContextualProperty("ws-security.cache.config.file", providerconfigmap2.get("ws-security.cache.config.file"));
            configfile = SecurityUtils.getConfigFileURL((Message)message, (String)"ws-security.cache.config.file", null);
            if (configfile != null) {
                if (ncache && !this.ehcacheinstanceavailable("ws-security.nonce.cache.instance", message)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"try creating nonce cache using oldconfig ", (Object[])new Object[0]);
                    }
                    helper.handleEhcache2Mapping("ws-security.nonce.cache.instance", configfile, message);
                    this.createwss4jcacheinstance("ws-security.nonce.cache.instance", message);
                }
                if (tcache && !this.ehcacheinstanceavailable("ws-security.timestamp.cache.instance", message)) {
                    helper.handleEhcache2Mapping("ws-security.timestamp.cache.instance", configfile, message);
                    this.createwss4jcacheinstance("ws-security.timestamp.cache.instance", message);
                }
                if (scache && !this.ehcacheinstanceavailable("ws-security.saml.cache.instance", message)) {
                    helper.handleEhcache2Mapping("ws-security.saml.cache.instance", configfile, message);
                    this.createwss4jcacheinstance("ws-security.saml.cache.instance", message);
                }
                if (!this.ehcacheinstanceavailable("org.apache.cxf.ws.security.tokenstore.TokenStore", message)) {
                    StringBuilder cacheKey = new StringBuilder("org.apache.cxf.ws.security.tokenstore.TokenStore");
                    String cacheIdentifier = (String)providerconfigmap2.get("ws-security.cache.identifier");
                    if (cacheIdentifier != null) {
                        cacheKey.append('-').append(cacheIdentifier);
                    }
                    helper.handleEhcache2Mapping(cacheKey.toString(), configfile, message);
                    this.createtokenstorecacheinstance(cacheKey.toString(), message);
                }
            }
        }
        catch (Exception e) {
            message.setContextualProperty("ws-security.cache.config.file", providerconfigmap2.get("ws-security.cache.config.file"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createtokenstorecacheinstance(String cacheKey, @Sensitive SoapMessage message) throws Exception {
        String key = "liberty:".concat(cacheKey);
        if (message.getContextualProperty(key) != null) {
            EndpointInfo info;
            HashMap oldconfig = (HashMap)message.getContextualProperty(key);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getting the old config from the message, key =  " + key + ", disk store path = " + (String)oldconfig.get("getDiskStorePath") + ", ttl = " + (Long)oldconfig.get("getTimeToLiveSeconds") + ", tti = " + (Long)oldconfig.get("getTimeToIdleSeconds")), (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getting the old config from the message, heap =  " + (Long)oldconfig.get("getMaxEntriesLocalHeap") + ", disk elements = " + (Integer)oldconfig.get("getMaxElementsOnDisk") + ", disk bytes? = " + (Long)oldconfig.get("getMaxBytesLocalDisk") + ", overflow to disk = " + oldconfig.get("isOverflowToDisk")), (Object[])new Object[0]);
            }
            EndpointInfo endpointInfo = info = message.getExchange().getEndpoint().getEndpointInfo();
            synchronized (endpointInfo) {
                TokenStore tokenStore = (TokenStore)message.getContextualProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
                if (tokenStore == null) {
                    tokenStore = (TokenStore)info.getProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
                }
                if (tokenStore == null) {
                    StringBuilder cachekey2 = new StringBuilder(cacheKey);
                    if (info.getName() != null) {
                        int hashcode = info.getName().toString().hashCode();
                        if (hashcode >= 0) {
                            cachekey2.append('-');
                        }
                        cachekey2.append(hashcode);
                    }
                    if (TokenStoreFactory.isEhCacheInstalled()) {
                        Bus bus = message.getExchange().getBus();
                        tokenStore = new EHCacheTokenStore(cachekey2.toString(), bus, oldconfig);
                    } else {
                        tokenStore = new MemoryTokenStoreFactory().newTokenStore(cachekey2.toString(), (Message)message);
                    }
                    info.setProperty("org.apache.cxf.ws.security.tokenstore.TokenStore", (Object)tokenStore);
                }
            }
            message.remove((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createwss4jcacheinstance(String instanceKey, @Sensitive SoapMessage message) throws Exception {
        String key = "liberty:".concat(instanceKey);
        if (message.getContextualProperty(key) != null) {
            Object cacheManager = null;
            Object cache = null;
            HashMap oldconfig = (HashMap)message.getContextualProperty(key);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getting the old config from the message, key =  " + key + ", disk store path = " + (String)oldconfig.get("getDiskStorePath") + ", ttl = " + (Long)oldconfig.get("getTimeToLiveSeconds") + ", tti = " + (Long)oldconfig.get("getTimeToIdleSeconds")), (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getting the old config from the message, heap =  " + (Long)oldconfig.get("getMaxEntriesLocalHeap") + ", disk elements = " + (Integer)oldconfig.get("getMaxElementsOnDisk") + ", disk bytes? = " + (Long)oldconfig.get("getMaxBytesLocalDisk") + ", overflow to disk = " + oldconfig.get("isOverflowToDisk")), (Object[])new Object[0]);
            }
            ReplayCache replayCache = (ReplayCache)message.getContextualProperty(instanceKey);
            Endpoint ep = message.getExchange().getEndpoint();
            if (replayCache == null && ep != null && ep.getEndpointInfo() != null) {
                EndpointInfo info;
                EndpointInfo endpointInfo = info = ep.getEndpointInfo();
                synchronized (endpointInfo) {
                    replayCache = (ReplayCache)info.getProperty(instanceKey);
                    if (replayCache == null) {
                        String cacheKey = instanceKey;
                        if (info.getName() != null) {
                            int hashcode = info.getName().toString().hashCode();
                            cacheKey = hashcode < 0 ? cacheKey + hashcode : cacheKey + "-" + hashcode;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"creating new cache using oldconfig, cache key =  ", (Object[])new Object[]{cacheKey});
                        }
                        if (WSS4JCacheUtil.isEhCacheInstalled()) {
                            Bus bus = message.getExchange().getBus();
                            Path diskstorePath = null;
                            String path = (String)oldconfig.get("getDiskStorePath");
                            diskstorePath = Paths.get(path, new String[0]);
                            replayCache = new CXFEHCacheReplayCache(cacheKey, bus, diskstorePath, oldconfig);
                        } else {
                            replayCache = new MemoryReplayCache();
                        }
                        info.setProperty(instanceKey, (Object)replayCache);
                    }
                }
            }
            message.remove((Object)key);
        }
    }

    private boolean isWSS4JCacheEnabled(String enablekey, @Sensitive SoapMessage message) {
        boolean specified = false;
        Object o = message.getContextualProperty(enablekey);
        if (o != null) {
            if (!PropertyUtils.isTrue((Object)o)) {
                return false;
            }
            specified = true;
        }
        return specified || !MessageUtils.isRequestor((Message)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ehcacheinstanceavailable(String cachekey, @Sensitive SoapMessage message) {
        if (message.getContextualProperty(cachekey) != null) {
            return true;
        }
        Endpoint ep = message.getExchange().getEndpoint();
        if (ep != null && ep.getEndpointInfo() != null) {
            EndpointInfo info;
            EndpointInfo endpointInfo = info = ep.getEndpointInfo();
            synchronized (endpointInfo) {
                if (info.getProperty(cachekey) != null) {
                    return true;
                }
            }
        }
        return false;
    }
}

