/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.util.GsonStrategies;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import io.openliberty.security.common.serialization.Beta;
import java.util.Arrays;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class OIDCAbstractDiscoveryModel {
    public static final Gson GSON;
    private String issuer;
    private String authorization_endpoint;
    private String token_endpoint;
    private String jwks_uri;
    private String[] response_types_supported;
    private String[] subject_types_supported;
    private String[] id_token_signing_alg_values_supported;
    private String userinfo_endpoint;
    private String registration_endpoint;
    private String[] scopes_supported;
    private String[] claims_supported;
    private String[] response_modes_supported;
    private String[] grant_types_supported;
    private String[] token_endpoint_auth_methods_supported;
    private String[] display_values_supported;
    private String[] claim_types_supported;
    private boolean claims_parameter_supported;
    private boolean request_parameter_supported;
    private boolean request_uri_parameter_supported;
    private boolean require_request_uri_registration;
    private String check_session_iframe;
    private String end_session_endpoint;
    private String revocation_endpoint;
    private String app_passwords_endpoint;
    private String app_tokens_endpoint;
    private String personal_token_mgmt_endpoint;
    private String users_token_mgmt_endpoint;
    private String client_mgmt_endpoint;
    private String[] code_challenge_methods_supported;
    @Beta
    private final boolean backchannel_logout_supported = true;
    @Beta
    private final boolean backchannel_logout_session_supported = true;
    static final long serialVersionUID = -382683134667797121L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected OIDCAbstractDiscoveryModel() {
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAuthorizationEndpoint() {
        return this.authorization_endpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorization_endpoint = authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.token_endpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.token_endpoint = tokenEndpoint;
    }

    public String getJwks_uri() {
        return this.jwks_uri;
    }

    public void setJwks_uri(String jwks_uri) {
        this.jwks_uri = jwks_uri;
    }

    public String[] getResponseTypesSupported() {
        return this.defensiveCopy(this.response_types_supported);
    }

    public void setResponseTypesSupported(String[] responseTypesSupported) {
        this.response_types_supported = this.defensiveCopy(responseTypesSupported);
    }

    public String[] getSubjectTypesSupported() {
        return this.defensiveCopy(this.subject_types_supported);
    }

    public void setSubjectTypesSupported(String[] subjectTypesSupported) {
        this.subject_types_supported = this.defensiveCopy(subjectTypesSupported);
    }

    public String[] getIdTokenSigningAlgValuesSupported() {
        return this.defensiveCopy(this.id_token_signing_alg_values_supported);
    }

    public void setIdTokenSigningAlgValuesSupported(String[] idTokenSigningAlgValuesSupported) {
        this.id_token_signing_alg_values_supported = this.defensiveCopy(idTokenSigningAlgValuesSupported);
    }

    public String getUserinfoEndpoint() {
        return this.userinfo_endpoint;
    }

    public void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfo_endpoint = userinfoEndpoint;
    }

    public String getRegistrationEndpoint() {
        return this.registration_endpoint;
    }

    public void setRegistrationEndpoint(String registrationEndpoint) {
        this.registration_endpoint = registrationEndpoint;
    }

    public String[] getScopesSupported() {
        return this.defensiveCopy(this.scopes_supported);
    }

    public void setScopesSupported(String[] scopesSupported) {
        this.scopes_supported = this.defensiveCopy(scopesSupported);
    }

    public String[] getClaimsSupported() {
        return this.defensiveCopy(this.claims_supported);
    }

    public void setClaimsSupported(String[] claimsSupported) {
        this.claims_supported = this.defensiveCopy(claimsSupported);
    }

    public String[] getResponseModesSupported() {
        return this.defensiveCopy(this.response_modes_supported);
    }

    public void setResponseModesSupported(String[] responseModesSupported) {
        this.response_modes_supported = this.defensiveCopy(responseModesSupported);
    }

    public String[] getGrantTypesSupported() {
        return this.defensiveCopy(this.grant_types_supported);
    }

    public void setGrantTypesSupported(String[] grantTypesSupported) {
        this.grant_types_supported = this.defensiveCopy(grantTypesSupported);
    }

    public String[] getTokenEndpointAuthMethodsSupported() {
        return this.defensiveCopy(this.token_endpoint_auth_methods_supported);
    }

    public void setTokenEndpointAuthMethodsSupported(String[] tokenEndpointAuthMethodsSupported) {
        this.token_endpoint_auth_methods_supported = this.defensiveCopy(tokenEndpointAuthMethodsSupported);
    }

    public String[] getDisplayValuesSupported() {
        return this.defensiveCopy(this.display_values_supported);
    }

    public void setDisplayValuesSupported(String[] displayValuesSupported) {
        this.display_values_supported = this.defensiveCopy(displayValuesSupported);
    }

    public String[] getClaimTypesSupported() {
        return this.defensiveCopy(this.claim_types_supported);
    }

    public void setClaimTypesSupported(String[] claimTypesSupported) {
        this.claim_types_supported = this.defensiveCopy(claimTypesSupported);
    }

    public boolean isClaimsParameterSupported() {
        return this.claims_parameter_supported;
    }

    public void setClaimsParameterSupported(boolean claimsParameterSupported) {
        this.claims_parameter_supported = claimsParameterSupported;
    }

    public boolean isRequestParameterSupported() {
        return this.request_parameter_supported;
    }

    public void setRequestParameterSupported(boolean requestParameterSupported) {
        this.request_parameter_supported = requestParameterSupported;
    }

    public boolean isRequestUriParameterSupported() {
        return this.request_uri_parameter_supported;
    }

    public void setRequestUriParameterSupported(boolean requestUriParameterSupported) {
        this.request_uri_parameter_supported = requestUriParameterSupported;
    }

    public boolean isRequireRequestUriRegistration() {
        return this.require_request_uri_registration;
    }

    public void setRequireRequestUriRegistration(boolean requireRequestUriRegistration) {
        this.require_request_uri_registration = requireRequestUriRegistration;
    }

    public String getCheckSessionIframe() {
        return this.check_session_iframe;
    }

    public void setCheckSessionIframe(String checkSessionIframe) {
        this.check_session_iframe = checkSessionIframe;
    }

    public String getEndSessionEndpoint() {
        return this.end_session_endpoint;
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.end_session_endpoint = endSessionEndpoint;
    }

    public String getRevocationEndpoint() {
        return this.revocation_endpoint;
    }

    public void setRevocationEndpoint(String revocationEndpoint) {
        this.revocation_endpoint = revocationEndpoint;
    }

    public String getAppPasswordsEndpoint() {
        return this.app_passwords_endpoint;
    }

    public void setAppPasswordsEndpoint(String appPasswordsEndpoint) {
        this.app_passwords_endpoint = appPasswordsEndpoint;
    }

    public String getAppTokensEndpoint() {
        return this.app_tokens_endpoint;
    }

    public void setAppTokensEndpoint(String appTokensEndpoint) {
        this.app_tokens_endpoint = appTokensEndpoint;
    }

    public String getPersonalTokenMgmtEndpoint() {
        return this.personal_token_mgmt_endpoint;
    }

    public void setPersonalTokenMgmtEndpoint(String personalTokenMgmtEndpoint) {
        this.personal_token_mgmt_endpoint = personalTokenMgmtEndpoint;
    }

    public String getUsersTokenMgmtEndpoint() {
        return this.users_token_mgmt_endpoint;
    }

    public void setUsersTokenMgmtEndpoint(String usersTokenMgmtEndpoint) {
        this.users_token_mgmt_endpoint = usersTokenMgmtEndpoint;
    }

    public String getClientMgmtEndpoint() {
        return this.client_mgmt_endpoint;
    }

    public void setClientMgmtEndpoint(String clientMgmtEndpoint) {
        this.client_mgmt_endpoint = clientMgmtEndpoint;
    }

    public String[] getPkceCodeChallengeMethodsSupported() {
        return this.defensiveCopy(this.code_challenge_methods_supported);
    }

    public void setPkceCodeChallengeMethodsSupported(String[] pkceCodeChallengeMethodsSupported) {
        this.code_challenge_methods_supported = this.defensiveCopy(pkceCodeChallengeMethodsSupported);
    }

    private String[] defensiveCopy(String[] strArr) {
        return Arrays.copyOf(strArr, strArr.length);
    }

    public String toJSONString() {
        return JsonTokenUtil.toJsonFromObj((Gson)GSON, (Object)this);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.server.plugins.OIDCAbstractDiscoveryModel", OIDCAbstractDiscoveryModel.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
        GSON = new GsonBuilder().addSerializationExclusionStrategy(GsonStrategies.BETA_STRATEGY).create();
    }
}

