/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.filter;

import io.narayana.lra.Current;
import io.narayana.lra.client.NarayanaLRAClient;
import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipant;
import io.narayana.lra.client.internal.proxy.nonjaxrs.LRAParticipantRegistry;
import io.narayana.lra.logging.LRALogger;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.annotation.ws.rs.Leave;

@Provider
public class ServerLRAFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String CANCEL_ON_FAMILY_PROP = "CancelOnFamily";
    private static final String CANCEL_ON_PROP = "CancelOn";
    private static final String TERMINAL_LRA_PROP = "terminateLRA";
    private static final String SUSPENDED_LRA_PROP = "suspendLRA";
    private static final String NEW_LRA_PROP = "newLRA";
    @Context
    protected ResourceInfo resourceInfo;
    @Inject
    private LRAParticipantRegistry lraParticipantRegistry;
    private NarayanaLRAClient lraClient;

    public ServerLRAFilter() throws Exception {
        if (!NarayanaLRAClient.isInitialised()) {
            String lcHost = System.getProperty("lra.http.host", "localhost");
            int lcPort = Integer.getInteger(NarayanaLRAClient.LRA_COORDINATOR_PORT_KEY, 8080);
            String lraCoordinatorPath = System.getProperty(NarayanaLRAClient.LRA_COORDINATOR_PATH_KEY, "lra-coordinator");
            String lraCoordinatorUrl = String.format("http://%s:%d/%s", lcHost, lcPort, lraCoordinatorPath);
            NarayanaLRAClient.setDefaultCoordinatorEndpoint(new URI(lraCoordinatorUrl));
        }
        this.lraClient = new NarayanaLRAClient();
        if (this.lraParticipantRegistry == null) {
            LRALogger.i18NLogger.warn_nonJaxRsParticipantsNotAllowed();
        }
    }

    private void checkForTx(LRA.Type type, URI lraId, boolean shouldNotBeNull) {
        if (lraId == null && shouldNotBeNull) {
            this.throwGenericLRAException(null, Response.Status.PRECONDITION_FAILED.getStatusCode(), type.name() + " but no tx");
        } else if (lraId != null && !shouldNotBeNull) {
            this.throwGenericLRAException(lraId, Response.Status.PRECONDITION_FAILED.getStatusCode(), type.name() + " but found tx");
        }
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        URI lraId;
        Object lraContext;
        boolean endAnnotation;
        Method method = this.resourceInfo.getResourceMethod();
        MultivaluedMap headers = containerRequestContext.getHeaders();
        LRA.Type type = null;
        LRA transactional = method.getDeclaredAnnotation(LRA.class);
        URI newLRA = null;
        Long timeout = null;
        URI suspendedLRA = null;
        URI incommingLRA = null;
        boolean isLongRunning = false;
        boolean requiresActiveLRA = false;
        if (transactional == null) {
            transactional = method.getDeclaringClass().getDeclaredAnnotation(LRA.class);
        }
        if (transactional != null) {
            type = transactional.value();
            isLongRunning = !transactional.end();
            Response.Status.Family[] cancel0nFamily = transactional.cancelOnFamily();
            Response.Status[] cancel0n = transactional.cancelOn();
            if (cancel0nFamily.length != 0) {
                containerRequestContext.setProperty(CANCEL_ON_FAMILY_PROP, (Object)cancel0nFamily);
            }
            if (cancel0n.length != 0) {
                containerRequestContext.setProperty(CANCEL_ON_PROP, (Object)cancel0n);
            }
            if (transactional.timeLimit() != 0L) {
                timeout = Duration.of(transactional.timeLimit(), transactional.timeUnit()).toMillis();
            }
        }
        boolean bl = endAnnotation = method.isAnnotationPresent(Complete.class) || method.isAnnotationPresent(Compensate.class) || method.isAnnotationPresent(Leave.class) || method.isAnnotationPresent(Status.class) || method.isAnnotationPresent(Forget.class);
        if (headers.containsKey((Object)"Long-Running-Action")) {
            try {
                incommingLRA = new URI((String)Current.getLast((List)headers.get((Object)"Long-Running-Action")));
            }
            catch (URISyntaxException e) {
                String msg = String.format("header %s contains an invalid URL %s", "Long-Running-Action", Current.getLast((List)headers.get((Object)"Long-Running-Action")));
                this.throwGenericLRAException(null, Response.Status.PRECONDITION_FAILED.getStatusCode(), msg);
            }
        }
        if (method.isAnnotationPresent(Leave.class)) {
            String compensatorId = this.getCompensatorId(incommingLRA, containerRequestContext.getUriInfo(), timeout);
            this.lraTrace(containerRequestContext, incommingLRA, "leaving LRA");
            this.lraClient.leaveLRA(incommingLRA, compensatorId);
        }
        if (type == null) {
            if (!endAnnotation) {
                Current.clearContext((MultivaluedMap<String, String>)headers);
            }
            if (incommingLRA != null) {
                Current.push(incommingLRA);
                containerRequestContext.setProperty(SUSPENDED_LRA_PROP, (Object)incommingLRA);
            }
            return;
        }
        if (!headers.containsKey((Object)"Long-Running-Action") && (lraContext = containerRequestContext.getProperty("Long-Running-Action")) != null) {
            incommingLRA = (URI)lraContext;
        }
        if (endAnnotation && incommingLRA == null) {
            return;
        }
        switch (type) {
            case MANDATORY: {
                this.checkForTx(type, incommingLRA, true);
                lraId = incommingLRA;
                this.resumeTransaction(incommingLRA);
                requiresActiveLRA = true;
                break;
            }
            case NEVER: {
                this.checkForTx(type, incommingLRA, false);
                lraId = null;
                break;
            }
            case NOT_SUPPORTED: {
                suspendedLRA = incommingLRA;
                lraId = null;
                break;
            }
            case NESTED: 
            case REQUIRED: {
                if (incommingLRA != null) {
                    if (type == LRA.Type.NESTED) {
                        headers.putSingle((Object)"Long-Running-Action-Parent", (Object)incommingLRA.toASCIIString());
                        suspendedLRA = incommingLRA;
                        this.lraTrace(containerRequestContext, suspendedLRA, "ServerLRAFilter before: REQUIRED start new LRA");
                        newLRA = lraId = this.startLRA(incommingLRA, method, timeout);
                        break;
                    }
                    lraId = incommingLRA;
                    this.resumeTransaction(incommingLRA);
                    requiresActiveLRA = true;
                    break;
                }
                this.lraTrace(containerRequestContext, null, "ServerLRAFilter before: REQUIRED start new LRA");
                newLRA = lraId = this.startLRA(null, method, timeout);
                break;
            }
            case REQUIRES_NEW: {
                suspendedLRA = incommingLRA;
                this.lraTrace(containerRequestContext, suspendedLRA, "ServerLRAFilter before: REQUIRES_NEW start new LRA");
                newLRA = lraId = this.startLRA(null, method, timeout);
                break;
            }
            case SUPPORTS: {
                lraId = incommingLRA;
                if (incommingLRA == null) break;
                this.resumeTransaction(incommingLRA);
                break;
            }
            default: {
                lraId = incommingLRA;
            }
        }
        if (lraId == null) {
            this.lraTrace(containerRequestContext, null, "ServerLRAFilter before: removing header");
            Current.clearContext((MultivaluedMap<String, String>)headers);
            if (suspendedLRA != null) {
                containerRequestContext.setProperty(SUSPENDED_LRA_PROP, (Object)suspendedLRA);
            }
            return;
        }
        this.lraTrace(containerRequestContext, lraId, "ServerLRAFilter before: adding header");
        if (lraId.toASCIIString().contains("recovery-coordi")) {
            this.lraWarn(containerRequestContext, lraId, "wrong lra id");
        }
        if (!isLongRunning) {
            containerRequestContext.setProperty(TERMINAL_LRA_PROP, (Object)lraId);
        }
        Current.updateLRAContext(lraId, (MultivaluedMap<String, String>)headers);
        if (newLRA != null) {
            if (suspendedLRA != null) {
                containerRequestContext.setProperty(SUSPENDED_LRA_PROP, (Object)incommingLRA);
            }
            containerRequestContext.setProperty(NEW_LRA_PROP, (Object)newLRA);
        }
        Current.push(lraId);
        this.lraTrace(containerRequestContext, lraId, "ServerLRAFilter before: making LRA available to injected NarayanaLRAClient");
        this.lraClient.setCurrentLRA(lraId);
        if (!endAnnotation) {
            LRAParticipant participant;
            URI baseUri = containerRequestContext.getUriInfo().getBaseUri();
            Map<String, String> terminateURIs = NarayanaLRAClient.getTerminationUris(this.resourceInfo.getResourceClass(), containerRequestContext.getUriInfo(), timeout);
            String timeLimitStr = terminateURIs.get("TimeLimit");
            long timeLimit = timeLimitStr == null ? 0L : Long.valueOf(timeLimitStr);
            LRAParticipant lRAParticipant = participant = this.lraParticipantRegistry != null ? this.lraParticipantRegistry.getParticipant(this.resourceInfo.getResourceClass().getName()) : null;
            if (terminateURIs.containsKey("Link") || participant != null) {
                URI recoveryUrl;
                try {
                    if (participant != null) {
                        participant.augmentTerminationURIs(terminateURIs, baseUri);
                    }
                    recoveryUrl = this.lraClient.joinLRA(lraId, timeLimit, this.toURI(terminateURIs.get("compensate")), this.toURI(terminateURIs.get("complete")), this.toURI(terminateURIs.get("forget")), this.toURI(terminateURIs.get("leave")), this.toURI(terminateURIs.get("after")), this.toURI(terminateURIs.get("status")), null);
                }
                catch (NotFoundException e) {
                    throw e;
                }
                catch (WebApplicationException e) {
                    this.lraTrace(containerRequestContext, lraId, "ServerLRAFilter before: aborting with " + e.getMessage());
                    containerRequestContext.abortWith(e.getResponse());
                    return;
                }
                catch (URISyntaxException e) {
                    this.lraTrace(containerRequestContext, lraId, "ServerLRAFilter before: aborting with " + e.getMessage());
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("%s: %s", lraId, e.getMessage())).build());
                }
                headers.putSingle((Object)"Long-Running-Action-Recovery", (Object)recoveryUrl.toASCIIString().replaceAll("^\"|\"$", ""));
            } else if (requiresActiveLRA && !this.lraClient.isActive(lraId)) {
                Current.clearContext((MultivaluedMap<String, String>)headers);
                Current.pop(lraId);
                containerRequestContext.removeProperty(SUSPENDED_LRA_PROP);
                if (type == LRA.Type.MANDATORY) {
                    containerRequestContext.abortWith(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build());
                }
            } else {
                this.lraTrace(containerRequestContext, lraId, "ServerLRAFilter: skipping resource " + method.getDeclaringClass().getName() + " - no participant annotations");
            }
        }
        this.lraTrace(containerRequestContext, lraId, "ServerLRAFilter before: making LRA available as a thread local");
    }

    private URI toURI(String uri) throws URISyntaxException {
        return uri == null ? null : new URI(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Object suspendedLRA = requestContext.getProperty(SUSPENDED_LRA_PROP);
        URI current = Current.peek();
        URI toClose = (URI)requestContext.getProperty(TERMINAL_LRA_PROP);
        boolean isCancel = this.isJaxRsCancel(requestContext, responseContext);
        try {
            if (current != null && isCancel) {
                try {
                    this.lraClient.cancelLRA(current);
                }
                catch (NotFoundException notFoundException) {
                }
                finally {
                    if (current.toASCIIString().equals(Current.getLast((List)requestContext.getHeaders().get((Object)"Long-Running-Action")))) {
                        requestContext.getHeaders().remove((Object)"Long-Running-Action");
                    }
                    if (toClose != null && toClose.toASCIIString().equals(current.toASCIIString())) {
                        toClose = null;
                    }
                }
            }
            if (toClose != null) {
                try {
                    if (isCancel) {
                        this.lraClient.cancelLRA(toClose);
                    } else {
                        this.lraClient.closeLRA(toClose);
                    }
                }
                catch (NotFoundException notFoundException) {
                }
                finally {
                    requestContext.getHeaders().remove((Object)"Long-Running-Action");
                    if (toClose.toASCIIString().equals(Current.getLast((List)requestContext.getHeaders().get((Object)"Long-Running-Action")))) {
                        requestContext.getHeaders().remove((Object)"Long-Running-Action");
                    }
                }
            }
            if (responseContext.getStatus() == Response.Status.OK.getStatusCode() && NarayanaLRAClient.isAsyncCompletion(this.resourceInfo.getResourceMethod())) {
                LRALogger.i18NLogger.warn_lraParticipantqForAsync(this.resourceInfo.getResourceMethod().getDeclaringClass().getName(), this.resourceInfo.getResourceMethod().getName(), Response.Status.ACCEPTED.getStatusCode(), Response.Status.OK.getStatusCode());
            }
        }
        finally {
            if (suspendedLRA != null) {
                Current.push((URI)suspendedLRA);
            }
            Current.updateLRAContext(responseContext);
            Current.popAll();
        }
    }

    private boolean isJaxRsCancel(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        int status = responseContext.getStatus();
        Response.Status.Family[] cancel0nFamily = (Response.Status.Family[])requestContext.getProperty(CANCEL_ON_FAMILY_PROP);
        Response.Status[] cancel0n = (Response.Status[])requestContext.getProperty(CANCEL_ON_PROP);
        if (cancel0nFamily != null && Arrays.stream(cancel0nFamily).anyMatch(f -> Response.Status.Family.familyOf((int)status) == f)) {
            return true;
        }
        if (cancel0n != null) {
            return Arrays.stream(cancel0n).anyMatch(f -> status == f.getStatusCode());
        }
        return false;
    }

    private URI startLRA(URI parentLRA, Method method, Long timeout) {
        String clientId = method.getDeclaringClass().getName() + "#" + method.getName();
        return this.lraClient.startLRA(parentLRA, clientId, timeout, ChronoUnit.MILLIS);
    }

    private void resumeTransaction(URI lraId) {
    }

    private String getCompensatorId(URI lraId, UriInfo uriInfo, Long timeout) {
        Map<String, String> terminateURIs = NarayanaLRAClient.getTerminationUris(this.resourceInfo.getResourceClass(), uriInfo, timeout);
        if (!terminateURIs.containsKey("Link")) {
            this.throwGenericLRAException(lraId, Response.Status.BAD_REQUEST.getStatusCode(), "Missing complete or compensate annotations");
        }
        return terminateURIs.get("Link");
    }

    private void lraTrace(ContainerRequestContext context, URI lraId, String reason) {
        if (LRALogger.logger.isTraceEnabled()) {
            Method method = this.resourceInfo.getResourceMethod();
            LRALogger.logger.tracef("%s: container request for method %s: lra: %s%n", (Object)reason, (Object)(method.getDeclaringClass().getName() + "#" + method.getName()), lraId == null ? "context" : lraId);
        }
    }

    private void lraWarn(ContainerRequestContext context, URI lraId, String reason) {
        Method method = this.resourceInfo.getResourceMethod();
        LRALogger.i18NLogger.warn_lraFilterContainerRequest(reason, method.getDeclaringClass().getName() + "#" + method.getName(), lraId == null ? "context" : lraId.toString());
    }

    private void throwGenericLRAException(URI lraId, int statusCode, String message) throws WebApplicationException {
        throw new WebApplicationException(Response.status((int)statusCode).entity((Object)String.format("%s: %s", lraId, message)).build());
    }
}

