/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.SelectorImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OperatorImpl
extends SelectorImpl
implements Operator {
    public int op;
    public Selector[] operands;
    private int hashcode;
    private boolean hashCodeCached;

    public OperatorImpl() {
    }

    public OperatorImpl(int op, Selector op1) {
        this.op = op;
        this.operands = new Selector[]{op1};
        this.assignType();
        if (this.type == 2) {
            return;
        }
        this.numIds = op1.getNumIds();
        if (this.numIds == 0 && op1 instanceof Operator) {
            this.operands[0] = new LiteralImpl(Matching.getEvaluator().eval(op1));
        }
    }

    public OperatorImpl(int op, Selector op1, Selector op2) {
        this.op = op;
        this.operands = new Selector[]{op1, op2};
        this.assignType();
        if (this.type == 2) {
            return;
        }
        if (op1.getNumIds() == 0 && op1 instanceof Operator) {
            this.operands[0] = new LiteralImpl(Matching.getEvaluator().eval(op1));
        }
        if (op2.getNumIds() == 0 && op2 instanceof Operator) {
            this.operands[1] = new LiteralImpl(Matching.getEvaluator().eval(op2));
        }
        this.numIds = op1.getNumIds() + op2.getNumIds();
    }

    public OperatorImpl(ObjectInput buf) throws ClassNotFoundException, IOException {
        int i;
        this.op = buf.readByte();
        this.operands = new SelectorImpl[this.op >= 40 ? 2 : 1];
        for (i = 0; i < this.operands.length; ++i) {
            this.operands[i] = SelectorImpl.decodeSubtree(buf);
        }
        this.assignType();
        if (this.type == 2) {
            return;
        }
        for (i = 0; i < this.operands.length; ++i) {
            Selector operand = this.operands[i];
            if (operand.getNumIds() == 0 && operand instanceof Operator) {
                this.operands[i] = new LiteralImpl(Matching.getEvaluator().eval(operand));
            }
            this.numIds += operand.getNumIds();
        }
    }

    public void assignType() {
        switch (this.op) {
            case 1: {
                this.type = this.operands[0].mayBeBoolean() ? -6 : 2;
                break;
            }
            case 2: {
                this.type = this.operands[0].mayBeNumeric() ? this.operands[0].getType() : 2;
                break;
            }
            case 3: {
                if (this.operands[0] instanceof Identifier) {
                    this.type = -6;
                    break;
                }
                this.type = 2;
                break;
            }
            case 4: {
                this.type = this.operands[0].mayBeString() ? -6 : 2;
                break;
            }
            case 5: {
                this.type = this.operands[0].getType() == 3 ? -6 : 2;
                break;
            }
            case 40: 
            case 45: {
                int type0 = this.operands[0].getType();
                int type1 = this.operands[1].getType();
                if (type0 >= -4 && type0 <= -1) {
                    type0 = 1;
                }
                if (type1 >= -4 && type1 <= -1) {
                    type1 = 1;
                }
                if (type0 == 3) {
                    type0 = -5;
                }
                if (type1 == 3) {
                    type1 = -5;
                }
                if (type0 == 0) {
                    type0 = type1;
                    this.operands[0].setType(type1);
                } else if (type1 == 0) {
                    type1 = type0;
                    this.operands[1].setType(type0);
                }
                this.type = type0 == type1 ? -6 : 2;
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.type = this.operands[0].mayBeNumeric() && this.operands[1].mayBeNumeric() ? -6 : 2;
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                if (!this.operands[0].mayBeNumeric() || !this.operands[1].mayBeNumeric()) {
                    this.type = 2;
                    break;
                }
                this.type = this.operands[0].getType() > this.operands[1].getType() ? this.operands[0].getType() : this.operands[1].getType();
                break;
            }
            case 46: 
            case 47: {
                this.type = this.operands[0].mayBeBoolean() && this.operands[1].mayBeBoolean() ? -6 : 2;
                break;
            }
            default: {
                this.type = 2;
            }
        }
    }

    public void encodeSelf(ObjectOutput buf) throws IOException {
        buf.writeByte((byte)this.op);
        for (int i = 0; i < this.operands.length; ++i) {
            this.operands[i].encodeSelf(buf);
        }
    }

    @Override
    public Selector intern(Selector.InternTable table) {
        for (int i = 0; i < this.operands.length; ++i) {
            this.operands[i] = this.operands[i].intern(table);
        }
        return super.intern(table);
    }

    @Override
    public void unintern(Selector.InternTable table) {
        for (int i = 0; i < this.operands.length; ++i) {
            this.operands[i].unintern(table);
        }
        super.unintern(table);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Operator && super.equals(o)) {
            Operator other = (Operator)o;
            if (this.op != other.getOp()) {
                return false;
            }
            for (int i = 0; i < this.operands.length; ++i) {
                if (this.operands[i].equals((Object)other.getOperands()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCodeCached) {
            return this.hashcode;
        }
        int ans = this.op;
        for (int i = 0; i < this.operands.length; ++i) {
            ans = (ans << 9) + this.operands[i].hashCode();
        }
        this.hashCodeCached = true;
        this.hashcode = ans;
        return ans;
    }

    @Override
    public Object clone() {
        Operator result = (Operator)super.clone();
        for (int i = 0; i < this.operands.length; ++i) {
            result.setOperand(i, (Selector)this.operands[i].clone());
        }
        return result;
    }

    public String toString() {
        String stringOp = null;
        int prec = this.precedence(this);
        String op1 = this.operands[0].toString();
        if (this.precedence(this.operands[0]) > prec) {
            op1 = "(" + op1 + ")";
        }
        String op2 = null;
        if (this.operands.length > 1) {
            op2 = this.operands[1].toString();
            if (this.precedence(this.operands[1]) > prec) {
                op2 = "(" + op2 + ")";
            }
        }
        switch (this.op) {
            case 1: {
                return "NOT " + op1;
            }
            case 2: {
                return "-" + op1;
            }
            case 3: {
                return op1 + " IS NULL";
            }
            case 40: {
                stringOp = "<>";
                break;
            }
            case 41: {
                stringOp = ">";
                break;
            }
            case 42: {
                stringOp = "<";
                break;
            }
            case 43: {
                stringOp = ">=";
                break;
            }
            case 44: {
                stringOp = "<=";
                break;
            }
            case 45: {
                stringOp = "=";
                break;
            }
            case 46: {
                stringOp = " AND ";
                break;
            }
            case 47: {
                stringOp = " OR ";
                break;
            }
            case 48: {
                stringOp = "+";
                break;
            }
            case 49: {
                stringOp = "-";
                break;
            }
            case 50: {
                stringOp = "*";
                break;
            }
            case 51: {
                stringOp = "/";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return op1 + stringOp + op2;
    }

    private int precedence(Selector sel) {
        if (!(sel instanceof Operator)) {
            return 0;
        }
        Operator oper = (Operator)sel;
        if (oper.getOp() < 40) {
            return 0;
        }
        switch (oper.getOp()) {
            case 50: 
            case 51: {
                return 1;
            }
            case 48: 
            case 49: {
                return 2;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return 3;
            }
            case 46: {
                return 4;
            }
        }
        return 5;
    }

    public int getOp() {
        return this.op;
    }

    public Selector[] getOperands() {
        return this.operands;
    }

    public void setOperand(int i, Selector operand) {
        this.operands[i] = operand;
    }
}

