/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.apache.myfaces.util.lang.StringUtils;

public class ResourceLoaderUtils {
    private static final DateTimeFormatter HTTP_RESPONSE_DATE_HEADER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(ZoneId.of("GMT"));
    private static final DateTimeFormatter[] HTTP_REQUEST_DATE_HEADER = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).withZone(ZoneId.of("GMT")), DateTimeFormatter.ofPattern("EEE MMMM d HH:mm:ss yyyy", Locale.US).withZone(ZoneId.of("GMT"))};

    public static String formatDateHeader(long value) {
        Instant instant = Instant.ofEpochMilli(value);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, HTTP_RESPONSE_DATE_HEADER.getZone());
        return HTTP_RESPONSE_DATE_HEADER.format(zdt);
    }

    public static Long parseDateHeader(String value) {
        for (DateTimeFormatter formatter : HTTP_REQUEST_DATE_HEADER) {
            try {
                ZonedDateTime zdt = ZonedDateTime.parse(value, formatter);
                return zdt.toInstant().toEpochMilli();
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getResourceLastModified(URL url) throws IOException {
        long lastModified;
        InputStream is = null;
        try {
            URLConnection connection = url.openConnection();
            if (connection instanceof JarURLConnection) {
                JarURLConnection jarUrlConnection = (JarURLConnection)connection;
                URL jarFileUrl = jarUrlConnection.getJarFileURL();
                URLConnection jarFileConnection = jarFileUrl.openConnection();
                is = jarFileConnection.getInputStream();
                lastModified = jarFileConnection.getLastModified();
            } else {
                is = connection.getInputStream();
                lastModified = connection.getLastModified();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return lastModified;
    }

    public static int getDepth(String path) {
        int depth = 0;
        String[] paths = StringUtils.splitShortString(path, '/');
        if (paths == null) {
            return 0;
        }
        for (String p : paths) {
            if (p == null || p.length() <= 0) continue;
            ++depth;
        }
        return depth;
    }

    public static boolean isDirectory(String path) {
        return path.startsWith("/") && path.endsWith("/");
    }
}

