/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.resolver;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.LeftExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ReplaceExpression;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.RightExpression;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.tools.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.tools.resolver.Resolver;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.utility.iterable.SnapshotCloneIterable;

public class FromSubqueryResolver
extends Resolver {
    private IManagedType managedType;
    private JPQLQueryContext queryContext;
    private SimpleSelectStatement subquery;

    public FromSubqueryResolver(Resolver parent, JPQLQueryContext queryContext, SimpleSelectStatement subquery) {
        super(parent);
        this.subquery = subquery;
        this.queryContext = queryContext;
    }

    @Override
    protected IType buildType() {
        return this.getManagedType().getType();
    }

    @Override
    protected ITypeDeclaration buildTypeDeclaration() {
        return this.getType().getTypeDeclaration();
    }

    @Override
    public IManagedType getManagedType() {
        if (this.managedType == null) {
            this.managedType = new VirtualManagedType();
        }
        return this.managedType;
    }

    protected class VirtualManagedType
    implements IManagedType {
        private Map<String, IMapping> mappings;

        protected VirtualManagedType() {
        }

        @Override
        public void accept(IManagedTypeVisitor visitor) {
        }

        @Override
        public int compareTo(IManagedType managedType) {
            return this.getType().getName().compareTo(managedType.getType().getName());
        }

        @Override
        public IMapping getMappingNamed(String name) {
            this.initializeMappings();
            return this.mappings.get(name);
        }

        @Override
        public IManagedTypeProvider getProvider() {
            return FromSubqueryResolver.this.getProvider();
        }

        @Override
        public IType getType() {
            return this.getProvider().getTypeRepository().getType("UNRESOLVABLE_TYPE");
        }

        private void initializeMappings() {
            if (this.mappings == null) {
                this.mappings = new HashMap<String, IMapping>();
                VirtualMappingBuilder builder = new VirtualMappingBuilder();
                builder.parent = this;
                builder.mappings = this.mappings;
                FromSubqueryResolver.this.subquery.accept(builder);
            }
        }

        @Override
        public Iterable<IMapping> mappings() {
            this.initializeMappings();
            return new SnapshotCloneIterable<IMapping>(this.mappings.values());
        }
    }

    protected class VirtualMappingBuilder
    extends AbstractEclipseLinkExpressionVisitor {
        private Map<String, IMapping> mappings;
        private MappingType mappingType = MappingType.UNKNOWN;
        protected IManagedType parent;

        protected IMapping buildMapping(String name, Resolver resolver) {
            return new VirtualMapping(this.parent, name, resolver, this.mappingType);
        }

        @Override
        public void visit(AbsExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(AdditionExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(AvgFunction expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(CollectionExpression expression) {
            expression.acceptChildren(this);
        }

        @Override
        public void visit(ConcatExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(CountFunction expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(DivisionExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(IndexExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(LeftExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(LengthExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(LocateExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(LowerExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(MaxFunction expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(MinFunction expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(ReplaceExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(ResultVariable expression) {
            String name = FromSubqueryResolver.this.queryContext.literal(expression, LiteralType.RESULT_VARIABLE);
            if (ExpressionTools.stringIsNotEmpty(name)) {
                Expression selectExpression = expression.getSelectExpression();
                selectExpression.accept(this);
                Resolver resolver = FromSubqueryResolver.this.queryContext.getResolver(selectExpression);
                this.mappings.put(name, this.buildMapping(name, resolver));
            }
        }

        @Override
        public void visit(RightExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(SimpleSelectClause expression) {
            expression.getSelectExpression().accept(this);
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            expression.getSelectClause().accept(this);
        }

        @Override
        public void visit(SizeExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(SqrtExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            String name;
            if (!expression.startsWithDot() && ExpressionTools.stringIsNotEmpty(name = FromSubqueryResolver.this.queryContext.literal(expression, LiteralType.PATH_EXPRESSION_LAST_PATH))) {
                this.mappingType = MappingType.UNKNOWN;
                Resolver resolver = FromSubqueryResolver.this.queryContext.getResolver(expression);
                this.mappings.put(name, this.buildMapping(name, resolver));
            }
        }

        @Override
        public void visit(SubstringExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(SubtractionExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(SumFunction expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(TrimExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }

        @Override
        public void visit(UpperExpression expression) {
            this.mappingType = MappingType.PROPERTY;
        }
    }

    protected static class VirtualMapping
    implements IMapping {
        private MappingType mappingType;
        private String name;
        private IManagedType parent;
        private Resolver resolver;

        protected VirtualMapping(IManagedType parent, String name, Resolver resolver, MappingType mappingType) {
            this.name = name;
            this.parent = parent;
            this.resolver = resolver;
            this.mappingType = mappingType;
        }

        @Override
        public int compareTo(IMapping mapping) {
            return this.getName().compareTo(mapping.getName());
        }

        @Override
        public int getMappingType() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.getMappingType() : 10;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public IManagedType getParent() {
            return this.parent;
        }

        @Override
        public IType getType() {
            return this.resolver.getType();
        }

        @Override
        public ITypeDeclaration getTypeDeclaration() {
            return this.resolver.getTypeDeclaration();
        }

        @Override
        public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
            return this.getType().hasAnnotation(annotationType);
        }

        @Override
        public boolean isCollection() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.isCollection() : false;
        }

        @Override
        public boolean isEmbeddable() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.isEmbeddable() : false;
        }

        @Override
        public boolean isProperty() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.isProperty() : this.mappingType == MappingType.PROPERTY;
        }

        @Override
        public boolean isRelationship() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.isRelationship() : this.mappingType == MappingType.RELATIONSHIP;
        }

        @Override
        public boolean isTransient() {
            IMapping mapping = this.resolver.getMapping();
            return mapping != null ? mapping.isTransient() : false;
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum MappingType {
        PROPERTY,
        RELATIONSHIP,
        UNKNOWN;

    }
}

