/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.jdeparser.JArrayClass;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExpression;
import org.jboss.jdeparser.JExtendsWildcard;
import org.jboss.jdeparser.JFieldRef;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JInvocation;
import org.jboss.jdeparser.JMethod;
import org.jboss.jdeparser.JNarrowedClass;
import org.jboss.jdeparser.JNullType;
import org.jboss.jdeparser.JPackage;
import org.jboss.jdeparser.JPrimitiveType;
import org.jboss.jdeparser.JSuperWildcard;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypeVar;
import org.jboss.jdeparser.JVar;

public abstract class JClass
extends JType {
    private final JDeparser _owner;
    protected static final JTypeVar[] EMPTY_ARRAY = new JTypeVar[0];
    private JClass arrayClass;

    protected JClass(JDeparser _owner) {
        this._owner = _owner;
    }

    @Override
    public abstract String name();

    public abstract JPackage _package();

    public JClass outer() {
        return null;
    }

    @Override
    public final JDeparser owner() {
        return this._owner;
    }

    public abstract JClass _extends();

    public abstract Iterator<JClass> _implements();

    public JTypeVar[] typeParams() {
        return EMPTY_ARRAY;
    }

    public abstract boolean isInterface();

    public abstract boolean isAbstract();

    public JPrimitiveType getPrimitiveType() {
        return null;
    }

    @Override
    public JClass boxify() {
        return this;
    }

    @Override
    public JType unboxify() {
        JPrimitiveType pt = this.getPrimitiveType();
        return pt == null ? this : pt;
    }

    @Override
    public JClass erasure() {
        return this;
    }

    public final boolean isAssignableFrom(JClass derived) {
        if (derived instanceof JNullType) {
            return true;
        }
        if (this == derived) {
            return true;
        }
        if (this == this._package().owner().ref(Object.class)) {
            return true;
        }
        JClass b = derived._extends();
        if (b != null && this.isAssignableFrom(b)) {
            return true;
        }
        if (this.isInterface()) {
            Iterator<JClass> itfs = derived._implements();
            while (itfs.hasNext()) {
                if (!this.isAssignableFrom(itfs.next())) continue;
                return true;
            }
        }
        return false;
    }

    public final JClass getBaseClass(JClass baseType) {
        JClass bc;
        if (this.erasure().equals(baseType)) {
            return this;
        }
        JClass b = this._extends();
        if (b != null && (bc = b.getBaseClass(baseType)) != null) {
            return bc;
        }
        Iterator<JClass> itfs = this._implements();
        while (itfs.hasNext()) {
            JClass bc2 = itfs.next().getBaseClass(baseType);
            if (bc2 == null) continue;
            return bc2;
        }
        return null;
    }

    public final JClass getBaseClass(Class<?> baseType) {
        return this.getBaseClass(this.owner().ref(baseType));
    }

    @Override
    public JClass array() {
        if (this.arrayClass == null) {
            this.arrayClass = new JArrayClass(this.owner(), this);
        }
        return this.arrayClass;
    }

    public JClass narrow(Class<?> clazz) {
        return this.narrow(this.owner().ref(clazz));
    }

    public JClass narrow(Class<?> ... clazz) {
        JClass[] r = new JClass[clazz.length];
        for (int i = 0; i < clazz.length; ++i) {
            r[i] = this.owner().ref(clazz[i]);
        }
        return this.narrow(r);
    }

    public JClass narrow(JClass clazz) {
        return new JNarrowedClass(this, clazz);
    }

    public JClass narrow(JType type) {
        return this.narrow(type.boxify());
    }

    public JClass narrow(JClass ... clazz) {
        return new JNarrowedClass(this, Arrays.asList((Object[])clazz.clone()));
    }

    public JClass narrow(List<? extends JClass> clazz) {
        return new JNarrowedClass(this, new ArrayList<JClass>(clazz));
    }

    public List<JClass> getTypeParameters() {
        return Collections.emptyList();
    }

    public final boolean isParameterized() {
        return this.erasure() != this;
    }

    public final JClass wildcard() {
        return new JExtendsWildcard(this);
    }

    public final JClass superWildcard() {
        return new JSuperWildcard(this);
    }

    protected abstract JClass substituteParams(JTypeVar[] var1, List<JClass> var2);

    @Override
    public String toString() {
        return this.getClass().getName() + '(' + this.name() + ')';
    }

    public final JExpression dotclass() {
        return JExpr.dotclass(this);
    }

    public final JInvocation staticInvoke(JMethod method) {
        return new JInvocation(this, method);
    }

    public final JInvocation staticInvoke(String method) {
        return new JInvocation(this, method);
    }

    public final JFieldRef staticRef(String field) {
        return new JFieldRef((JType)this, field);
    }

    public final JFieldRef staticRef(JVar field) {
        return new JFieldRef((JType)this, field);
    }

    @Override
    public void generate(JFormatter f) {
        f.t(this);
    }

    void printLink(JFormatter f) {
        f.p("{@link ").g(this).p('}');
    }
}

