/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.authorization.jacc.internal.proxy;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.PolicyConfigurationManager;
import com.ibm.ws.security.authorization.jacc.common.PolicyProxy;
import com.ibm.ws.security.authorization.jacc.common.ProviderServiceProxy;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.authorization.jacc.ProviderService;
import io.openliberty.security.authorization.jacc.internal.proxy.JakartaPolicyFactoryProxyImpl;
import io.openliberty.security.authorization.jacc.internal.proxy.PolicyFactoryImpl;
import jakarta.security.jacc.PolicyConfigurationFactory;
import jakarta.security.jacc.PolicyFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ProviderServiceProxy.class}, immediate=true, name="io.openliberty.security.authorization.jacc.provider.proxy", configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ProviderServiceProxyImpl
implements ProviderServiceProxy {
    private static final TraceComponent tc = Tr.register(ProviderServiceProxyImpl.class, null, null);
    static final String KEY_JACC_PROVIDER_SERVICE = "jaccProviderService";
    private static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private final AtomicServiceReference<ProviderService> jaccProviderService = new AtomicServiceReference("jaccProviderService");
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    private String policyFactoryName = null;
    private String factoryName = null;
    private String originalSystemPolicyFactoryName = null;
    private String originalSystemFactoryName = null;
    static final long serialVersionUID = 4659100264979304784L;

    @Reference(service=ProviderService.class, policy=ReferencePolicy.DYNAMIC, name="jaccProviderService")
    protected void setJaccProviderService(ServiceReference<ProviderService> reference) {
        this.jaccProviderService.setReference(reference);
        this.initializeSystemProperties(reference);
    }

    protected void unsetJaccProviderService(ServiceReference<ProviderService> reference) {
        this.jaccProviderService.unsetReference(reference);
        this.restoreSystemProperties();
    }

    @Reference(service=WsLocationAdmin.class, name="locationAdmin")
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> reference) {
        this.locationAdminRef.setReference(reference);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> reference) {
        this.locationAdminRef.unsetReference(reference);
    }

    public PolicyProxy getPolicyProxy(PolicyConfigurationManager pcm) {
        ProviderService providerService = (ProviderService)this.jaccProviderService.getService();
        if (providerService == null) {
            return null;
        }
        WsLocationAdmin locationAdmin = (WsLocationAdmin)this.locationAdminRef.getService();
        if (this.policyFactoryName != null) {
            PolicyFactory policyFactory = PolicyFactory.getPolicyFactory();
            if (!(policyFactory instanceof PolicyFactoryImpl)) {
                policyFactory = new PolicyFactoryImpl(policyFactory, locationAdmin, providerService, pcm);
                PolicyFactory.setPolicyFactory((PolicyFactory)policyFactory);
            } else if (((PolicyFactoryImpl)policyFactory).providerService != providerService) {
                policyFactory = new PolicyFactoryImpl(policyFactory.getWrapped(), locationAdmin, providerService, pcm);
                PolicyFactory.setPolicyFactory((PolicyFactory)policyFactory);
            }
        } else {
            PolicyFactoryImpl policyFactory = new PolicyFactoryImpl(locationAdmin, providerService, pcm);
            PolicyFactory.setPolicyFactory((PolicyFactory)policyFactory);
        }
        return new JakartaPolicyFactoryProxyImpl();
    }

    public PolicyConfigurationFactory getPolicyConfigFactory() {
        ProviderService providerService = (ProviderService)this.jaccProviderService.getService();
        return providerService == null ? null : providerService.getPolicyConfigFactory();
    }

    public Object getProperty(String property) {
        ServiceReference serviceRef = this.jaccProviderService.getReference();
        return serviceRef == null ? null : serviceRef.getProperty(property);
    }

    public String getPolicyName() {
        return this.policyFactoryName != null ? this.policyFactoryName : PolicyFactoryImpl.class.getName();
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    protected void activate(ComponentContext cc) {
        this.locationAdminRef.activate(cc);
        this.jaccProviderService.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        PolicyFactory.setPolicyFactory(null);
        this.jaccProviderService.deactivate(cc);
        this.locationAdminRef.deactivate(cc);
    }

    private void initializeSystemProperties(ServiceReference<ProviderService> reference) {
        Object obj = reference.getProperty("jakarta.security.jacc.PolicyFactory.provider");
        if (obj != null && obj instanceof String) {
            this.policyFactoryName = (String)obj;
        }
        if ((obj = reference.getProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider")) != null && obj instanceof String) {
            this.factoryName = (String)obj;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Meta data : policyFactoryName : " + this.policyFactoryName + " factoryName : " + this.factoryName), (Object[])new Object[0]);
        }
        this.originalSystemPolicyFactoryName = null;
        this.originalSystemFactoryName = null;
        String systemPolicyFactoryName = System.getProperty("jakarta.security.jacc.PolicyFactory.provider");
        String systemFactoryName = System.getProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("System properties : policyFactoryName : " + systemPolicyFactoryName + " factoryName : " + systemFactoryName), (Object[])new Object[0]);
        }
        if (systemPolicyFactoryName == null) {
            if (this.policyFactoryName != null) {
                System.setProperty("jakarta.security.jacc.PolicyFactory.provider", this.policyFactoryName);
            }
        } else if (this.policyFactoryName == null) {
            this.policyFactoryName = systemPolicyFactoryName;
        } else if (!systemPolicyFactoryName.equals(this.policyFactoryName)) {
            Tr.warning((TraceComponent)tc, (String)"JACC_INCONSISTENT_POLICY_CLASS", (Object[])new Object[]{systemPolicyFactoryName, this.policyFactoryName});
            System.setProperty("jakarta.security.jacc.PolicyFactory.provider", this.policyFactoryName);
            this.originalSystemPolicyFactoryName = systemPolicyFactoryName;
        }
        if (systemFactoryName == null) {
            if (this.factoryName != null) {
                System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", this.factoryName);
            } else if (this.factoryName == null) {
                Tr.error((TraceComponent)tc, (String)"JACC_FACTORY_IS_NOT_SET", (Object[])new Object[0]);
                return;
            }
        } else if (this.factoryName == null) {
            this.factoryName = systemFactoryName;
        } else if (!systemFactoryName.equals(this.factoryName)) {
            Tr.warning((TraceComponent)tc, (String)"JACC_INCONSISTENT_FACTORY_CLASS", (Object[])new Object[]{systemFactoryName, this.factoryName});
            System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", this.factoryName);
            this.originalSystemFactoryName = systemFactoryName;
        }
    }

    private void restoreSystemProperties() {
        if (this.originalSystemPolicyFactoryName != null) {
            System.setProperty("jakarta.security.jacc.PolicyFactory.provider", this.originalSystemPolicyFactoryName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("PolicyFactoryName system property is restored by : " + this.originalSystemPolicyFactoryName), (Object[])new Object[0]);
            }
        }
        if (this.originalSystemFactoryName != null) {
            System.setProperty("jakarta.security.jacc.PolicyConfigurationFactory.provider", this.originalSystemFactoryName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("PolicyConfigurationFactory system property is restored by : " + this.originalSystemFactoryName), (Object[])new Object[0]);
            }
        }
    }
}

