/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.mfp.JsMessageHandleRestorer;
import com.ibm.ws.sib.mfp.impl.JsMessageHandleImpl;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.utils.HexString;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIMessageHandle;

public class JsMessageHandleRestorerImpl
extends JsMessageHandleRestorer {
    private static TraceComponent tc = SibTr.register(JsMessageHandleRestorerImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");

    @Override
    public SIMessageHandle restoreFromBytes(byte[] data) throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreFromBytes");
        }
        int minValidArrayLength = 14;
        if (data == null) {
            String exString = nls.getFormattedMessage("NULL_HANDLE_PASSED_FOR_RESTORE_CWSIF0032", new Object[]{"NULL"}, "JsMessageHandleRestorer.restoreFromBytes called with NULL.");
            IllegalArgumentException e = new IllegalArgumentException(exString);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"restoreFromBytes called with NULL, throwing IllegalArgumentException");
            }
            throw e;
        }
        if (data.length < minValidArrayLength) {
            String exString = nls.getFormattedMessage("RESTORE_FROM_BYTES_ARRAY_TOO_SHORT_CWSIF0033", null, "Array length was shorter than the minimum valid array length.");
            IllegalArgumentException e = new IllegalArgumentException(exString);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String formattedBytes = SibTr.formatBytes((byte[])data, (int)0, (int)data.length);
                SibTr.debug((TraceComponent)tc, (String)("Throwing IllegalArgumentException : " + exString), (Object)formattedBytes);
            }
            throw e;
        }
        int offset = 0;
        short vNumber = ArrayUtil.readShort(data, offset);
        offset += 2;
        if (vNumber != 1) {
            String exString = nls.getFormattedMessage("RESTORE_FROM_BYTES_UNKNOWN_VERSION_NUMBER_CWSIF0034", null, "Unknown version information detected in MessageHandle : " + vNumber);
            IllegalArgumentException e = new IllegalArgumentException(exString);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String formattedBytes = SibTr.formatBytes((byte[])data, (int)0, (int)data.length);
                SibTr.debug((TraceComponent)tc, (String)("Throwing IllegalArgumentException : " + exString), (Object)formattedBytes);
            }
            throw e;
        }
        int uuidLength = ArrayUtil.readInt(data, offset);
        offset += 4;
        if (uuidLength != data.length - minValidArrayLength) {
            String exString = nls.getFormattedMessage("RESTORE_FROM_BYTES_INTERNAL_LENGTH_CHECK_FAIL_CWSIF0035", null, "Invalid data passed to in restoreFromBytes. Internal length checks do not match.");
            IllegalArgumentException e = new IllegalArgumentException(exString);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String formattedBytes = SibTr.formatBytes((byte[])data, (int)0, (int)data.length);
                SibTr.debug((TraceComponent)tc, (String)("Throwing IllegalArgumentException : " + exString), (Object)formattedBytes);
            }
            throw e;
        }
        JsMessageHandleImpl handle = null;
        if (uuidLength == 0) {
            long value = ArrayUtil.readLong(data, offset);
            handle = new JsMessageHandleImpl(value);
        } else {
            byte[] uuidBytes = ArrayUtil.readBytes(data, offset, uuidLength);
            SIBUuid8 uuid = new SIBUuid8(uuidBytes);
            long value = ArrayUtil.readLong(data, offset += uuidLength);
            handle = new JsMessageHandleImpl(uuid, value);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreFromBytes", (Object)handle);
        }
        return handle;
    }

    @Override
    public SIMessageHandle restoreFromString(String data) throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreFromString");
        }
        if (data == null || data.equals("")) {
            String badValueType = data == null ? "NULL" : "Empty string";
            String exString = nls.getFormattedMessage("NULL_HANDLE_PASSED_FOR_RESTORE_CWSIF0032", new Object[]{badValueType}, "restoreFromString called with invalid parameter of " + badValueType + ".");
            IllegalArgumentException e = new IllegalArgumentException(exString);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("restoreFromString called with invalid parameter of " + badValueType + "."), (Object)e);
            }
            throw e;
        }
        byte[] bytes = HexString.hexToBin((String)data, (int)0);
        SIMessageHandle handle = this.restoreFromBytes(bytes);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreFromString");
        }
        return handle;
    }
}

