/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.cdi.extensions;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.cdi.extensions.HttpAuthenticationMechanismsTracker;
import com.ibm.ws.security.javaeesec.cdi.extensions.PrimarySecurityCDIExtension;
import io.openliberty.security.jakartasec.OpenIdAuthenticationMechanismDefinitionHolder;
import io.openliberty.security.jakartasec.cdi.beans.OidcHttpAuthenticationMechanism;
import io.openliberty.security.jakartasec.cdi.extensions.OidcIdentityStoreBean;
import io.openliberty.security.jakartasec.cdi.extensions.OpenIdContextBean;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.security.enterprise.authentication.mechanism.http.OpenIdAuthenticationMechanismDefinition;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JakartaSecurity30CDIExtension
implements Extension {
    private static final TraceComponent tc = Tr.register(JakartaSecurity30CDIExtension.class, (String)"JAKARTASEC", (String)"io.openliberty.security.jakartasec.cdi.internal.resources.JakartaSecurity30Messages");
    private static PrimarySecurityCDIExtension primarySecurityCDIExtension;
    private final Set<Bean> beansToAdd = new HashSet<Bean>();
    private final String applicationName = HttpAuthenticationMechanismsTracker.getApplicationName();
    static final long serialVersionUID = 6197391068195085375L;

    @Reference
    protected void setPrimarySecurityCDIExtension(PrimarySecurityCDIExtension primarySecurityCDIExtension) {
        JakartaSecurity30CDIExtension.primarySecurityCDIExtension = primarySecurityCDIExtension;
        primarySecurityCDIExtension.registerMechanismClass(OidcHttpAuthenticationMechanism.class);
    }

    @Deactivate
    protected void deactivate() {
        primarySecurityCDIExtension.deregisterMechanismClass(OidcHttpAuthenticationMechanism.class);
    }

    public <T> void processAnnotatedOidc(@WithAnnotations(value={OpenIdAuthenticationMechanismDefinition.class}) @Observes ProcessAnnotatedType<T> event, BeanManager beanManager) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        Annotation oidcAnnotation = annotatedType.getAnnotation(OpenIdAuthenticationMechanismDefinition.class);
        Class annotatedClass = annotatedType.getJavaClass();
        this.addOidcHttpAuthenticationMechanismBean(oidcAnnotation, annotatedClass, annotatedType);
        this.addOidcIdentityStore(beanManager);
        this.addOpenIdContext(beanManager);
    }

    private <T> void addOidcHttpAuthenticationMechanismBean(Annotation annotation, Class<?> annotatedClass, AnnotatedType<T> annotatedType) {
        Properties props = new Properties();
        props.put("oidc_annotation", new OpenIdAuthenticationMechanismDefinitionHolder((OpenIdAuthenticationMechanismDefinition)annotation));
        Set annotations = annotatedType.getAnnotations();
        primarySecurityCDIExtension.addAuthMech(this.applicationName, annotatedClass, OidcHttpAuthenticationMechanism.class, annotations, props);
    }

    private void addOidcIdentityStore(BeanManager beanManager) {
        for (Bean b : this.beansToAdd) {
            if (!OidcIdentityStoreBean.class.equals(b.getClass())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"OidcIdentityStoreBean already registered.", (Object[])new Object[0]);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"adding OidcIdentityStoreBean.", (Object[])new Object[0]);
        }
        this.beansToAdd.add(new OidcIdentityStoreBean(beanManager));
    }

    private void addOpenIdContext(BeanManager beanManager) {
        for (Bean b : this.beansToAdd) {
            if (!OpenIdContextBean.class.equals(b.getClass())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"OpenIdContextBean already registered.", (Object[])new Object[0]);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"adding OpenIdContextBean.", (Object[])new Object[0]);
        }
        this.beansToAdd.add(new OpenIdContextBean(beanManager));
    }

    public void processOidcHttpAuthMechNeeded(@Observes ProcessBeanAttributes<OidcHttpAuthenticationMechanism> processBeanAttributes, BeanManager beanManager) {
        if (!primarySecurityCDIExtension.existAuthMech(this.applicationName, OidcHttpAuthenticationMechanism.class)) {
            processBeanAttributes.veto();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"OidcHttpAuthenticationMechanism is disabled since another HttpAuthorizationMechanism is registered.", (Object[])new Object[0]);
            }
        }
    }

    public <T> void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("afterBeanDiscovery : instance : " + Integer.toHexString(this.hashCode()) + " BeanManager : " + Integer.toHexString(beanManager.hashCode())), (Object[])new Object[0]);
        }
        for (Bean bean : this.beansToAdd) {
            afterBeanDiscovery.addBean(bean);
        }
    }
}

