/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.components;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.spi.JsonbComponentInstanceCreator;

public class BeanManagerInstanceCreator
implements JsonbComponentInstanceCreator {
    private final BeanManager beanManager;
    private final ConcurrentMap<Class<?>, CDIManagedBean<?>> injectionTargets = new ConcurrentHashMap();

    public BeanManagerInstanceCreator(Object beanManager) {
        if (!(beanManager instanceof BeanManager)) {
            throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "beanManager instance should be of type '" + BeanManager.class + "'"));
        }
        this.beanManager = (BeanManager)beanManager;
    }

    @Override
    public <T> T getOrCreateComponent(Class<T> componentClass) {
        return (T)this.injectionTargets.computeIfAbsent(componentClass, clazz -> {
            AnnotatedType aType = this.beanManager.createAnnotatedType(componentClass);
            InjectionTarget injectionTarget = this.beanManager.createInjectionTarget(aType);
            CreationalContext creationalContext = this.beanManager.createCreationalContext(null);
            Object beanInstance = injectionTarget.produce(creationalContext);
            injectionTarget.inject(beanInstance, creationalContext);
            injectionTarget.postConstruct(beanInstance);
            return new CDIManagedBean<Object>(beanInstance, injectionTarget, creationalContext);
        }).getInstance();
    }

    @Override
    public void close() throws IOException {
        this.injectionTargets.forEach((clazz, target) -> this.cleanupBean((CDIManagedBean)target));
        this.injectionTargets.clear();
    }

    private <T> void cleanupBean(CDIManagedBean<T> bean) {
        ((CDIManagedBean)bean).getInjectionTarget().preDestroy(((CDIManagedBean)bean).getInstance());
        ((CDIManagedBean)bean).getInjectionTarget().dispose(((CDIManagedBean)bean).getInstance());
        ((CDIManagedBean)bean).getCreationalContext().release();
    }

    private static final class CDIManagedBean<T> {
        private final T instance;
        private final InjectionTarget<T> injectionTarget;
        private final CreationalContext<T> creationalContext;

        CDIManagedBean(T instance, InjectionTarget<T> injectionTarget, CreationalContext<T> creationalContext) {
            this.instance = instance;
            this.injectionTarget = injectionTarget;
            this.creationalContext = creationalContext;
        }

        private InjectionTarget<T> getInjectionTarget() {
            return this.injectionTarget;
        }

        private T getInstance() {
            return this.instance;
        }

        private CreationalContext<T> getCreationalContext() {
            return this.creationalContext;
        }
    }
}

