/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.common;

import com.ibm.ejs.util.Util;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class XidProxy
implements Xid {
    private static final TraceComponent tc = SibTr.register(XidProxy.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private int formatId;
    private byte[] branchQualifier;
    private byte[] globalTransactionId;

    public XidProxy(Xid xid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.formatId = xid.getFormatId();
        this.branchQualifier = xid.getBranchQualifier();
        this.globalTransactionId = xid.getGlobalTransactionId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)this.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public XidProxy(int formatId, byte[] globalTransactionId, byte[] branchQualifier) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.formatId = formatId;
        if (branchQualifier != null) {
            this.branchQualifier = new byte[branchQualifier.length];
            System.arraycopy(branchQualifier, 0, this.branchQualifier, 0, this.branchQualifier.length);
        }
        if (globalTransactionId != null) {
            this.globalTransactionId = new byte[globalTransactionId.length];
            System.arraycopy(globalTransactionId, 0, this.globalTransactionId, 0, this.globalTransactionId.length);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)this.toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getBranchQualifier() {
        byte[] result = new byte[this.branchQualifier.length];
        System.arraycopy(this.branchQualifier, 0, result, 0, result.length);
        return result;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        byte[] result = new byte[this.globalTransactionId.length];
        System.arraycopy(this.globalTransactionId, 0, result, 0, result.length);
        return result;
    }

    public boolean equals(Object anOther) {
        if (anOther == null) {
            return false;
        }
        if (!(anOther instanceof XidProxy)) {
            return false;
        }
        XidProxy otherXid = (XidProxy)anOther;
        if (this.formatId != otherXid.getFormatId()) {
            return false;
        }
        if (!Arrays.equals(this.branchQualifier, otherXid.getBranchQualifier())) {
            return false;
        }
        return Arrays.equals(this.globalTransactionId, otherXid.getGlobalTransactionId());
    }

    public int hashCode() {
        if (this.branchQualifier.length < 4) {
            return 0;
        }
        int offset = this.branchQualifier.length - 4;
        return ((0xFF & this.branchQualifier[offset + 0]) << 24) + ((0xFF & this.branchQualifier[offset + 1]) << 16) + ((0xFF & this.branchQualifier[offset + 2]) << 8) + ((0xFF & this.branchQualifier[offset + 3]) << 0);
    }

    public String toString() {
        return "JS Comms Xid: Format(" + this.formatId + "), Branch Qualifier[" + Util.toHexString((byte[])this.branchQualifier) + "], Global Transaction ID[" + Util.toHexString((byte[])this.globalTransactionId) + "]";
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/common/XidProxy.java, SIB.comms, WASX.SIB, uu1215.01 1.20");
        }
    }
}

