/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.jbatch.cdi;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIServiceUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.jbatch.cdi.BatchProducerBean;
import io.openliberty.jbatch.cdi.JobOpProducerBean;
import jakarta.batch.operations.JobOperator;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class BatchCDIInjectionExtension
implements Extension {
    private static final Logger logger = Logger.getLogger(BatchCDIInjectionExtension.class.getName());
    private Boolean foundJobOp;
    static final long serialVersionUID = -8204318257791450381L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchCDIInjectionExtension() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.jbatch.cdi.BatchCDIInjectionExtension", "<init>", new Object[0]);
        }
        this.foundJobOp = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.jbatch.cdi.BatchCDIInjectionExtension", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.jbatch.cdi.BatchCDIInjectionExtension", "beforeBeanDiscovery", new Object[]{bbd, bm});
        }
        AnnotatedType at = bm.createAnnotatedType(BatchProducerBean.class);
        bbd.addAnnotatedType(at, CDIServiceUtils.getAnnotatedTypeIdentifier((AnnotatedType)at, this.getClass()));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.jbatch.cdi.BatchCDIInjectionExtension", "beforeBeanDiscovery");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <A> void processBean(@Observes ProcessBean<A> processBeanEvent) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.jbatch.cdi.BatchCDIInjectionExtension", "processBean", new Object[]{processBeanEvent});
        }
        if (!this.foundJobOp.booleanValue() && processBeanEvent.getBean().getTypes().contains(JobOperator.class)) {
            if (processBeanEvent.getBean().getBeanClass().equals(JobOpProducerBean.class)) {
                logger.log(Level.FINE, "BatchCDIInjectionExtension.processBean() detecting our own JobOpProducerBean");
            } else {
                logger.log(Level.FINE, "BatchCDIInjectionExtension.processBean() Found JobOperator of class: " + String.valueOf(processBeanEvent.getBean().getBeanClass()));
                this.foundJobOp = true;
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.jbatch.cdi.BatchCDIInjectionExtension", "processBean");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("io.openliberty.jbatch.cdi.BatchCDIInjectionExtension", "afterBeanDiscovery", new Object[]{abd, bm});
        }
        if (this.foundJobOp.booleanValue()) {
            logger.log(Level.FINE, "Deferring to other detected JobOperator Bean");
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("io.openliberty.jbatch.cdi.BatchCDIInjectionExtension", "afterBeanDiscovery");
            }
            return;
        }
        logger.log(Level.FINE, "Didn't find JobOperator Bean, registering JBatch one");
        abd.addBean((Bean)new JobOpProducerBean(bm));
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("io.openliberty.jbatch.cdi.BatchCDIInjectionExtension", "afterBeanDiscovery");
        }
    }
}

