/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.util.MediaTypeHelper;

public class ServletUtil {
    public static ResteasyUriInfo extractUriInfo(HttpServletRequest request, String servletPrefix) {
        String encodedContextPath;
        String queryString;
        String absolute;
        Object contextPath = request.getContextPath();
        if (servletPrefix != null && servletPrefix.length() > 0 && !servletPrefix.equals("/")) {
            if (!((String)contextPath).endsWith("/") && !servletPrefix.startsWith("/")) {
                contextPath = (String)contextPath + "/";
            }
            contextPath = (String)contextPath + servletPrefix;
        }
        if (!(absolute = (queryString = request.getQueryString()) != null && queryString.length() > 0 ? request.getRequestURL().append('?').append(queryString).toString() : request.getRequestURL().toString()).contains((CharSequence)contextPath) && absolute.contains(encodedContextPath = Arrays.stream(((String)contextPath).substring(1).split("/")).map(s -> {
            try {
                return URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                return s;
            }
        }).collect(Collectors.joining("/", "/", "")))) {
            absolute = absolute.replace(encodedContextPath, (CharSequence)contextPath);
        }
        return new ResteasyUriInfo(absolute, (String)contextPath);
    }

    public static ResteasyHttpHeaders extractHttpHeaders(HttpServletRequest request) {
        MultivaluedMap<String, String> requestHeaders = ServletUtil.extractRequestHeaders(request);
        ResteasyHttpHeaders headers = new ResteasyHttpHeaders(requestHeaders);
        String contentType = request.getContentType();
        if (contentType != null) {
            headers.getMutableHeaders().putSingle((Object)"Content-Type", (Object)contentType);
        }
        Map<String, Cookie> cookies = ServletUtil.extractCookies(request);
        headers.setCookies(cookies);
        headers.testParsing();
        return headers;
    }

    static Map<String, Cookie> extractCookies(HttpServletRequest request) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        if (request.getCookies() != null) {
            for (jakarta.servlet.http.Cookie cookie : request.getCookies()) {
                Cookie ck1 = ((Cookie.Builder)((Cookie.Builder)((Cookie.Builder)((Cookie.Builder)new Cookie.Builder(cookie.getName()).value(cookie.getValue())).path(cookie.getPath())).domain(cookie.getDomain())).version(cookie.getVersion())).build();
                cookies.put(cookie.getName(), ck1);
            }
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get((Object)"Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader(accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get((Object)"Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMap<String, String> extractRequestHeaders(HttpServletRequest request) {
        Headers<String> requestHeaders = new Headers<String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                requestHeaders.add(headerName, headerValue);
            }
        }
        return requestHeaders;
    }
}

