/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.message;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.HttpTrailersImpl;
import com.ibm.ws.http.channel.internal.cookies.CookieCacheData;
import com.ibm.ws.http.channel.internal.cookies.CookieHeaderByteParser;
import com.ibm.ws.http.netty.message.NettyHeader;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.genericbnf.exception.UnsupportedProtocolVersionException;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.HttpBaseMessage;
import com.ibm.wsspi.http.channel.HttpServiceContext;
import com.ibm.wsspi.http.channel.HttpTrailers;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import com.ibm.wsspi.http.channel.values.ContentEncodingValues;
import com.ibm.wsspi.http.channel.values.ExpectValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.TransferEncodingValues;
import com.ibm.wsspi.http.channel.values.VersionValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.openliberty.http.netty.cookie.CookieDecoder;
import io.openliberty.http.netty.cookie.CookieEncoder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettyBaseMessage
implements HttpBaseMessage,
Externalizable {
    private static final TraceComponent tc = Tr.register(NettyBaseMessage.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    protected static final int SERIALIZATION_V1 = -1091633151;
    protected static final int SERIALIZATION_V2 = -1091633150;
    protected transient int deserializationVersion = -1091633151;
    private boolean inbound = Boolean.FALSE;
    private boolean committed = Boolean.FALSE;
    private int limitOnNumberOfHeaders;
    protected HttpChannelConfig config;
    protected HttpMessage message;
    protected HttpHeaders headers;
    boolean initialized = Boolean.FALSE;
    protected long startTime = 0L;
    protected long endTime = 0L;
    private final Map<HttpHeaderKeys, CookieCacheData> cookieCacheMap = new HashMap<HttpHeaderKeys, CookieCacheData>();
    private transient CookieHeaderByteParser cookieParser;
    private HttpServiceContext serviceContext;
    private int limitOfTokenSize;
    private Map<String, String> headersMap = new HashMap<String, String>();
    private MessageType messageType;
    static final long serialVersionUID = 564145770237616102L;

    protected void init(HttpMessage message, HttpServiceContext serviceContext, HttpChannelConfig config) {
        if (!this.initialized) {
            this.initialized = Boolean.TRUE;
            this.message = message;
            this.headers = message.headers();
            this.config = config;
            this.serviceContext = serviceContext;
            this.limitOnNumberOfHeaders = config.getLimitOnNumberOfHeaders();
            this.limitOfTokenSize = config.getLimitOfFieldSize();
        }
    }

    public MessageType messageType() {
        return this.messageType;
    }

    public MessageType setMessageType(MessageType messageType) {
        this.messageType = messageType;
        return this.messageType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        boolean isTrailer;
        int i;
        int len = input.readInt();
        if (-1091633150 == len) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Deserializing a V2 object", (Object[])new Object[0]);
            }
            this.deserializationVersion = -1091633150;
            len = input.readInt();
        }
        this.headersMap = new HashMap<String, String>();
        int number = input.readInt();
        if (-1091633150 == this.deserializationVersion) {
            for (i = 0; i < number; ++i) {
                this.appendHeader(this.readByteArray(input), this.readByteArray(input));
            }
        } else {
            for (i = 0; i < number; ++i) {
                this.appendHeader((String)input.readObject(), (String)input.readObject());
            }
        }
        try {
            if (-1091633150 == this.deserializationVersion) {
                this.setVersion(this.readByteArray(input));
            } else {
                this.setVersion((String)input.readObject());
            }
        }
        catch (UnsupportedProtocolVersionException i2) {
            void exc;
            FFDCFilter.processException((Throwable)i2, (String)"com.ibm.ws.http.netty.message.NettyBaseMessage", (String)"169", (Object)this, (Object[])new Object[]{input});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unknown HTTP version", (Object[])new Object[0]);
            }
            IOException ioe = new IOException("Failed deserialization of version");
            ioe.initCause((Throwable)exc);
            throw ioe;
        }
        boolean bl = -1091633150 == this.deserializationVersion ? input.readBoolean() : (isTrailer = 1 == input.readByte());
        if (isTrailer) {
            // empty if block
        }
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_COOKIE));
        this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_COOKIE2));
        this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_SET_COOKIE));
        this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_SET_COOKIE2));
        output.writeInt(-1091633150);
        output.writeInt(this.headersMap.size());
        output.writeInt(this.headersMap.size());
        for (Map.Entry<String, String> entry : this.headersMap.entrySet()) {
            this.writeByteArray(output, entry.getKey().getBytes());
            this.writeByteArray(output, entry.getValue().getBytes());
        }
        this.writeByteArray(output, this.getVersionValue().getByteArray());
    }

    protected byte[] readByteArray(ObjectInput input) throws IOException {
        int length = input.readInt();
        byte[] data = new byte[length];
        input.readFully(data);
        return data;
    }

    protected void writeByteArray(ObjectOutput output, byte[] data) throws IOException {
        output.writeInt(data.length);
        output.write(data);
    }

    @Override
    public void setDebugContext(Object o) {
        throw new UnsupportedOperationException("setDebugContext unsupported in Netty context");
    }

    @Override
    public HeaderField getHeader(String name) {
        return new NettyHeader(name, this.headers);
    }

    @Override
    public HeaderField getHeader(byte[] name) {
        return this.getHeader(new String(name, StandardCharsets.UTF_8));
    }

    @Override
    public HeaderField getHeader(HeaderKeys name) {
        return new NettyHeader(name, this.headers);
    }

    @Override
    public List<HeaderField> getHeaders(String name) {
        List values = this.headers.getAll(name);
        ArrayList<HeaderField> result = new ArrayList<HeaderField>();
        for (String value : values) {
            result.add(new NettyHeader(name, value));
        }
        return result;
    }

    @Override
    public List<HeaderField> getHeaders(byte[] name) {
        return this.getHeaders(new String(name, StandardCharsets.UTF_8));
    }

    @Override
    public List<HeaderField> getHeaders(HeaderKeys name) {
        return this.getHeaders(name.getName());
    }

    @Override
    public List<HeaderField> getAllHeaders() {
        List entries = this.headers.entries();
        ArrayList<HeaderField> headers = new ArrayList<HeaderField>();
        for (Map.Entry entry : entries) {
            headers.add(new NettyHeader((String)entry.getKey(), (String)entry.getValue()));
        }
        return headers;
    }

    @Override
    public List<String> getAllHeaderNames() {
        return new ArrayList<String>(this.headers.names());
    }

    @Override
    public Set<String> getAllHeaderNamesSet() {
        return this.headers.names();
    }

    @Override
    public void appendHeader(byte[] header, byte[] value) {
        this.appendHeader(new String(header, StandardCharsets.UTF_8), new String(value, StandardCharsets.UTF_8));
    }

    @Override
    public void appendHeader(byte[] header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("appendHeader(2) not supported in Netty context");
    }

    @Override
    public void appendHeader(byte[] header, String value) {
        this.appendHeader(new String(header, StandardCharsets.UTF_8), value);
    }

    @Override
    public void appendHeader(HeaderKeys header, byte[] value) {
        this.appendHeader(header, new String(value, StandardCharsets.UTF_8));
    }

    @Override
    public void appendHeader(HeaderKeys header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("appendHeader(5) not supported in Netty context");
    }

    @Override
    public void appendHeader(HeaderKeys header, String value) {
        this.appendHeader(header.getName(), value);
    }

    @Override
    public void appendHeader(String header, byte[] value) {
        this.appendHeader(header, new String(value, StandardCharsets.UTF_8));
    }

    @Override
    public void appendHeader(String header, byte[] value, int offset, int length) {
        throw new UnsupportedOperationException("appendHeader(8) not supported in Netty context");
    }

    @Override
    public void appendHeader(String header, String value) {
        this.headers.add(header, (Object)value);
    }

    @Override
    public int getNumberOfHeaderInstances(String header) {
        return this.headers.getAll(header).size();
    }

    @Override
    public boolean containsHeader(byte[] header) {
        return this.containsHeader(new String(header, StandardCharsets.UTF_8));
    }

    @Override
    public boolean containsHeader(HeaderKeys header) {
        return this.containsHeader(header.getName());
    }

    @Override
    public boolean containsHeader(String header) {
        return this.headers.contains(header);
    }

    @Override
    public int getNumberOfHeaderInstances(byte[] header) {
        return this.getNumberOfHeaderInstances(new String(header, StandardCharsets.UTF_8));
    }

    @Override
    public int getNumberOfHeaderInstances(HeaderKeys header) {
        return this.getNumberOfHeaderInstances(header.getName());
    }

    @Override
    public void removeHeader(byte[] header) {
        this.removeHeader(new String(header, StandardCharsets.UTF_8));
    }

    @Override
    public void removeHeader(byte[] header, int instance) {
    }

    @Override
    public void removeHeader(HeaderKeys header) {
        this.removeHeader(header.getName());
    }

    @Override
    public void removeHeader(HeaderKeys header, int instance) {
    }

    @Override
    public void removeHeader(String header) {
        this.headers.remove(header);
    }

    @Override
    public void removeHeader(String header, int instance) {
    }

    @Override
    public void removeAllHeaders() {
        this.headers.clear();
    }

    @Override
    public void setHeader(byte[] header, byte[] value) {
    }

    @Override
    public void setHeader(byte[] header, byte[] value, int offset, int length) {
    }

    @Override
    public void setHeader(byte[] header, String value) {
    }

    @Override
    public void setHeader(HeaderKeys header, byte[] value) {
    }

    @Override
    public void setHeader(HeaderKeys header, byte[] value, int offset, int length) {
    }

    @Override
    public void setHeader(HeaderKeys header, String value) {
        this.setHeader(header.getName(), value);
    }

    @Override
    public HeaderField setHeaderIfAbsent(HeaderKeys header, String value) {
        Objects.requireNonNull(header);
        Objects.requireNonNull(value);
        if (!this.headers.contains(header.getName())) {
            this.headers.set(header.getName(), (Object)value);
        }
        return null;
    }

    @Override
    public void setHeader(String header, byte[] value) {
    }

    @Override
    public void setHeader(String header, byte[] value, int offset, int length) {
    }

    @Override
    public void setHeader(String header, String value) {
        this.headers.set(header, (Object)value);
    }

    @Override
    public void setLimitOnNumberOfHeaders(int number) {
        this.limitOnNumberOfHeaders = number;
    }

    @Override
    public int getLimitOnNumberOfHeaders() {
        return this.limitOnNumberOfHeaders;
    }

    @Override
    public void setLimitOfTokenSize(int size) {
        this.limitOfTokenSize = size;
    }

    @Override
    public int getLimitOfTokenSize() {
        return this.limitOfTokenSize;
    }

    @Override
    public byte[] getCookieValue(String name) {
        if (name == null) {
            return null;
        }
        HttpCookie cookie = this.getCookie(name);
        if (cookie == null) {
            return null;
        }
        String value = cookie.getValue();
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    protected void getAllCookieValues(String name, HttpHeaderKeys header, List<String> list) {
        if (!this.cookieCacheExists(header) && !this.containsHeader(header)) {
            return;
        }
        CookieCacheData cache = this.getCookieCache(header);
        if (cache.isDirty()) {
            this.parseAllCookies(cache, header);
        }
        cache.getAllCookieValues(name, list);
    }

    @Override
    public HttpCookie getCookie(String name) {
        if (name == null) {
            return null;
        }
        HttpCookie cookie = null;
        if (this.messageType == MessageType.REQUEST) {
            cookie = this.getCookie(name, HttpHeaderKeys.HDR_COOKIE);
            if (cookie == null) {
                cookie = this.getCookie(name, HttpHeaderKeys.HDR_COOKIE2);
            }
        } else if (this.messageType == MessageType.RESPONSE && (cookie = this.getCookie(name, HttpHeaderKeys.HDR_SET_COOKIE)) == null) {
            cookie = this.getCookie(name, HttpHeaderKeys.HDR_SET_COOKIE2);
        }
        return cookie;
    }

    protected HttpCookie getCookie(String name, HttpHeaderKeys header) {
        if (name == null) {
            return null;
        }
        if (!this.isValidCookieHeader(header) && !this.containsHeader(header)) {
            return null;
        }
        CookieCacheData cache = this.getCookieCache(header);
        HttpCookie cookie = cache.getCookie(name);
        if (cookie != null) {
            return cookie;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getCookie --> " + name + " of type " + header.getName() + " not found"), (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public List<HttpCookie> getAllCookies() {
        LinkedList<HttpCookie> list = new LinkedList<HttpCookie>();
        if (this.messageType == MessageType.REQUEST) {
            this.addAllCookies(HttpHeaderKeys.HDR_COOKIE, list);
            this.addAllCookies(HttpHeaderKeys.HDR_COOKIE2, list);
        } else if (this.messageType == MessageType.RESPONSE) {
            this.addAllCookies(HttpHeaderKeys.HDR_SET_COOKIE, list);
            this.addAllCookies(HttpHeaderKeys.HDR_SET_COOKIE2, list);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAllCookies: Found " + list.size() + " cookie(s). Is incoming: " + this.isIncoming()), (Object[])new Object[0]);
        }
        return list;
    }

    @Override
    public List<HttpCookie> getAllCookies(String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        LinkedList<HttpCookie> results = new LinkedList<HttpCookie>();
        if (this.messageType == MessageType.REQUEST) {
            this.addAllCookies(name, HttpHeaderKeys.HDR_COOKIE, results);
            this.addAllCookies(name, HttpHeaderKeys.HDR_COOKIE2, results);
        } else {
            this.addAllCookies(name, HttpHeaderKeys.HDR_SET_COOKIE, results);
            this.addAllCookies(name, HttpHeaderKeys.HDR_SET_COOKIE2, results);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getAllCookies: Found " + results.size() + " cookie(s) matching [" + name + "]. Is incoming: " + this.isIncoming()), (Object[])new Object[0]);
        }
        return results;
    }

    @Override
    public boolean setCookie(HttpCookie cookie, HttpHeaderKeys cookieType) {
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not adding cookie to committed message: " + cookie.getName() + " " + cookieType.getName()), (Object[])new Object[0]);
            }
            return false;
        }
        this.getCookieCache(cookieType).addNewCookie(cookie.clone());
        return true;
    }

    @Override
    public boolean setCookie(String name, String value, HttpHeaderKeys cookieHeader) {
        return this.setCookie(new HttpCookie(name, value), cookieHeader);
    }

    @Override
    @ManualTrace
    public boolean removeCookie(String name, HttpHeaderKeys cookieHeader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeCookie: " + name), (Object[])new Object[0]);
        }
        if (this.isCommitted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Not removing committed cookie: " + name), (Object[])new Object[0]);
            }
            return false;
        }
        HttpCookie cookie = this.getCookie(name, cookieHeader);
        if (cookie == null) {
            return false;
        }
        return this.getCookieCache(cookieHeader).removeCookie(cookie);
    }

    @Override
    public boolean containsCookie(String name, HttpHeaderKeys cookieHeader) {
        boolean result = Boolean.FALSE;
        if (Objects.nonNull(name) && Objects.nonNull(cookieHeader)) {
            result = Objects.nonNull(this.getCookie(name, cookieHeader));
        }
        return result;
    }

    protected CookieCacheData getCookieCache(HttpHeaderKeys header) {
        if (!this.isValidCookieHeader(header)) {
            throw new IllegalArgumentException("Not a recognized cookie header: " + header.getName());
        }
        CookieCacheData cache = this.cookieCacheMap.computeIfAbsent(header, h -> new CookieCacheData((HttpHeaderKeys)h));
        this.parseNewCookieLinesIfNeeded(cache);
        return cache;
    }

    private boolean isValidCookieHeader(HttpHeaderKeys header) {
        return header == HttpHeaderKeys.HDR_COOKIE || header == HttpHeaderKeys.HDR_COOKIE2 || header == HttpHeaderKeys.HDR_SET_COOKIE || header == HttpHeaderKeys.HDR_SET_COOKIE2;
    }

    private void parseAllCookies(CookieCacheData cache, HttpHeaderKeys header) {
        List<HeaderField> headerList;
        int size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing all cookies for " + header.getName()), (Object[])new Object[0]);
        }
        if ((size = (headerList = this.getHeaders(header)).size()) == 0) {
            return;
        }
        for (int i = cache.getHeaderIndex(); i < size; ++i) {
            String headerValue = headerList.get(i).asString();
            cache.addParsedCookies(CookieDecoder.decode(headerValue, header));
            cache.incrementHeaderIndex();
        }
    }

    @Override
    public List<String> getAllCookieValues(String name) {
        return null;
    }

    @Override
    public boolean isIncoming() {
        return this.inbound;
    }

    public void incoming(boolean isInbound) {
        this.inbound = isInbound;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public void setCommitted() {
        this.committed = Boolean.TRUE;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    @Override
    public void clear() {
        this.cookieCacheMap.clear();
        this.committed = false;
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public boolean isBodyExpected() {
        if (this.isChunkedEncodingSet()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Msg says chunked encoding: " + this), (Object[])new Object[0]);
            }
            return true;
        }
        if (0L < this.getContentLength()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Msg says content-length: " + this.getContentLength() + " " + this), (Object[])new Object[0]);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("No body expected at base layer: " + this), (Object[])new Object[0]);
        }
        return false;
    }

    @Override
    public boolean isBodyAllowed() {
        return 0L != this.getContentLength();
    }

    @Override
    public void setContentLength(long length) {
        if (HttpUtil.isTransferEncodingChunked((HttpMessage)this.message)) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.message, (boolean)false);
        }
        HttpUtil.setContentLength((HttpMessage)this.message, (long)length);
    }

    @Override
    public long getContentLength() {
        return HttpUtil.isContentLengthSet((HttpMessage)this.message) ? HttpUtil.getContentLength((HttpMessage)this.message) : -1L;
    }

    @Override
    public void setConnection(ConnectionValues value) {
    }

    @Override
    public void setConnection(ConnectionValues[] values) {
    }

    @Override
    public ConnectionValues[] getConnection() {
        return null;
    }

    @Override
    public boolean isKeepAliveSet() {
        return HttpUtil.isKeepAlive((HttpMessage)this.message);
    }

    @Override
    public boolean isConnectionSet() {
        return this.containsHeader(HttpHeaderKeys.HDR_CONNECTION);
    }

    @Override
    public void setContentEncoding(ContentEncodingValues value) {
    }

    @Override
    public void setContentEncoding(ContentEncodingValues[] values) {
    }

    @Override
    public ContentEncodingValues[] getContentEncoding() {
        return null;
    }

    @Override
    public void setTransferEncoding(TransferEncodingValues value) {
        throw new UnsupportedOperationException("Tried setting transfer encoding in Netty!");
    }

    @Override
    public void setTransferEncoding(TransferEncodingValues[] values) {
        throw new UnsupportedOperationException("Tried setting transfer encoding in Netty!");
    }

    @Override
    public TransferEncodingValues[] getTransferEncoding() {
        return null;
    }

    @Override
    public boolean isChunkedEncodingSet() {
        return HttpUtil.isTransferEncodingChunked((HttpMessage)this.message);
    }

    @Override
    public void setCurrentDate() {
    }

    @Override
    public void setExpect(ExpectValues value) {
    }

    @Override
    public byte[] getExpect() {
        return null;
    }

    @Override
    public boolean isExpect100Continue() {
        return HttpUtil.is100ContinueExpected((HttpMessage)this.message);
    }

    @Override
    public String getMIMEType() {
        return HttpUtil.getMimeType((HttpMessage)this.message).toString();
    }

    @Override
    public void setMIMEType(String type) {
    }

    @Override
    public Charset getCharset() {
        return null;
    }

    @Override
    public void setCharset(Charset set) {
    }

    @Override
    public HttpTrailers getTrailers() {
        return null;
    }

    @Override
    public VersionValues getVersionValue() {
        if (this.message.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text())) {
            return VersionValues.V20;
        }
        return VersionValues.find(this.message.protocolVersion().text());
    }

    @Override
    public String getVersion() {
        if (this.message.headers().contains((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text())) {
            return VersionValues.V20.getName();
        }
        return this.message.protocolVersion().text();
    }

    @Override
    public void setVersion(VersionValues version) {
    }

    @Override
    public void setVersion(String version) throws UnsupportedProtocolVersionException {
    }

    @Override
    public void setVersion(byte[] version) throws UnsupportedProtocolVersionException {
    }

    @Override
    public HttpTrailersImpl createTrailers() {
        return null;
    }

    public void processCookies() {
        if (MessageType.REQUEST == this.messageType) {
            this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_COOKIE));
            this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_COOKIE2));
        } else if (MessageType.RESPONSE == this.messageType) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking to see if we should mark the cookie cache as dirty - samesite is " + this.config.useSameSiteConfig() + " doNotAllowDuplicateSetCookie is " + this.config.doNotAllowDuplicateSetCookies()), (Object[])new Object[0]);
            }
            if (this.config.useSameSiteConfig() || this.config.doNotAllowDuplicateSetCookies()) {
                if (this.containsHeader(HttpHeaderKeys.HDR_SET_COOKIE)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Marking set-cookie cache dirty", (Object[])new Object[0]);
                    }
                    this.getCookieCache(HttpHeaderKeys.HDR_SET_COOKIE).setIsDirty(true);
                }
                if (this.containsHeader(HttpHeaderKeys.HDR_SET_COOKIE2)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Marking set-cookie2 cache dirty", (Object[])new Object[0]);
                    }
                    this.getCookieCache(HttpHeaderKeys.HDR_SET_COOKIE2).setIsDirty(true);
                }
            }
            this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_SET_COOKIE));
            this.marshallCookieCache(this.cookieCacheMap.get(HttpHeaderKeys.HDR_SET_COOKIE2));
        }
    }

    protected void marshallCookieCache(CookieCacheData cache) {
        if (cache == null || !cache.isDirty()) {
            return;
        }
        HttpHeaderKeys type = cache.getHeaderType();
        this.parseNewCookieLinesIfNeeded(cache);
        this.removeHeader(type);
        this.marshallCookies(cache.getParsedList(), type);
        cache.setIsDirty(false);
    }

    @ManualTrace
    private void marshallCookies(List<HttpCookie> list, HeaderKeys header) {
        boolean filterDuplicates;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"marshallCookies", (Object[])new Object[0]);
        }
        HashMap<String, String> setCookieNames = null;
        boolean bl = filterDuplicates = this.config.doNotAllowDuplicateSetCookies() && (header == HttpHeaderKeys.HDR_SET_COOKIE || header == HttpHeaderKeys.HDR_SET_COOKIE2);
        if (filterDuplicates) {
            setCookieNames = new HashMap<String, String>();
        }
        String userAgent = null;
        if (this.getServiceContext() != null && this.getServiceContext().getRequest() != null) {
            userAgent = this.getServiceContext().getRequest().getHeader(HttpHeaderKeys.HDR_USER_AGENT).asString();
        }
        for (HttpCookie cookie : list) {
            String value = CookieEncoder.encodeCookie(cookie, header, this.config, userAgent);
            if (null == value) continue;
            if (filterDuplicates) {
                setCookieNames.put(cookie.getName(), value);
                continue;
            }
            this.appendHeader(header, value);
        }
        if (filterDuplicates && setCookieNames != null) {
            this.removeHeader(header.getName());
            for (String headerValue : setCookieNames.values()) {
                this.appendHeader(header, headerValue);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"marshallCookies");
        }
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public HttpServiceContext getServiceContext() {
        return this.serviceContext;
    }

    private boolean shouldParseCookieHeader(HttpHeaderKeys header) {
        if (header == HttpHeaderKeys.HDR_COOKIE || header == HttpHeaderKeys.HDR_COOKIE2) {
            return this.messageType == MessageType.REQUEST && this.isIncoming();
        }
        return this.messageType == MessageType.RESPONSE && this.isIncoming();
    }

    protected boolean cookieCacheExists(HttpHeaderKeys header) {
        return this.cookieCacheMap.containsKey(header);
    }

    private void parseNewCookieLinesIfNeeded(CookieCacheData cache) {
        if (!this.shouldParseCookieHeader(cache.getHeaderType())) {
            return;
        }
        HttpHeaderKeys header = cache.getHeaderType();
        List<HeaderField> fields = this.getHeaders(header);
        int size = fields.size();
        for (int i = cache.getHeaderIndex(); i < size; ++i) {
            String lineValue = fields.get(i).asString();
            List<HttpCookie> decoded = CookieDecoder.decode(lineValue, header);
            cache.addParsedCookies(decoded);
            cache.incrementHeaderIndex();
        }
    }

    protected void addAllCookies(HttpHeaderKeys header, List<HttpCookie> list) {
        if (!this.containsHeader(header) && !this.cookieCacheExists(header)) {
            return;
        }
        CookieCacheData cache = this.getCookieCache(header);
        cache.getAllCookies(list);
    }

    protected void addAllCookies(String name, HttpHeaderKeys header, List<HttpCookie> list) {
        if (!this.containsHeader(header) && !this.cookieCacheExists(header)) {
            return;
        }
        CookieCacheData cache = this.getCookieCache(header);
        cache.getAllCookies(name, list);
    }

    public static enum MessageType {
        REQUEST,
        RESPONSE;

    }
}

