/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.uow.embeddable;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.jta.embeddable.EmbeddableTransactionManagerFactory;
import com.ibm.tx.jta.embeddable.impl.EmbeddableTransactionImpl;
import com.ibm.tx.jta.embeddable.impl.EmbeddableUserTransactionImpl;
import com.ibm.tx.jta.impl.UserTransactionImpl;
import com.ibm.tx.ltc.impl.LocalTranCoordImpl;
import com.ibm.tx.ltc.impl.LocalTranCurrentSet;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.UOWCallback;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.tx.jta.embeddable.UserTransactionController;
import com.ibm.ws.uow.UOWScope;
import com.ibm.ws.uow.UOWScopeCallback;
import com.ibm.ws.uow.UOWScopeCallbackManager;
import com.ibm.ws.uow.embeddable.EmbeddableUOWTokenImpl;
import com.ibm.ws.uow.embeddable.SynchronizationRegistryUOWScope;
import com.ibm.ws.uow.embeddable.SystemException;
import com.ibm.ws.uow.embeddable.UOWCallbackManager;
import com.ibm.ws.uow.embeddable.UOWManager;
import com.ibm.ws.uow.embeddable.UOWToken;
import com.ibm.wsspi.uow.ExtendedUOWAction;
import com.ibm.wsspi.uow.UOWAction;
import com.ibm.wsspi.uow.UOWActionException;
import com.ibm.wsspi.uow.UOWException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;

public class EmbeddableUOWManagerImpl
implements UOWManager,
UOWScopeCallback,
UserTransactionController {
    private static final TraceComponent tc = Tr.register(EmbeddableUOWManagerImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected UOWScopeCallbackManager _callbackManager;
    protected UOWCallbackManager _runUnderUOWCallbackManager;

    @Override
    public UOWToken suspend() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspend", (Object[])new Object[0]);
        }
        Transaction transaction = null;
        LocalTransactionCoordinator localTranCoord = null;
        try {
            transaction = EmbeddableTransactionManagerFactory.getTransactionManager().suspend();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.uow.UOWManagerImpl.suspend", (String)"109", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Exception caught suspending transaction", (Object[])new Object[]{e});
            }
            SystemException se = new SystemException(e);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"suspend", (Object)se);
            }
            throw se;
        }
        if (transaction == null) {
            localTranCoord = EmbeddableTransactionManagerFactory.getLocalTransactionCurrent().suspend();
        }
        EmbeddableUOWTokenImpl uowToken = null;
        if (transaction != null || localTranCoord != null) {
            uowToken = new EmbeddableUOWTokenImpl(transaction, localTranCoord);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspend", (Object)uowToken);
        }
        return uowToken;
    }

    @Override
    public UOWToken suspendAll() throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspendAll", (Object[])new Object[0]);
        }
        UOWToken uowToken = this.suspend();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspendAll", (Object)uowToken);
        }
        return uowToken;
    }

    @Override
    public void resume(UOWToken uowToken) throws IllegalThreadStateException, IllegalArgumentException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resume", (Object[])new Object[]{uowToken});
        }
        if (uowToken != null && uowToken instanceof EmbeddableUOWTokenImpl) {
            LocalTransactionCoordinator localTranCoord;
            EmbeddableUOWTokenImpl uowTokenImpl = (EmbeddableUOWTokenImpl)uowToken;
            Transaction transaction = uowTokenImpl.getTransaction();
            if (transaction != null) {
                try {
                    EmbeddableTransactionManagerFactory.getTransactionManager().resume(transaction);
                }
                catch (InvalidTransactionException ite) {
                    FFDCFilter.processException((Throwable)ite, (String)"com.ibm.ws.uow.UOWManagerImpl.resume", (String)"212", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"InvalidTransactionException caught resuming transaction", (Object[])new Object[]{ite});
                    }
                    IllegalArgumentException iae = new IllegalArgumentException();
                    iae.initCause(ite);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"resume", (Object)((Object)ite));
                    }
                    throw iae;
                }
                catch (IllegalStateException ise) {
                    FFDCFilter.processException((Throwable)ise, (String)"com.ibm.ws.uow.UOWManagerImpl.resume", (String)"223", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"IllegalStateException caught resuming transaction", (Object[])new Object[]{ise});
                    }
                    IllegalThreadStateException itse = new IllegalThreadStateException();
                    itse.initCause(itse);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"resume", (Object)itse);
                    }
                    throw itse;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.uow.UOWManagerImpl.resume", (String)"234", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Exception caught resuming transaction", (Object[])new Object[]{e});
                    }
                    SystemException se = new SystemException(e);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"resume", (Object)se);
                    }
                    throw se;
                }
            }
            if ((localTranCoord = uowTokenImpl.getLocalTransactionCoordinator()) != null) {
                try {
                    EmbeddableTransactionManagerFactory.getLocalTransactionCurrent().resume(localTranCoord);
                }
                catch (IllegalStateException ise) {
                    FFDCFilter.processException((Throwable)ise, (String)"com.ibm.ws.uow.UOWManagerImpl.resume", (String)"254", (Object)this);
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"IllegalStateException caught resuming LTC", (Object[])new Object[]{ise});
                    }
                    IllegalThreadStateException itse = new IllegalThreadStateException();
                    itse.initCause(ise);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"resume", (Object)itse);
                    }
                    throw itse;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resume");
        }
    }

    @Override
    public void resumeAll(UOWToken uowToken) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resumeAll", (Object[])new Object[]{uowToken});
        }
        if (uowToken != null) {
            this.resume(uowToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resumeAll");
        }
    }

    @Override
    public synchronized void registerCallback(UOWScopeCallback callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerCallback", (Object[])new Object[]{callback, this});
        }
        if (this._callbackManager == null) {
            this._callbackManager = new UOWScopeCallbackManager();
            EmbeddableTransactionManagerFactory.getTransactionManager().registerCallback(this);
            EmbeddableTransactionManagerFactory.getLocalTransactionCurrent().registerCallback((UOWScopeCallback)this);
        }
        this._callbackManager.addCallback(callback);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    @Override
    public synchronized void registerRunUnderUOWCallback(UOWCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerRunUnderUOWCallback", (Object[])new Object[]{callback, this});
        }
        if (this._runUnderUOWCallbackManager == null) {
            this._runUnderUOWCallbackManager = new UOWCallbackManager();
        }
        this._runUnderUOWCallbackManager.addCallback(callback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerRunUnderUOWCallback");
        }
    }

    @Override
    public UOWScope getUOWScope() throws SystemException {
        UOWScope uowScope;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWScope", (Object[])new Object[]{this});
        }
        if ((uowScope = (UOWScope)EmbeddableTransactionManagerFactory.getLocalTransactionCurrent().getLocalTranCoord()) == null) {
            try {
                uowScope = (UOWScope)EmbeddableTransactionManagerFactory.getTransactionManager().getTransaction();
            }
            catch (jakarta.transaction.SystemException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.uow.UOWManagerImpl.getUOWScope", (String)"364", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"SystemException caught checking for transaction", (Object[])new Object[]{se});
                }
                SystemException systemException = new SystemException(se);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUOWScope", (Object)systemException);
                }
                throw systemException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWScope", (Object)uowScope);
        }
        return uowScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runUnderUOW(int uowType, boolean join, UOWAction uowAction) throws UOWActionException, UOWException {
        Throwable toThrow;
        block26: {
            UOWScope initialUOWScope;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"runUnderUOW", (Object[])new Object[]{uowType, join, uowAction});
            }
            try {
                initialUOWScope = this.getUOWScope();
            }
            catch (SystemException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.uow.UOWManagerImpl.runUnderUOW", (String)"96", (Object)this);
                UOWException uowe = new UOWException(e);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"runUnderUOW", (Object)e);
                }
                throw uowe;
            }
            UOWToken uowt = null;
            if (!(initialUOWScope == null || join && uowType != 0 && uowType == this.getUOWType())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Need to suspend current UOW", (Object[])new Object[0]);
                }
                try {
                    uowt = this.suspend();
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.spi.uow.UOWManagerImpl.runUnderUOW", (String)"81", (Object)this);
                    UOWException uowe = new UOWException(t);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"runUnderUOW", (Object)uowe);
                    }
                    throw uowe;
                }
            }
            toThrow = null;
            try {
                try {
                    if (this.getUOWScope() == null) {
                        toThrow = this.runUnderNewUOW(uowType, uowAction);
                        break block26;
                    }
                    toThrow = this.runUnderCurrentUOW(uowAction);
                }
                catch (SystemException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.uow.PreviewUOWManagerImpl.run", (String)"138", (Object)this);
                    toThrow = new UOWException(e);
                }
            }
            finally {
                block27: {
                    try {
                        this.resume(uowt);
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.spi.uow.UOWManagerImpl.runUnderUOW", (String)"107", (Object)this);
                        if (toThrow != null) break block27;
                        toThrow = new UOWException(t);
                    }
                }
            }
        }
        if (toThrow instanceof UOWException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"runUnderUOW", (Object)toThrow);
            }
            throw (UOWException)toThrow;
        }
        if (toThrow instanceof UOWActionException) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"runUnderUOW", (Object)toThrow);
            }
            throw (UOWActionException)toThrow;
        }
        if (toThrow instanceof RuntimeException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"runUnderUOW");
            }
            throw (RuntimeException)toThrow;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"runUnderUOW");
        }
    }

    @Override
    public long getUOWExpiration() throws IllegalStateException {
        long expiration;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWExpiration", (Object[])new Object[]{this});
        }
        int uowType = this.getUOWType();
        switch (uowType) {
            case 1: {
                try {
                    expiration = ((EmbeddableTransactionImpl)this.getUOWScope()).getExpirationTime();
                    break;
                }
                catch (SystemException e) {
                    IllegalStateException ise = new IllegalStateException(e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getUOWExpiration", (Object)ise);
                    }
                    throw ise;
                }
            }
            default: {
                IllegalStateException ise = new IllegalStateException("Invalid UOW type: " + uowType);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUOWExpiration", (Object)ise);
                }
                throw ise;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWExpiration", (Object)expiration);
        }
        return expiration;
    }

    @Override
    public int getUOWTimeout() throws IllegalStateException {
        int timeout;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWTimeout", (Object[])new Object[]{this});
        }
        int uowType = this.getUOWType();
        switch (uowType) {
            case 1: {
                try {
                    timeout = ((EmbeddableTransactionImpl)this.getUOWScope()).getTimeout();
                    break;
                }
                catch (SystemException e) {
                    IllegalStateException ise = new IllegalStateException(e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"getUOWTimeout", (Object)ise);
                    }
                    throw ise;
                }
            }
            default: {
                IllegalStateException ise = new IllegalStateException("Invalid UOW type: " + uowType);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getUOWTimeout", (Object)ise);
                }
                throw ise;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWTimeout", (Object)timeout);
        }
        return timeout;
    }

    @Override
    public void setUOWTimeout(int uowType, int timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setUOWTimeout", (Object[])new Object[]{uowType, timeout});
        }
        switch (uowType) {
            case 1: {
                try {
                    EmbeddableTransactionManagerFactory.getTransactionManager().setTransactionTimeout(timeout);
                    break;
                }
                catch (Exception e) {
                    IllegalArgumentException iae = new IllegalArgumentException(e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"setUOWTimeout", (Object)iae);
                    }
                    throw iae;
                }
            }
            default: {
                IllegalArgumentException iae = new IllegalArgumentException("Invalid UOW type: " + uowType);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"setUOWTimeout", (Object)iae);
                }
                throw iae;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setUOWTimeout");
        }
    }

    @Override
    public long getLocalUOWId() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalUOWId", (Object[])new Object[]{this});
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            throw new IllegalStateException();
        }
        long localId = uowScope.getLocalId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalUOWId", (Object)localId);
        }
        return localId;
    }

    @Override
    public Object getResource(Object key) throws NullPointerException {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResource", (Object[])new Object[]{key, this});
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResource", (Object)"IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResource", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        Object resource = uowScope.getResource(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResource", (Object)resource);
        }
        return resource;
    }

    @Override
    public boolean getRollbackOnly() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRollbackOnly", (Object[])new Object[]{this});
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRollbackOnly", (Object)"IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getRollbackOnly", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        boolean rollbackOnly = uowScope.getRollbackOnly();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRollbackOnly", (Object)rollbackOnly);
        }
        return rollbackOnly;
    }

    @Override
    public int getUOWStatus() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWStatus", (Object[])new Object[]{this});
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUOWStatus", (Object)"IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        int uowStatus = uowScope == null ? 5 : uowScope.getUOWStatus();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWStatus", (Object)this.getUOWStatusAsString(uowStatus));
        }
        return uowStatus;
    }

    @Override
    public int getUOWType() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWType", (Object[])new Object[]{this});
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUOWType", (Object)"IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUOWType", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        int uowType = uowScope.getUOWType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWType", (Object)uowType);
        }
        return uowType;
    }

    @Override
    public void putResource(Object key, Object value) {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"putResource", (Object[])new Object[]{key, value, this});
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"putResource", (Object)"IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"putResource", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        uowScope.putResource(key, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"putResource");
        }
    }

    @Override
    public void registerInterposedSynchronization(Synchronization sync) {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerInterposedSynchronization", (Object[])new Object[]{sync, this});
        }
        if (sync == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerInterposedSynchronization", (Object)"NullPointerException");
            }
            throw new NullPointerException();
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerInterposedSynchronization", (Object)"IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"registerInterposedSynchronization", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        uowScope.registerInterposedSynchronization(sync);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerInterposedSynchronization");
        }
    }

    @Override
    public void setRollbackOnly() {
        SynchronizationRegistryUOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRollbackOnly", (Object[])new Object[]{this});
        }
        try {
            uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
        }
        catch (SystemException se) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setRollbackOnly", (Object)"IllegalStateException");
            }
            throw new IllegalStateException(se);
        }
        if (uowScope == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setRollbackOnly", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        if (uowScope instanceof LocalTranCoordImpl) {
            ((LocalTranCoordImpl)uowScope).setRollbackOnlyFromApplicationCode();
        } else {
            uowScope.setRollbackOnly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRollbackOnly");
        }
    }

    public void contextChange(int changeType, UOWScope uowScope) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contextChange", (Object[])new Object[]{changeType, uowScope, this});
        }
        if (changeType == 1) {
            this._callbackManager.notifyCallbacks(changeType, uowScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable runUnderNewUOW(int uowType, UOWAction uowAction) {
        UOWScope uowScope;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"runUnderNewUOW", (Object[])new Object[]{uowType, uowAction, this});
        }
        Exception toThrow = null;
        try {
            uowScope = this.uowBegin(uowType);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.uow.UOWManagerImpl.runUnderNewUOW", (String)"922", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"runUnderNewUOW", (Object)t);
            }
            return new UOWException(t);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Running UOWAction", (Object[])new Object[0]);
            }
            uowAction.run();
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.uow.UOWManagerImpl.runUnderNewUOW", (String)"934", (Object)this);
            this.setRollbackOnly();
            toThrow = e;
        }
        catch (Exception e) {
            toThrow = new UOWActionException(e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.uow.UOWManagerImpl.runUnderNewUOW", (String)"944", (Object)this);
            this.setRollbackOnly();
            toThrow = new UOWException(t);
        }
        finally {
            try {
                this.uowEnd(uowScope, uowType);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.spi.uow.UOWManagerImpl.runUnderNewUOW", (String)"175", (Object)this);
                UOWException uowe = new UOWException(t);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"runUnderNewUOW", (Object)uowe);
                }
                return uowe;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"runUnderNewUOW", (Object)toThrow);
        }
        return toThrow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uowEnd(UOWScope uowScope, int uowType) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uowEnd", (Object[])new Object[]{uowScope, uowType, this});
        }
        UOWCoordinator uow = EmbeddableTransactionManagerFactory.getUOWCurrent().getUOWCoord();
        try {
            if (this.getRollbackOnly()) {
                boolean timedOut = false;
                int timedOutTime = 0;
                boolean subRollback = false;
                if (uowType == 1) {
                    timedOut = ((EmbeddableTransactionImpl)uowScope).isTimedOut();
                    timedOutTime = ((EmbeddableTransactionImpl)uowScope).getTimeout();
                    subRollback = ((EmbeddableTransactionImpl)uowScope).isSubRollback();
                }
                this.uowRollback(uowType);
                if (timedOut) {
                    RollbackException rbe = new RollbackException("Global transaction timed out after " + timedOutTime + " seconds");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"uowEnd", (Object)((Object)rbe));
                    }
                    throw rbe;
                }
                if (subRollback) {
                    RollbackException rbe = new RollbackException("Global transaction rolledback from client inactivity timeout from subordinate");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"uowEnd", (Object)((Object)rbe));
                    }
                    throw rbe;
                }
            } else {
                this.uowCommit(uowType);
            }
        }
        finally {
            if (this._runUnderUOWCallbackManager != null) {
                this._runUnderUOWCallbackManager.notifyCallbacks(3, uow);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uowEnd");
        }
    }

    protected void uowCommit(int uowType) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uowCommit", (Object[])new Object[]{uowType});
        }
        switch (uowType) {
            case 1: {
                if (ConfigurationProviderManager.getConfigurationProvider().isCorrectUOWScopeCallbacks()) {
                    UserTransactionImpl.instance().commit();
                    break;
                }
                EmbeddableTransactionManagerFactory.getTransactionManager().commit();
                break;
            }
            case 0: {
                LocalTranCurrentSet.instance().end(0);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uowCommit");
        }
    }

    protected void uowRollback(int uowType) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uowRollback", (Object[])new Object[]{uowType});
        }
        switch (uowType) {
            case 1: {
                if (ConfigurationProviderManager.getConfigurationProvider().isCorrectUOWScopeCallbacks()) {
                    UserTransactionImpl.instance().rollback();
                    break;
                }
                EmbeddableTransactionManagerFactory.getTransactionManager().rollback();
                break;
            }
            case 0: {
                LocalTranCurrentSet.instance().end(1);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uowRollback");
        }
    }

    protected UOWScope uowBegin(int uowType) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"uowBegin", (Object[])new Object[]{uowType});
        }
        switch (uowType) {
            case 1: {
                UserTransactionImpl.instance().begin();
                break;
            }
            case 0: {
                LocalTranCurrentSet.instance().begin(false, false, false);
            }
        }
        UOWScope uows = this.getUOWScope();
        if (this._runUnderUOWCallbackManager != null) {
            this._runUnderUOWCallbackManager.notifyCallbacks(1, EmbeddableTransactionManagerFactory.getUOWCurrent().getUOWCoord());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uowBegin", (Object)uows);
        }
        return uows;
    }

    private Throwable runUnderCurrentUOW(UOWAction uowAction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"runUnderCurrentUOW", (Object[])new Object[]{uowAction, this});
        }
        Exception toThrow = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Running UOWAction", (Object[])new Object[0]);
            }
            uowAction.run();
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.uow.UOWManagerImpl.runUnderCurrentUOW", (String)"1130", (Object)this);
            this.setRollbackOnly();
            toThrow = e;
        }
        catch (Exception e) {
            toThrow = new UOWActionException(e);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.uow.UOWManagerImpl.runUnderCurrentUOW", (String)"1140", (Object)this);
            this.setRollbackOnly();
            toThrow = new UOWException(t);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"runUnderCurrentUOW", (Object)toThrow);
        }
        return toThrow;
    }

    protected String getUOWStatusAsString(int status) {
        String uowStatus;
        switch (status) {
            case 0: {
                uowStatus = "active";
                break;
            }
            case 5: {
                uowStatus = "none";
                break;
            }
            case 3: {
                uowStatus = "committed";
                break;
            }
            case 1: {
                uowStatus = "rollback only";
                break;
            }
            case 4: {
                uowStatus = "rolled back";
                break;
            }
            default: {
                uowStatus = "undefined";
            }
        }
        return uowStatus;
    }

    @Override
    public String getUOWName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUOWName", (Object[])new Object[]{this});
        }
        String uowName = null;
        try {
            SynchronizationRegistryUOWScope uowScope = (SynchronizationRegistryUOWScope)this.getUOWScope();
            uowName = uowScope.getUOWName();
        }
        catch (SystemException se) {
            FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.uow.UOWManagerImpl.getUOWName", (String)"1311", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUOWName", (Object)uowName);
        }
        return uowName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object runUnderUOW(int uowType, boolean join, ExtendedUOWAction uowAction, Class<?>[] rollbackOn, Class<?>[] dontRollbackOn) throws Exception, UOWException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"runUnderUOW", (Object[])new Object[]{uowType, join, uowAction, rollbackOn, dontRollbackOn});
        }
        UOWScope initialUOWScope = this.getUOWScope();
        UOWToken uowt = null;
        if (!(initialUOWScope == null || join && uowType != 0 && uowType == this.getUOWType())) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Need to suspend current UOW", (Object[])new Object[0]);
            }
            uowt = this.suspend();
        }
        Object ret = null;
        try {
            ret = this.getUOWScope() == null ? this.runUnderNewUOW(uowType, uowAction, rollbackOn, dontRollbackOn) : this.runUnderCurrentUOW(uowAction, rollbackOn, dontRollbackOn);
        }
        finally {
            this.resume(uowt);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"runUnderUOW", (Object)ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runUnderNewUOW(int uowType, ExtendedUOWAction uowAction, Class<?>[] rollbackOn, Class<?>[] dontRollbackOn) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"runUnderNewUOW", (Object[])new Object[]{uowType, uowAction, this});
        }
        Object ret = null;
        UOWScope uowScope = this.uowBegin(uowType);
        try {
            ret = this.runUnderCurrentUOW(uowAction, rollbackOn, dontRollbackOn);
        }
        finally {
            try {
                this.uowEnd(uowScope, uowType);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.spi.uow.UOWManagerImpl.runUnderNewUOW", (String)"1220", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"runUnderNewUOW");
                }
                throw e;
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.spi.uow.UOWManagerImpl.runUnderNewUOW", (String)"1222", (Object)this);
                UOWException e = new UOWException(t);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"runUnderNewUOW");
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"runUnderNewUOW", (Object)ret);
        }
        return ret;
    }

    private Object runUnderCurrentUOW(ExtendedUOWAction uowAction, Class<?>[] rollbackOn, Class<?>[] dontRollbackOn) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"runUnderCurrentUOW", (Object[])new Object[]{uowAction, this});
        }
        Object ret = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Running UOWAction", (Object[])new Object[0]);
            }
            ret = uowAction.run();
        }
        catch (RuntimeException e) {
            if (!this.in(e, dontRollbackOn)) {
                this.setRollbackOnly();
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.uow.UOWManagerImpl.runUnderCurrentUOW", (String)"1130", (Object)this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"runUnderCurrentUOW", (Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.in(e, rollbackOn)) {
                this.setRollbackOnly();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"runUnderCurrentUOW", (Object)e);
            }
            throw e;
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.uow.UOWManagerImpl.runUnderNewUOW", (String)"1317", (Object)this);
            if (!this.in(t, dontRollbackOn)) {
                this.setRollbackOnly();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"runUnderCurrentUOW", (Object)t);
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error(t);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"runUnderCurrentUOW", (Object)ret);
        }
        return ret;
    }

    private boolean in(Throwable t, Class<?>[] list) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"in", (Object[])new Object[]{t, list});
        }
        if (list != null && t != null) {
            for (Class<?> c : list) {
                if (!c.isAssignableFrom(t.getClass())) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"in", (Object)true);
                }
                return true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"in", (Object)false);
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        return EmbeddableUserTransactionImpl.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        EmbeddableUserTransactionImpl.setEnabled(enabled);
    }
}

