/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.selector.impl;

import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.utils.FFDC;
import java.util.List;

public final class ParseUtil {
    private static final Class cclass = ParseUtil.class;

    private ParseUtil() {
    }

    static Selector parseStringLiteral(String image) {
        return new LiteralImpl(ParseUtil.reduceStringLiteralToken(image));
    }

    private static String reduceStringLiteralToken(String image) {
        image = image.substring(1, image.length() - 1);
        for (int i = 0; i < image.length(); ++i) {
            if (image.charAt(i) != '\'') continue;
            image = image.substring(0, i + 1) + image.substring(i + 2);
        }
        return image;
    }

    static Selector parseIntegerLiteral(String val) {
        char tag = val.charAt(val.length() - 1);
        boolean mustBeLong = false;
        if (tag == 'l' || tag == 'L') {
            val = val.substring(0, val.length() - 1);
            mustBeLong = true;
        }
        long longVal = Long.decode(val);
        if (mustBeLong || longVal > Integer.MAX_VALUE || longVal < Integer.MIN_VALUE) {
            return new LiteralImpl(new Long(longVal));
        }
        return new LiteralImpl(new Integer((int)longVal));
    }

    static Selector parseFloatingLiteral(String val) {
        char tag = val.charAt(val.length() - 1);
        Number value = tag == 'f' || tag == 'F' ? (Number)new Float(val) : (Number)new Double(val);
        return new LiteralImpl(value);
    }

    static Selector convertSet(Selector expr, List set) {
        OperatorImpl ans = null;
        for (int i = 0; i < set.size(); ++i) {
            Selector comparand = (Selector)set.get(i);
            OperatorImpl comparison = new OperatorImpl(45, (Selector)expr.clone(), comparand);
            ans = ans == null ? comparison : new OperatorImpl(47, ans, comparison);
        }
        return ans;
    }

    static Selector convertRange(Selector expr, Selector bound1, Selector bound2) {
        return new OperatorImpl(46, new OperatorImpl(43, (Selector)expr.clone(), bound1), new OperatorImpl(44, (Selector)expr.clone(), bound2));
    }

    static Selector convertLike(Selector arg, String pattern, String escape) {
        try {
            pattern = ParseUtil.reduceStringLiteralToken(pattern);
            boolean escaped = false;
            char esc = '\u0000';
            if (escape != null) {
                if ((escape = ParseUtil.reduceStringLiteralToken(escape)).length() != 1) {
                    return null;
                }
                escaped = true;
                esc = escape.charAt(0);
            }
            return Matching.getInstance().createLikeOperator(arg, pattern, escaped, esc);
        }
        catch (Exception e) {
            FFDC.processException((Class)cclass, (String)"com.ibm.ws.sib.matchspace.selector.impl.ParseUtil.convertLike", (Throwable)e, (String)"1:183:1.19");
            throw new RuntimeException(e);
        }
    }
}

