/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.org.jboss.resteasy.common.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import io.openliberty.org.jboss.resteasy.common.client.JAXRSClientConfigHolder;
import io.openliberty.org.jboss.resteasy.common.client.JAXRSClientConstants;
import io.openliberty.org.jboss.resteasy.common.client.LibertyClientInvocationBuilder;
import io.openliberty.org.jboss.resteasy.common.client.LibertyResteasyClientBuilderImpl;
import io.openliberty.org.jboss.resteasy.common.client.LibertyResteasyClientImpl;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.client.jaxrs.internal.ClientWebTarget;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LibertyClientWebTarget
extends ClientWebTarget {
    private static final TraceComponent tc = Tr.register(LibertyClientWebTarget.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    private final LibertyResteasyClientBuilderImpl builder;
    static final long serialVersionUID = 1249393314054078041L;

    public LibertyClientWebTarget(ResteasyClient client, String uri, ClientConfiguration configuration, LibertyResteasyClientBuilderImpl builder) throws IllegalArgumentException, NullPointerException {
        super(client, uri, configuration);
        this.builder = builder;
        this.applyConfiguredProperties();
    }

    public LibertyClientWebTarget(ResteasyClient client, URI uri, ClientConfiguration configuration, LibertyResteasyClientBuilderImpl builder) throws NullPointerException {
        super(client, uri, configuration);
        this.builder = builder;
        this.applyConfiguredProperties();
    }

    public LibertyClientWebTarget(ResteasyClient client, UriBuilder uriBuilder, ClientConfiguration configuration, LibertyResteasyClientBuilderImpl builder) throws NullPointerException {
        super(client, uriBuilder, configuration);
        this.builder = builder;
        this.applyConfiguredProperties();
    }

    @Override
    protected ClientWebTarget newInstance(ResteasyClient client, UriBuilder uriBuilder, ClientConfiguration configuration) {
        return new LibertyClientWebTarget(client, uriBuilder, configuration, this.builder);
    }

    @Override
    protected ClientInvocationBuilder createClientInvocationBuilder(ResteasyClient client, URI uri, ClientConfiguration configuration) {
        return new LibertyClientInvocationBuilder(client, uri, configuration);
    }

    private void applyConfiguredProperties() {
        String proxyHost;
        Boolean followRedirects;
        try {
            Map<String, String> props = JAXRSClientConfigHolder.getURIProps(this.uriBuilder);
            if (props != null && props.size() > 0) {
                for (String key : props.keySet()) {
                    this.configuration.property(key, props.get(key));
                }
            }
        }
        catch (IllegalArgumentException props) {
            // empty catch block
        }
        JAXRSClientConstants.mapProperties(this.configuration);
        Long timeout = LibertyClientWebTarget.toLong(this.configuration, "com.ibm.ws.jaxrs.client.connection.timeout");
        if (timeout != null) {
            this.builder.connectTimeout(timeout, TimeUnit.MILLISECONDS);
        }
        if ((timeout = LibertyClientWebTarget.toLong(this.configuration, "com.ibm.ws.jaxrs.client.receive.timeout")) != null) {
            this.builder.readTimeout(timeout, TimeUnit.MILLISECONDS);
        }
        if ((followRedirects = LibertyClientWebTarget.toBoolean(this.configuration, "io.openliberty.rest.client.autoFollowRedirects")) != null) {
            ((LibertyResteasyClientImpl)this.client).setAutoFollowRedirects(followRedirects);
        }
        if ((proxyHost = (String)this.configuration.getProperty("org.jboss.resteasy.jaxrs.client.proxy.host")) != null) {
            Integer proxyPort = LibertyClientWebTarget.toInt(this.configuration, "org.jboss.resteasy.jaxrs.client.proxy.port");
            String proxyScheme = (String)this.configuration.getProperty("org.jboss.resteasy.jaxrs.client.proxy.scheme");
            this.builder.defaultProxy(proxyHost, proxyPort == null ? -1 : proxyPort, proxyScheme);
        }
    }

    private static Long toLong(ClientConfiguration configuration, String key) {
        Object o = configuration.getProperty(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        try {
            if (o instanceof String) {
                return Long.parseLong((String)o);
            }
            return (Long)o;
        }
        catch (ClassCastException | NumberFormatException ex) {
            Tr.warning((TraceComponent)tc, (String)"INVALID_LONG_PROPERTY_CWWKW1306W", (Object[])new Object[]{key, o});
            return null;
        }
    }

    private static Integer toInt(ClientConfiguration configuration, String key) {
        Object o = configuration.getProperty(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        try {
            if (o instanceof String) {
                return Integer.parseInt((String)o);
            }
            return (Integer)o;
        }
        catch (ClassCastException | NumberFormatException ex) {
            Tr.warning((TraceComponent)tc, (String)"INVALID_INT_PROPERTY_CWWKW1303W", (Object[])new Object[]{key, o});
            return null;
        }
    }

    private static Boolean toBoolean(ClientConfiguration configuration, String key) {
        Object o = configuration.getProperty(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        try {
            return (Boolean)o;
        }
        catch (ClassCastException ex) {
            Tr.warning((TraceComponent)tc, (String)"INVALID_BOOLEAN_PROPERTY_CWWKW1304W", (Object[])new Object[]{key, o});
            return null;
        }
    }
}

