/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.comms.server.IdToObjectMap;
import com.ibm.ws.sib.jfapchannel.DispatchQueue;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashSet;
import java.util.Iterator;
import javax.transaction.xa.Xid;

public class TransactionToDispatchableMap {
    private static final TraceComponent tc = SibTr.register(TransactionToDispatchableMap.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static String CLASS_NAME = TransactionToDispatchableMap.class.getName();
    private final IdToObjectMap idToFirstLevelEntryMap = new IdToObjectMap();

    public Dispatchable addDispatchableForLocalTransaction(int clientTransactionId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addDispatchableForLocalTransaction", (Object)("" + clientTransactionId));
        }
        if (this.idToFirstLevelEntryMap.containsKey(clientTransactionId)) {
            SIErrorException exception = new SIErrorException("5-005-0001");
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".addDispatchableForLocalTransaction"), (String)"5-005-0001", (Object[])new Object[]{"" + clientTransactionId, this.idToFirstLevelEntryMap, this});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        LocalFirstLevelMapEntry entry = new LocalFirstLevelMapEntry();
        Dispatchable result = entry.getDispatchable();
        this.idToFirstLevelEntryMap.put(clientTransactionId, entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addDispatchableForLocalTransaction", (Object)result);
        }
        return result;
    }

    public Dispatchable addEnlistedDispatchableForGlobalTransaction(int clientXAResourceId, XidProxy xid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addEnlistedDispatchableForGlobalTransaction", (Object)new Object[]{"" + clientXAResourceId});
        }
        AbstractFirstLevelMapEntry firstLevelEntry = null;
        if (this.idToFirstLevelEntryMap.containsKey(clientXAResourceId)) {
            firstLevelEntry = (AbstractFirstLevelMapEntry)this.idToFirstLevelEntryMap.get(clientXAResourceId);
        }
        GlobalFirstLevelMapEntry entry = null;
        if (firstLevelEntry == null) {
            entry = new GlobalFirstLevelMapEntry();
            this.idToFirstLevelEntryMap.put(clientXAResourceId, entry);
        } else {
            if (firstLevelEntry.isLocalTransaction()) {
                SIErrorException exception = new SIErrorException("5-005-0002");
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".addEnlistedDispatchableForGlobalTransaction"), (String)"5-005-0002", (Object[])new Object[]{"" + clientXAResourceId, this.idToFirstLevelEntryMap, this});
                if (tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
                }
                throw exception;
            }
            entry = (GlobalFirstLevelMapEntry)firstLevelEntry;
        }
        Dispatchable result = entry.createNewEnlistedDispatchable(xid);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addEnlistedDispatchableForGlobalTransaction", (Object)result);
        }
        return result;
    }

    public Dispatchable getDispatchable(int clientId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDispatchable", (Object)("" + clientId));
        }
        AbstractFirstLevelMapEntry firstLevelEntry = null;
        if (this.idToFirstLevelEntryMap.containsKey(clientId)) {
            firstLevelEntry = (AbstractFirstLevelMapEntry)this.idToFirstLevelEntryMap.get(clientId);
        }
        Dispatchable result = firstLevelEntry == null ? null : (firstLevelEntry.isLocalTransaction() ? ((LocalFirstLevelMapEntry)firstLevelEntry).getDispatchable() : ((GlobalFirstLevelMapEntry)firstLevelEntry).getEnlistedDispatchable());
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDispatchable", (Object)result);
        }
        return result;
    }

    public Dispatchable removeDispatchableForLocalTransaction(int clientId) {
        Dispatchable result;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeDispatchableForLocalTransaction", (Object)("" + clientId));
        }
        AbstractFirstLevelMapEntry firstLevelEntry = null;
        if (this.idToFirstLevelEntryMap.containsKey(clientId)) {
            firstLevelEntry = (AbstractFirstLevelMapEntry)this.idToFirstLevelEntryMap.get(clientId);
        }
        if (firstLevelEntry == null) {
            result = null;
        } else if (firstLevelEntry.isLocalTransaction()) {
            result = ((LocalFirstLevelMapEntry)firstLevelEntry).getDispatchable();
            this.idToFirstLevelEntryMap.remove(clientId);
        } else {
            SIErrorException exception = new SIErrorException("5-005-0004");
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".removeDispatchableForLocalTransaction"), (String)"5-005-0004", (Object[])new Object[]{"" + clientId, firstLevelEntry, this.idToFirstLevelEntryMap, this});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeDispatchableForLocalTransaction", (Object)result);
        }
        return result;
    }

    public void removeAllDispatchablesForTransaction(int clientId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeAllDispatchablesForTransaction", (Object)clientId);
        }
        this.idToFirstLevelEntryMap.remove(clientId);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeAllDispatchablesForTransaction");
        }
    }

    public Dispatchable removeDispatchableForGlobalTransaction(int clientId, XidProxy xid) {
        Dispatchable result;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeDispatchableForGlobalTransaction", (Object)new Object[]{"" + clientId});
        }
        AbstractFirstLevelMapEntry firstLevelEntry = null;
        if (this.idToFirstLevelEntryMap.containsKey(clientId)) {
            firstLevelEntry = (AbstractFirstLevelMapEntry)this.idToFirstLevelEntryMap.get(clientId);
        }
        if (firstLevelEntry == null) {
            result = null;
        } else if (!firstLevelEntry.isLocalTransaction()) {
            GlobalFirstLevelMapEntry globalEntry = (GlobalFirstLevelMapEntry)firstLevelEntry;
            result = globalEntry.removeDispatchable(xid);
            if (globalEntry.isEmpty()) {
                this.idToFirstLevelEntryMap.remove(clientId);
            }
        } else {
            SIErrorException exception = new SIErrorException("5-005-0005");
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".removeDispatchableForGlobalTransaction"), (String)"5-005-0005", (Object[])new Object[]{"" + clientId, firstLevelEntry, this.idToFirstLevelEntryMap, this});
            if (tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeDispatchableForGlobalTransaction", (Object)result);
        }
        return result;
    }

    public Dispatchable addDispatchableForOptimizedLocalTransaction(int transactionId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addDispatchableForOptimizedLocalTransaction", (Object)("" + transactionId));
        }
        Dispatchable result = this.addDispatchableForLocalTransaction(transactionId);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addDispatchableForOptimizedLocalTransaction", (Object)result);
        }
        return result;
    }

    public int getTotalDispatchables() {
        int count = 0;
        Iterator i = this.idToFirstLevelEntryMap.iterator();
        while (i.hasNext()) {
            ++count;
        }
        return count;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/TransactionToDispatchableMap.java, SIB.comms, WASX.SIB, aa1225.01 1.8");
        }
    }

    private class LocalFirstLevelMapEntry
    extends AbstractFirstLevelMapEntry {
        private final Dispatchable dispatchable;

        private LocalFirstLevelMapEntry() {
            this.dispatchable = new DispatchableImpl();
        }

        @Override
        public boolean isLocalTransaction() {
            return true;
        }

        public Dispatchable getDispatchable() {
            return this.dispatchable;
        }
    }

    private abstract class AbstractFirstLevelMapEntry {
        private AbstractFirstLevelMapEntry() {
        }

        public abstract boolean isLocalTransaction();
    }

    private class GlobalFirstLevelMapEntry
    extends AbstractFirstLevelMapEntry {
        private final Dispatchable dispatchable = new DispatchableImpl();
        private int refCount = 0;
        private final HashSet knownXids = new HashSet();

        private GlobalFirstLevelMapEntry() {
        }

        @Override
        public boolean isLocalTransaction() {
            return false;
        }

        public Dispatchable getEnlistedDispatchable() {
            return this.dispatchable;
        }

        public Dispatchable createNewEnlistedDispatchable(XidProxy xid) {
            ++this.refCount;
            this.knownXids.add(xid);
            return this.dispatchable;
        }

        public Dispatchable removeDispatchable(XidProxy xid) {
            Dispatchable result;
            if (this.knownXids.contains(xid)) {
                --this.refCount;
                result = this.dispatchable;
                this.knownXids.remove(xid);
            } else {
                result = null;
            }
            return result;
        }

        public Dispatchable getDispatchable(Xid xid) {
            Dispatchable result = this.knownXids.contains(xid) ? this.dispatchable : null;
            return result;
        }

        boolean isEmpty() {
            return this.refCount == 0;
        }
    }

    private static class DispatchableImpl
    implements Dispatchable {
        private DispatchQueue queue;
        private final Object dispatchLockObject = new Object();
        private int refCount;

        private DispatchableImpl() {
        }

        public void setDispatchQueue(DispatchQueue queue) {
            this.queue = queue;
        }

        public DispatchQueue getDispatchQueue() {
            return this.queue;
        }

        public Object getDispatchLockObject() {
            return this.dispatchLockObject;
        }

        public void incrementDispatchQueueRefCount() {
            ++this.refCount;
        }

        public void decrementDispatchQueueRefCount() {
            --this.refCount;
        }

        public int getDispatchQueueRefCount() {
            return this.refCount;
        }
    }
}

