/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence.jpa;

import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntityExtractor;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.persistence.jpa.JobThreadExecutionBase;
import com.ibm.jbatch.container.persistence.jpa.RemotablePartitionEntity;
import com.ibm.jbatch.container.persistence.jpa.StepThreadExecutionEntity;
import com.ibm.jbatch.container.ws.WSJobExecution;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.runtime.JobExecution;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.eclipse.persistence.annotations.ClassExtractor;

@NamedQueries(value={@NamedQuery(name="JobExecutionEntity.updateJobExecutionAndInstanceServerNotSet", query="UPDATE JobExecutionEntity x SET x.batchStatus = :batchStatus, x.lastUpdatedTime = :lastUpdatedTime WHERE x.jobExecId = :jobExecId AND x.serverId IS NULL"), @NamedQuery(name="JobExecutionEntity.updateJobExecutionServerIdAndRestUrlForStartingJob", query="UPDATE JobExecutionEntity x SET x.serverId = :serverId, x.restUrl = :restUrl WHERE x.jobExecId = :jobExecId AND x.batchStatus = jakarta.batch.runtime.BatchStatus.STARTING"), @NamedQuery(name="JobExecutionEntity.getJobExecutionsMostToLeastRecentByInstanceQuery", query="SELECT e FROM JobExecutionEntity e WHERE e.jobInstance.instanceId = :instanceId ORDER BY e.executionNumberForThisInstance DESC"), @NamedQuery(name="JobExecutionEntity.getJobExecutionsByJobInstanceId", query="SELECT e.jobExecId FROM JobExecutionEntity e WHERE e.jobInstance.instanceId in :instanceList ORDER BY e.createTime DESC"), @NamedQuery(name="JobExecutionEntity.getJobExecutionsByJobInstanceIdAndStatuses", query="SELECT e.jobExecId FROM JobExecutionEntity e WHERE e.jobInstance.instanceId in :instanceList AND e.batchStatus IN :status ORDER BY e.createTime DESC"), @NamedQuery(name="JobExecutionEntity.getJobExecutionsByNameAndStatusesQuery", query="SELECT e.jobExecId FROM JobExecutionEntity e WHERE e.jobInstance.jobName=:name AND e.batchStatus IN :status ORDER BY e.createTime DESC"), @NamedQuery(name="JobExecutionEntity.getJobExecutionsByServerIdAndStatusesQuery", query="SELECT e FROM JobExecutionEntity e WHERE e.serverId=:serverid AND e.batchStatus IN :status ORDER BY e.createTime DESC"), @NamedQuery(name="JobExecutionEntity.getJobExecutionsByJobInstanceIdAndJobExecNumberQuery", query="SELECT e FROM JobExecutionEntity e WHERE e.jobInstance.instanceId = :instanceId AND e.executionNumberForThisInstance = :jobExecNum")})
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@ClassExtractor(value=JobExecutionEntityExtractor.class)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JobExecutionEntity
extends JobThreadExecutionBase
implements JobExecution,
WSJobExecution {
    protected static String eol;
    public static final String UPDATE_JOB_EXECUTION_AND_INSTANCE_SERVER_NOT_SET = "JobExecutionEntity.updateJobExecutionAndInstanceServerNotSet";
    public static final String UPDATE_JOB_EXECUTION_SERVERID_AND_RESTURL_FOR_STARTING_JOB = "JobExecutionEntity.updateJobExecutionServerIdAndRestUrlForStartingJob";
    public static final String GET_JOB_EXECUTIONIDS_BY_NAME_AND_STATUSES_QUERY = "JobExecutionEntity.getJobExecutionsByNameAndStatusesQuery";
    public static final String GET_JOB_EXECUTIONS_BY_SERVERID_AND_STATUSES_QUERY = "JobExecutionEntity.getJobExecutionsByServerIdAndStatusesQuery";
    public static final String GET_JOB_EXECUTIONS_MOST_TO_LEAST_RECENT_BY_INSTANCE = "JobExecutionEntity.getJobExecutionsMostToLeastRecentByInstanceQuery";
    public static final String GET_JOB_EXECUTIONS_BY_JOB_INST_ID_AND_JOB_EXEC_NUM = "JobExecutionEntity.getJobExecutionsByJobInstanceIdAndJobExecNumberQuery";
    public static final String GET_JOB_EXECUTIONIDS_BY_JOB_INST_ID = "JobExecutionEntity.getJobExecutionsByJobInstanceId";
    public static final String GET_JOB_EXECUTIONIDS_BY_JOB_INST_ID_AND_STATUSES = "JobExecutionEntity.getJobExecutionsByJobInstanceIdAndStatuses";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="JOBEXECID", nullable=false)
    private long jobExecId;
    @Lob
    @Column(name="JOBPARAMETERS")
    protected Properties jobParameters;
    @Column(name="EXECNUM", nullable=false)
    private int executionNumberForThisInstance = 0;
    @ManyToOne
    @JoinColumn(name="FK_JOBINSTANCEID", nullable=false)
    private JobInstanceEntity jobInstance;
    @OneToMany(mappedBy="jobExec", cascade={CascadeType.REMOVE})
    private Collection<StepThreadExecutionEntity> stepThreadExecutions;
    static final long serialVersionUID = -2210724937968276009L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public JobExecutionEntity() {
    }

    public JobExecutionEntity(long jobExecId) {
        this.jobExecId = jobExecId;
        this.stepThreadExecutions = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public JobInstanceEntity getJobInstance() {
        return this.jobInstance;
    }

    public void setJobInstance(JobInstanceEntity jobInstance) {
        this.jobInstance = jobInstance;
    }

    public Collection<StepThreadExecutionEntity> getStepThreadExecutions() {
        return this.stepThreadExecutions;
    }

    public void setStepThreadExecutions(Collection<StepThreadExecutionEntity> stepThreadExecutions) {
        this.stepThreadExecutions = stepThreadExecutions;
    }

    public Collection<RemotablePartitionEntity> getRemotablePartitions() {
        return null;
    }

    public void setRemotablePartitions(Collection<RemotablePartitionEntity> remotablePartitions) {
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }

    public void setJobParameters(Properties jobParameters) {
        this.jobParameters = this.trimJESParameters(jobParameters);
    }

    protected Properties trimJESParameters(Properties jobParameters) {
        if (jobParameters != null) {
            String jesJobName = jobParameters.getProperty("com.ibm.ws.batch.submitter.jobName");
            String jesJobID = jobParameters.getProperty("com.ibm.ws.batch.submitter.jobId");
            if (jesJobName != null) {
                jobParameters.put("com.ibm.ws.batch.submitter.jobName", jesJobName.trim());
            }
            if (jesJobID != null) {
                jobParameters.put("com.ibm.ws.batch.submitter.jobId", jesJobID.trim());
            }
        }
        return jobParameters;
    }

    public long getExecutionId() {
        return this.jobExecId;
    }

    public String getJobName() {
        return this.jobInstance.getJobName() == null ? "" : this.jobInstance.getJobName();
    }

    @Override
    public long getInstanceId() {
        return this.jobInstance.getInstanceId();
    }

    @Override
    public int getExecutionNumberForThisInstance() {
        return this.executionNumberForThisInstance;
    }

    public void setExecutionNumberForThisInstance(int executionNumberForThisInstance) {
        this.executionNumberForThisInstance = executionNumberForThisInstance;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(super.toString() + eol);
        buf.append("For JobExecutionEntity:");
        buf.append(" execution Id = " + this.jobExecId);
        buf.append(", execution sequence num = " + this.executionNumberForThisInstance);
        buf.append(", instance = " + this.jobInstance);
        return buf.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity", JobExecutionEntity.class, (String)"wsbatch", null);
        eol = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -2551695608491302388L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty("line.separator");
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity$1", 1.class, (String)"wsbatch", null);
            }
        });
    }
}

