/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.Map;

public class HttpFactoryConfig {
    private static final TraceComponent tc = Tr.register(HttpFactoryConfig.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private long msgSizeLimit = -1L;
    private long msgSizeLargeBuffer = -1L;

    public HttpFactoryConfig(Map<Object, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Parsing config for factory", (Object[])new Object[0]);
        }
        if (null != props) {
            this.parseMsgSize(props);
            this.parseMsgLargeBuffer(props);
        }
    }

    private void parseMsgSize(Map<Object, Object> props) {
        block5: {
            String value = (String)props.get("MessageSizeLimit");
            if (null != value) {
                try {
                    this.msgSizeLimit = Long.parseLong(value);
                    if (-1L > this.getMessageSize()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((TraceComponent)tc, (String)("Config: Invalid size, setting to unlimited: " + this.msgSizeLimit), (Object[])new Object[0]);
                        }
                        this.msgSizeLimit = -1L;
                    }
                }
                catch (NumberFormatException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block5;
                    Tr.event((TraceComponent)tc, (String)("Config: Invalid maximum message size; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    public long getMessageSize() {
        return this.msgSizeLimit;
    }

    public boolean areMessagesLimited() {
        return -1L != this.getMessageSize();
    }

    private void parseMsgLargeBuffer(Map<Object, Object> props) {
        block6: {
            if (!this.areMessagesLimited()) {
                return;
            }
            String value = (String)props.get("LargeMessageSize");
            if (null != value) {
                try {
                    long limit = Long.parseLong(value);
                    if (limit < this.getMessageSize() || -1L > limit) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Config: Invalid large buffer limit: " + limit), (Object[])new Object[0]);
                        }
                        limit = this.getMessageSize();
                    }
                    this.msgSizeLargeBuffer = limit;
                }
                catch (NumberFormatException e) {
                    if (!tc.isEventEnabled()) break block6;
                    Tr.event((TraceComponent)tc, (String)("Config: Non-numeric large buffer size; " + value), (Object[])new Object[0]);
                }
            }
        }
    }

    public long getLargerBufferSize() {
        return this.msgSizeLargeBuffer;
    }
}

