/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;

class TransactionPrepareLogRecord
extends LogRecord {
    private static final Class cclass = TransactionPrepareLogRecord.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    private static final long serialVersionUID = 7987670188023170217L;
    protected LogicalUnitOfWork logicalUnitOfWork;

    protected TransactionPrepareLogRecord(InternalTransaction internalTransaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{internalTransaction});
        }
        this.logicalUnitOfWork = internalTransaction.getLogicalUnitOfWork();
        this.buffers = this.getBuffers(internalTransaction.logRecordByteArrayOutputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected TransactionPrepareLogRecord(DataInputStream dataInputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", dataInputStream);
        }
        this.logicalUnitOfWork = new LogicalUnitOfWork(dataInputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public ObjectManagerByteArrayOutputStream[] getBuffers(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getBuffers", new Object[]{byteArrayOutputStream});
        }
        Object[] buffers = new ObjectManagerByteArrayOutputStream[1];
        byteArrayOutputStream.reset();
        buffers[0] = byteArrayOutputStream;
        buffers[0].writeInt(5);
        this.logicalUnitOfWork.writeSerializedBytes(buffers[0]);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", buffers);
        }
        return buffers;
    }

    @Override
    public void performRecovery(ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", new Object[]{objectManagerState, this.logicalUnitOfWork});
        }
        Transaction transactionForRecovery = objectManagerState.getTransaction(this.logicalUnitOfWork);
        transactionForRecovery.prepare();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }
}

