/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.cdi.beans;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.cdi.beans.Utils;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.CDI;
import javax.security.auth.Subject;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.authentication.mechanism.http.LoginToContinue;
import javax.security.enterprise.credential.Credential;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Default
@ApplicationScoped
@LoginToContinue
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CustomFormAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final TraceComponent tc = Tr.register(CustomFormAuthenticationMechanism.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.cdi.internal.resources.JavaEESecMessages");
    private final Utils utils;
    static final long serialVersionUID = 6828998563553729345L;

    public CustomFormAuthenticationMechanism() {
        this.utils = new Utils();
    }

    protected CustomFormAuthenticationMechanism(Utils utils) {
        this.utils = utils;
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        AuthenticationStatus status = AuthenticationStatus.SEND_FAILURE;
        Subject clientSubject = httpMessageContext.getClientSubject();
        AuthenticationParameters authParams = httpMessageContext.getAuthParameters();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AuthenticationParameters : " + authParams), (Object[])new Object[0]);
        }
        if (authParams == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No AuthenticationParameters object, redirecting", (Object[])new Object[0]);
            }
            status = AuthenticationStatus.SEND_CONTINUE;
        } else {
            Credential cred = authParams.getCredential();
            if (cred == null) {
                if (!httpMessageContext.isAuthenticationRequest() && !httpMessageContext.isProtected()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"both isAuthenticationRequest and isProtected return false. returing NOT_DONE,", (Object[])new Object[0]);
                    }
                    status = AuthenticationStatus.NOT_DONE;
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"No Credential object, redirecting", (Object[])new Object[0]);
                    }
                    status = AuthenticationStatus.SEND_CONTINUE;
                }
            } else {
                status = this.handleFormLogin(cred, clientSubject, httpMessageContext);
            }
        }
        return status;
    }

    public AuthenticationStatus secureResponse(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        return AuthenticationStatus.SUCCESS;
    }

    public void cleanSubject(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) {
    }

    private AuthenticationStatus handleFormLogin(@Sensitive Credential credential, Subject clientSubject, HttpMessageContext httpMessageContext) throws AuthenticationException {
        int rspStatus;
        AuthenticationStatus status = this.utils.handleAuthenticate(this.getCDI(), "defaultRealm", credential, clientSubject, httpMessageContext);
        if (status == AuthenticationStatus.SUCCESS) {
            Map messageInfoMap = httpMessageContext.getMessageInfo().getMap();
            messageInfoMap.put("javax.servlet.http.authType", "CUSTOM_FORM");
            messageInfoMap.put("javax.servlet.http.registerSession", Boolean.TRUE.toString());
            rspStatus = 200;
        } else if (status == AuthenticationStatus.NOT_DONE) {
            rspStatus = 200;
        } else {
            httpMessageContext.responseUnauthorized();
            rspStatus = 401;
        }
        httpMessageContext.getResponse().setStatus(rspStatus);
        return status;
    }

    @FFDCIgnore(value={IllegalStateException.class})
    protected CDI getCDI() {
        try {
            return CDI.current();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

