/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.jmx.internal;

import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServerBuilderListener;
import com.ibm.ws.kernel.boot.jmx.internal.PlatformMBeanServerDelegate;
import com.ibm.ws.kernel.boot.jmx.service.DelayedMBeanHelper;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerForwarderDelegate;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerPipeline;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public final class PlatformMBeanServer
implements MBeanServer {
    private volatile MBeanServer first;
    private final MBeanServer last;
    private final PlatformMBeanServerDelegate mbServerDelegate;
    private final MBeanServerPipeline pipeline = new MBeanServerPipeline(){

        @Override
        public synchronized boolean contains(MBeanServerForwarderDelegate filter) {
            if (filter != null) {
                MBeanServerForwarderDelegate next;
                MBeanServerForwarderDelegate mBeanServerForwarderDelegate = next = PlatformMBeanServer.this.first instanceof MBeanServerForwarderDelegate ? (MBeanServerForwarderDelegate)PlatformMBeanServer.this.first : null;
                while (next != null) {
                    if (filter == next) {
                        return true;
                    }
                    MBeanServer _next = next.getMBeanServer();
                    next = _next instanceof MBeanServerForwarderDelegate ? (MBeanServerForwarderDelegate)_next : null;
                }
            }
            return false;
        }

        @Override
        public synchronized boolean insert(MBeanServerForwarderDelegate filter) {
            if (filter != null && !this.contains(filter)) {
                MBeanServerForwarderDelegate prev = null;
                MBeanServerForwarderDelegate next = PlatformMBeanServer.this.first instanceof MBeanServerForwarderDelegate ? (MBeanServerForwarderDelegate)PlatformMBeanServer.this.first : null;
                while (true) {
                    int nextPriority;
                    int n = nextPriority = next != null ? next.getPriority() : 0;
                    if (filter.getPriority() >= nextPriority) break;
                    if (next == null) {
                        return false;
                    }
                    prev = next;
                    MBeanServer _next = next.getMBeanServer();
                    next = _next instanceof MBeanServerForwarderDelegate ? (MBeanServerForwarderDelegate)_next : null;
                }
                if (filter instanceof DelayedMBeanHelper) {
                    DelayedMBeanHelper helper = (DelayedMBeanHelper)((Object)filter);
                    helper.setMBeanServerNotificationSupport(PlatformMBeanServer.this.mbServerDelegate);
                    PlatformMBeanServer.this.mbServerDelegate.addDelayedMBeanHelper(helper);
                }
                filter.setMBeanServer(next != null ? next : PlatformMBeanServer.this.last);
                if (prev != null) {
                    prev.setMBeanServer(filter);
                } else {
                    PlatformMBeanServer.this.first = filter;
                }
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean remove(MBeanServerForwarderDelegate filter) {
            if (filter != null) {
                MBeanServer _next;
                MBeanServerForwarderDelegate next;
                MBeanServerForwarderDelegate prev = null;
                MBeanServerForwarderDelegate mBeanServerForwarderDelegate = next = PlatformMBeanServer.this.first instanceof MBeanServerForwarderDelegate ? (MBeanServerForwarderDelegate)PlatformMBeanServer.this.first : null;
                while (filter != next) {
                    if (next == null) {
                        return false;
                    }
                    prev = next;
                    _next = next.getMBeanServer();
                    next = _next instanceof MBeanServerForwarderDelegate ? (MBeanServerForwarderDelegate)_next : null;
                }
                if (filter instanceof DelayedMBeanHelper) {
                    DelayedMBeanHelper helper = (DelayedMBeanHelper)((Object)filter);
                    helper.setMBeanServerNotificationSupport(null);
                    PlatformMBeanServer.this.mbServerDelegate.removeDelayedMBeanHelper(helper);
                }
                _next = filter.getMBeanServer();
                if (prev != null) {
                    prev.setMBeanServer(_next);
                } else {
                    PlatformMBeanServer.this.first = _next;
                }
                return true;
            }
            return false;
        }
    };

    PlatformMBeanServer(MBeanServer mbs, PlatformMBeanServerDelegate delegate) {
        this.first = mbs;
        this.last = mbs;
        this.mbServerDelegate = delegate;
    }

    public void invokePlatformMBeanServerCreated(PlatformMBeanServerBuilderListener listener) {
        listener.platformMBeanServerCreated(this.pipeline);
    }

    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        block4: {
            if (System.getSecurityManager() == null) {
                this.first.addNotificationListener(name, listener, filter, handback);
            } else {
                final ObjectName f_name = name;
                final NotificationListener f_listener = listener;
                final NotificationFilter f_filter = filter;
                final Object f_handback = handback;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws InstanceNotFoundException {
                            PlatformMBeanServer.this.first.addNotificationListener(f_name, f_listener, f_filter, f_handback);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof InstanceNotFoundException)) break block4;
                    throw (InstanceNotFoundException)cause;
                }
            }
        }
    }

    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        block4: {
            if (System.getSecurityManager() == null) {
                this.first.addNotificationListener(name, listener, filter, handback);
            } else {
                final ObjectName f_name = name;
                final ObjectName f_listener = listener;
                final NotificationFilter f_filter = filter;
                final Object f_handback = handback;
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws InstanceNotFoundException {
                            PlatformMBeanServer.this.first.addNotificationListener(f_name, f_listener, f_filter, f_handback);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof InstanceNotFoundException)) break block4;
                    throw (InstanceNotFoundException)cause;
                }
            }
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.first.createMBean(className, name);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.first.createMBean(className, name, loaderName);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.first.createMBean(className, name, params, signature);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.first.createMBean(className, name, loaderName, params, signature);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        return this.first.deserialize(name, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        return this.first.deserialize(className, data);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        return this.first.deserialize(className, loaderName, data);
    }

    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (System.getSecurityManager() == null) {
            return this.first.getAttribute(name, attribute);
        }
        final ObjectName f_name = name;
        final String f_attribute = attribute;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
                    return PlatformMBeanServer.this.first.getAttribute(f_name, f_attribute);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)cause;
            }
            if (cause instanceof MBeanException) {
                throw (MBeanException)cause;
            }
            if (cause instanceof ReflectionException) {
                throw (ReflectionException)cause;
            }
            if (cause instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)cause;
            }
            return null;
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        return this.first.getAttributes(name, attributes);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        return this.first.getClassLoader(loaderName);
    }

    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        block3: {
            if (System.getSecurityManager() == null) {
                return this.first.getClassLoaderFor(mbeanName);
            }
            final ObjectName f_mbeanName = mbeanName;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws InstanceNotFoundException {
                        return PlatformMBeanServer.this.first.getClassLoaderFor(f_mbeanName);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof InstanceNotFoundException)) break block3;
                throw (InstanceNotFoundException)cause;
            }
        }
        return null;
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return this.first.getClassLoaderRepository();
    }

    @Override
    public String getDefaultDomain() {
        return this.first.getDefaultDomain();
    }

    @Override
    public String[] getDomains() {
        return this.first.getDomains();
    }

    @Override
    public Integer getMBeanCount() {
        return this.first.getMBeanCount();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return this.first.getMBeanInfo(name);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.first.getObjectInstance(name);
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        return this.first.instantiate(className);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.first.instantiate(className, loaderName);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        return this.first.instantiate(className, params, signature);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.first.instantiate(className, loaderName, params, signature);
    }

    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (System.getSecurityManager() == null) {
            return this.first.invoke(name, operationName, params, signature);
        }
        final ObjectName f_name = name;
        final String f_operationName = operationName;
        final Object[] f_params = params;
        final String[] f_signature = signature;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws InstanceNotFoundException, MBeanException, ReflectionException {
                    return PlatformMBeanServer.this.first.invoke(f_name, f_operationName, f_params, f_signature);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)cause;
            }
            if (cause instanceof MBeanException) {
                throw (MBeanException)cause;
            }
            if (cause instanceof ReflectionException) {
                throw (ReflectionException)cause;
            }
            return null;
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.first.isInstanceOf(name, className);
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        return this.first.isRegistered(name);
    }

    @Override
    @FFDCIgnore(value={PrivilegedActionException.class})
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        if (System.getSecurityManager() == null) {
            return this.first.queryMBeans(name, query);
        }
        final ObjectName f_name = name;
        final QueryExp f_query = query;
        return AccessController.doPrivileged(new PrivilegedAction<Set<ObjectInstance>>(){

            @Override
            public Set<ObjectInstance> run() {
                return PlatformMBeanServer.this.first.queryMBeans(f_name, f_query);
            }
        });
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.first.queryNames(name, query);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.first.registerMBean(object, name);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.first.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.first.removeNotificationListener(name, listener);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.first.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        this.first.removeNotificationListener(name, listener, filter, handback);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.first.setAttribute(name, attribute);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        return this.first.setAttributes(name, attributes);
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        this.first.unregisterMBean(name);
    }
}

