/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class DiscoveredBdas {
    private static final TraceComponent tc = Tr.register(DiscoveredBdas.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    private final Map<ArchiveType, Set<WebSphereBeanDeploymentArchive>> bdasByType;
    private final Set<String> libraryPaths;
    private final Set<String> modulePaths;
    private final WebSphereCDIDeployment webSphereCDIDeployment;
    static final long serialVersionUID = 3807926573257190604L;

    public DiscoveredBdas(WebSphereCDIDeployment webSphereCDIDeployment) {
        ArchiveType[] types;
        this.webSphereCDIDeployment = webSphereCDIDeployment;
        this.bdasByType = new HashMap<ArchiveType, Set<WebSphereBeanDeploymentArchive>>();
        for (ArchiveType type : types = new ArchiveType[]{ArchiveType.SHARED_LIB, ArchiveType.EAR_LIB, ArchiveType.RAR_MODULE, ArchiveType.EJB_MODULE, ArchiveType.WEB_MODULE, ArchiveType.CLIENT_MODULE}) {
            this.bdasByType.put(type, new HashSet());
        }
        this.libraryPaths = new HashSet<String>();
        this.modulePaths = new HashSet<String>();
    }

    public boolean isAlreadyAccessible(ArchiveType archiveType, CDIArchive archive) throws CDIException {
        String path = archive.getPath();
        if (this.libraryPaths.contains(path)) {
            return true;
        }
        if (archiveType == ArchiveType.EAR_LIB || archiveType == ArchiveType.RAR_MODULE || archiveType == ArchiveType.EJB_MODULE || archiveType == ArchiveType.WEB_MODULE || archiveType == ArchiveType.CLIENT_MODULE) {
            return this.modulePaths.contains(path);
        }
        return false;
    }

    public void addDiscoveredBda(ArchiveType moduleType, WebSphereBeanDeploymentArchive bda) throws CDIException {
        this.webSphereCDIDeployment.addBeanDeploymentArchive(bda);
        Set<WebSphereBeanDeploymentArchive> bdaSet = this.bdasByType.get(moduleType);
        if (bdaSet != null) {
            bdaSet.add(bda);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Ignore this type: {0}, as CDI does not need to add this in the addDiscoveredBda ", (Object[])new Object[]{moduleType});
        }
        String path = bda.getArchive().getPath();
        if (moduleType == ArchiveType.SHARED_LIB || moduleType == ArchiveType.EAR_LIB) {
            this.libraryPaths.add(path);
        } else if (moduleType == ArchiveType.RAR_MODULE || moduleType == ArchiveType.EJB_MODULE) {
            this.modulePaths.add(path);
        }
    }

    public void makeCrossBoundaryWiring() throws CDIException {
        Collection sharedLibs = this.bdasByType.get(ArchiveType.SHARED_LIB);
        Collection earLibs = this.bdasByType.get(ArchiveType.EAR_LIB);
        Collection rarModules = this.bdasByType.get(ArchiveType.RAR_MODULE);
        Collection ejbModules = this.bdasByType.get(ArchiveType.EJB_MODULE);
        Collection warModules = this.bdasByType.get(ArchiveType.WEB_MODULE);
        Collection clientModules = this.bdasByType.get(ArchiveType.CLIENT_MODULE);
        HashSet<WebSphereBeanDeploymentArchive> allAccessibleBdas = new HashSet<WebSphereBeanDeploymentArchive>();
        allAccessibleBdas.addAll(sharedLibs);
        allAccessibleBdas.addAll(earLibs);
        allAccessibleBdas.addAll(ejbModules);
        allAccessibleBdas.addAll(rarModules);
        this.wireBdas(earLibs, allAccessibleBdas);
        this.wireBdas(rarModules, allAccessibleBdas);
        this.wireBdas(ejbModules, allAccessibleBdas);
        this.wireBdas(warModules, allAccessibleBdas);
        this.wireBdas(clientModules, allAccessibleBdas);
        this.wireBdasBasedOnClassLoader(earLibs, warModules);
        this.wireBdasBasedOnClassLoader(sharedLibs, allAccessibleBdas);
    }

    private void wireBdas(Collection<WebSphereBeanDeploymentArchive> wireFromBdas, Collection<WebSphereBeanDeploymentArchive> wireToBdas) {
        for (WebSphereBeanDeploymentArchive wireFromBda : wireFromBdas) {
            Collection accessibleBdas = wireFromBda.getBeanDeploymentArchives();
            for (WebSphereBeanDeploymentArchive wireToBda : wireToBdas) {
                if (wireToBda == wireFromBda || accessibleBdas != null && accessibleBdas.contains(wireToBda)) continue;
                wireFromBda.addBeanDeploymentArchive(wireToBda);
            }
        }
    }

    private void wireBdasBasedOnClassLoader(Collection<WebSphereBeanDeploymentArchive> wireFromBdas, Collection<WebSphereBeanDeploymentArchive> wireToBdas) throws CDIException {
        for (WebSphereBeanDeploymentArchive wireFromBda : wireFromBdas) {
            Collection accessibleBdas = wireFromBda.getBeanDeploymentArchives();
            for (WebSphereBeanDeploymentArchive wireToBda : wireToBdas) {
                if (wireToBda == wireFromBda || accessibleBdas != null && accessibleBdas.contains(wireToBda)) continue;
                CDIUtils.addWiring((WebSphereBeanDeploymentArchive)wireFromBda, (WebSphereBeanDeploymentArchive)wireToBda);
            }
        }
    }

    public boolean isExcluded(WebSphereBeanDeploymentArchive bda) {
        return this.bdasByType.get(ArchiveType.CLIENT_MODULE).contains(bda);
    }
}

