/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.smallrye.metrics.adapters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SRMetricRegistryAdapter {
    private static final TraceComponent tc = Tr.register(SRMetricRegistryAdapter.class, null, null);
    private Method addNameToApplicationMapMethod = null;
    private Method unRegisterApplicationMetricsMethod_StringParam = null;
    private Method functionCounter = null;
    private final Object srMetricRegistryObject;
    static final long serialVersionUID = 6088887576238784715L;

    public SRMetricRegistryAdapter(Object metricRegistryObject) {
        this.srMetricRegistryObject = metricRegistryObject;
        try {
            this.addNameToApplicationMapMethod = this.srMetricRegistryObject.getClass().getMethod("addNameToApplicationMap", MetricID.class);
            this.functionCounter = this.srMetricRegistryObject.getClass().getMethod("counter", Metadata.class, Object.class, ToDoubleFunction.class, Tag[].class);
            this.unRegisterApplicationMetricsMethod_StringParam = this.srMetricRegistryObject.getClass().getMethod("unRegisterApplicationMetrics", String.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.adapters.SRMetricRegistryAdapter", (String)"72", (Object)this, (Object[])new Object[]{metricRegistryObject});
        }
    }

    public void addNameToApplicationMap(MetricID metricID) {
        try {
            if (this.addNameToApplicationMapMethod == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to load by reflection the expected LegacyMetricRegistry.addNameToApplicationMap(MetricID) method.", (Object[])new Object[0]);
                }
                return;
            }
            this.addNameToApplicationMapMethod.invoke(this.srMetricRegistryObject, metricID);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.adapters.SRMetricRegistryAdapter", (String)"92", (Object)this, (Object[])new Object[]{metricID});
        }
    }

    public void unRegisterApplicationMetrics(String name) {
        try {
            if (this.unRegisterApplicationMetricsMethod_StringParam == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to load by reflection the expected LegacyMetricRegistry.unRegisterApplicationMetrics(String) method.", (Object[])new Object[0]);
                }
                return;
            }
            this.unRegisterApplicationMetricsMethod_StringParam.invoke(this.srMetricRegistryObject, name);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.adapters.SRMetricRegistryAdapter", (String)"111", (Object)this, (Object[])new Object[]{name});
        }
    }

    public <T> void functionCounter(Metadata metadata, T obj, ToDoubleFunction<T> function, Tag ... tags) {
        try {
            if (this.functionCounter == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to load by reflection the expected LegacyMetricRegistry.counter(Metadata, T, ToDoubleFunction<T>, Tag...) method.", (Object[])new Object[0]);
                }
                return;
            }
            this.functionCounter.invoke(this.srMetricRegistryObject, metadata, obj, function, tags);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.adapters.SRMetricRegistryAdapter", (String)"130", (Object)this, (Object[])new Object[]{metadata, obj, function, tags});
        }
    }
}

