/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.tokens;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.security.enterprise.identitystore.openid.Claims;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClaimsImpl
implements Claims,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(ClaimsImpl.class, (String)"OpenIdConnect", (String)"io.openliberty.security.jakartasec.internal.resources.JakartaSecurity30Messages");
    private final Map<String, Object> claims = Collections.synchronizedMap(new HashMap());

    public ClaimsImpl(Map<String, Object> claimsMap) {
        this.claims.putAll(claimsMap);
    }

    public Optional<String> getStringClaim(String name) {
        String value = (String)this.getClaim(name);
        if (value != null) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Instant> getNumericDateClaim(String name) {
        try {
            Long value = (Long)this.claims.get(name);
            if (value != null) {
                Instant instant = Instant.ofEpochSecond(value);
                return Optional.of(instant);
            }
            return Optional.empty();
        }
        catch (ClassCastException | DateTimeException value) {
            void e;
            FFDCFilter.processException((Throwable)value, (String)"io.openliberty.security.jakartasec.tokens.ClaimsImpl", (String)"67", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAKARTASEC_CLAIMS_PROCESSING_ERROR", (Object[])new Object[]{name, this.claims.get(name), "NumericDate", e.toString()});
            throw new IllegalArgumentException(msg, (Throwable)e);
        }
    }

    public List<String> getArrayStringClaim(String name) {
        List<String> result;
        Object value = this.claims.get(name);
        if (value == null) {
            result = Collections.emptyList();
        } else if (value instanceof String) {
            result = new ArrayList<String>();
            result.add((String)value);
        } else if (value instanceof List) {
            result = new ArrayList<String>();
            result.addAll((List)value);
        } else {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAKARTASEC_CLAIMS_PROCESSING_ERROR", (Object[])new Object[]{name, this.claims.get(name), "ArrayString", "Type is not String or List"});
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public OptionalInt getIntClaim(String name) {
        try {
            Long value = (Long)this.claims.get(name);
            if (value != null) {
                return OptionalInt.of(value.intValue());
            }
            return OptionalInt.empty();
        }
        catch (ClassCastException value) {
            void e;
            FFDCFilter.processException((Throwable)value, (String)"io.openliberty.security.jakartasec.tokens.ClaimsImpl", (String)"107", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAKARTASEC_CLAIMS_PROCESSING_ERROR", (Object[])new Object[]{name, this.claims.get(name), "Integer", e.toString()});
            throw new IllegalArgumentException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public OptionalLong getLongClaim(String name) {
        try {
            Long value = (Long)this.claims.get(name);
            if (value != null) {
                return OptionalLong.of(value);
            }
            return OptionalLong.empty();
        }
        catch (ClassCastException value) {
            void e;
            FFDCFilter.processException((Throwable)value, (String)"io.openliberty.security.jakartasec.tokens.ClaimsImpl", (String)"123", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAKARTASEC_CLAIMS_PROCESSING_ERROR", (Object[])new Object[]{name, this.claims.get(name), "Long", e.toString()});
            throw new IllegalArgumentException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public OptionalDouble getDoubleClaim(String name) {
        try {
            Double value = (Double)this.claims.get(name);
            if (value != null) {
                return OptionalDouble.of(value);
            }
            return OptionalDouble.empty();
        }
        catch (ClassCastException value) {
            void e;
            FFDCFilter.processException((Throwable)value, (String)"io.openliberty.security.jakartasec.tokens.ClaimsImpl", (String)"139", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAKARTASEC_CLAIMS_PROCESSING_ERROR", (Object[])new Object[]{name, this.claims.get(name), "Double", e.toString()});
            throw new IllegalArgumentException(msg, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Optional<Claims> getNested(String name) {
        Optional<Claims> result;
        Object value = this.claims.get(name);
        if (value == null) {
            result = Optional.empty();
        } else if (value instanceof Map) {
            try {
                ClaimsImpl nestedClaims = new ClaimsImpl((Map)value);
                result = Optional.of(nestedClaims);
            }
            catch (Exception nestedClaims) {
                void e;
                FFDCFilter.processException((Throwable)nestedClaims, (String)"io.openliberty.security.jakartasec.tokens.ClaimsImpl", (String)"158", (Object)this, (Object[])new Object[]{name});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAKARTASEC_CLAIMS_PROCESSING_ERROR", (Object[])new Object[]{name, value, "Nested", e.toString()});
                throw new IllegalArgumentException(msg, (Throwable)e);
            }
        } else {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAKARTASEC_CLAIMS_PROCESSING_ERROR", (Object[])new Object[]{name, value, "Nested", "Type is not Map"});
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T getClaim(String name) {
        try {
            if (this.claims.containsKey(name)) {
                return (T)this.claims.get(name);
            }
        }
        catch (ClassCastException classCastException) {
            void e;
            FFDCFilter.processException((Throwable)classCastException, (String)"io.openliberty.security.jakartasec.tokens.ClaimsImpl", (String)"176", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JAKARTASEC_CLAIMS_PROCESSING_ERROR", (Object[])new Object[]{name, this.claims.get(name), "Generic Type", e.toString()});
            throw new IllegalArgumentException(msg, (Throwable)e);
        }
        return null;
    }
}

