/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.TransactionManagementException;
import com.ibm.jbatch.container.execution.impl.RuntimeStepExecution;
import com.ibm.jbatch.container.transaction.impl.DefaultNonTransactionalManager;
import com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.ITransactionManagementService;
import com.ibm.jbatch.spi.services.TransactionManagerAdapter;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class BatchTransactionServiceImpl
implements ITransactionManagementService {
    private static final String CLASSNAME = BatchTransactionServiceImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig;
    boolean osgiDS;
    private static final String LOCAL_TRAN_PROP_NAME = "com.ibm.jbatch.container.services.impl.BatchTransactionServiceImpl.LocalTran";
    static final long serialVersionUID = -3013724095970304205L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchTransactionServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.BatchTransactionServiceImpl", "<init>", new Object[0]);
        }
        this.batchConfig = null;
        this.osgiDS = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.BatchTransactionServiceImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate(ComponentContext context) throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.BatchTransactionServiceImpl", "activate", new Object[]{context});
        }
        this.osgiDS = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.BatchTransactionServiceImpl", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate(ComponentContext context) throws Exception {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.services.impl.BatchTransactionServiceImpl", "deactivate", new Object[]{context});
        }
        this.osgiDS = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.services.impl.BatchTransactionServiceImpl", "deactivate");
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.entering(CLASSNAME, "init", batchConfig);
        this.batchConfig = batchConfig;
        logger.exiting(CLASSNAME, "init");
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void shutdown() throws BatchContainerServiceException {
        logger.entering(CLASSNAME, "shutdown");
        logger.fine("do nothing");
        logger.exiting(CLASSNAME, "shutdown");
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TransactionManagerAdapter getTransactionManager(RuntimeStepExecution stepExec) throws TransactionManagementException {
        logger.entering(CLASSNAME, "getTransactionManagerServicesManager", stepExec);
        TransactionManagerAdapter adapter = null;
        adapter = this.osgiDS ? this.getTransactionManagerDS(stepExec) : this.getTransactionManagerServicesManager(stepExec);
        logger.exiting(CLASSNAME, "getTransactionManager", adapter);
        return adapter;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TransactionManagerAdapter getTransactionManagerDS(RuntimeStepExecution stepExec) throws TransactionManagementException {
        logger.entering(CLASSNAME, "getTransactionManagerDS");
        logger.fine("On DS path, getting transaction object from JNDI java:comp/UserTransaction");
        TransactionManagerAdapter transactionManager = null;
        if (this.isLocalTran(stepExec)) {
            logger.fine("On DS path, using non-transactional adapter");
            transactionManager = new DefaultNonTransactionalManager();
        } else {
            logger.fine("On DS path, getting transaction object from JNDI java:comp/UserTransaction");
            transactionManager = new JTAUserTransactionAdapter("java:comp/UserTransaction");
        }
        logger.exiting(CLASSNAME, "getTransactionManagerDS", transactionManager);
        return transactionManager;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TransactionManagerAdapter getTransactionManagerServicesManager(RuntimeStepExecution stepExec) throws TransactionManagementException {
        logger.entering(CLASSNAME, "getTransactionManagerServicesManager");
        TransactionManagerAdapter transactionManager = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.fine("getting transaction object from JNDI java:comp/UserTransaction");
            transactionManager = new JTAUserTransactionAdapter("java:comp/UserTransaction");
        } else if (this.batchConfig.isJ2seMode()) {
            logger.fine("J2SE mode non-transactional manager");
            transactionManager = new DefaultNonTransactionalManager();
        }
        logger.exiting(CLASSNAME, "getTransactionManagerServicesManager", transactionManager);
        return transactionManager;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isLocalTran(RuntimeStepExecution stepExec) {
        logger.entering(CLASSNAME, "isLocalTran");
        boolean retVal = false;
        String propVal = stepExec.getProperties().getProperty(LOCAL_TRAN_PROP_NAME);
        if (propVal != null) {
            retVal = Boolean.getBoolean(propVal);
        }
        logger.exiting(CLASSNAME, "isLocalTran", retVal);
        return retVal;
    }
}

